/*
 * Decompiled with CFR 0.152.
 */
package ludichat.cobbreeding;

import com.cobblemon.mod.common.api.pokemon.PokemonProperties;
import com.cobblemon.mod.common.api.pokemon.PokemonSpecies;
import com.cobblemon.mod.common.api.pokemon.egg.EggGroup;
import com.cobblemon.mod.common.api.types.ElementalType;
import com.cobblemon.mod.common.pokemon.FormData;
import com.cobblemon.mod.common.pokemon.Species;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import ludichat.cobbreeding.BreedingUtilities;
import ludichat.cobbreeding.Cobbreeding;
import ludichat.cobbreeding.PokemonEgg;
import ludichat.cobbreeding.components.CobbreedingComponents;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\n\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b\u000b\u0010\fJ%\u0010\u0010\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000e\u001a\u00020\r2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\nH\u0007\u00a2\u0006\u0004\b\u0010\u0010\u0011J\r\u0010\u0012\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0017\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0014\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0017\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u001f\u0010\u001d\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u0006H\u0007\u00a2\u0006\u0004\b\u001d\u0010\u001e\u00a8\u0006\u001f"}, d2={"Lludichat/cobbreeding/EggUtilities;", "", "<init>", "()V", "Lcom/cobblemon/mod/common/pokemon/FormData;", "pokemon", "Lnet/minecraft/world/item/ItemStack;", "selectEggItem", "(Lcom/cobblemon/mod/common/pokemon/FormData;)Lnet/minecraft/world/item/ItemStack;", "Lcom/cobblemon/mod/common/pokemon/Species;", "", "calculateTimer", "(Lcom/cobblemon/mod/common/pokemon/Species;)I", "Lcom/cobblemon/mod/common/api/pokemon/PokemonProperties;", "properties", "timer", "getEggFromPokemonProperties", "(Lcom/cobblemon/mod/common/api/pokemon/PokemonProperties;Ljava/lang/Integer;)Lnet/minecraft/world/item/ItemStack;", "randomEgg", "()Lcom/cobblemon/mod/common/pokemon/FormData;", "species", "", "isRandomSpeciesAllowed", "(Lcom/cobblemon/mod/common/pokemon/Species;)Z", "itemStack", "isEgg", "(Lnet/minecraft/world/item/ItemStack;)Z", "a", "b", "areSameEgg", "(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/item/ItemStack;)Z", "common"})
public final class EggUtilities {
    @NotNull
    public static final EggUtilities INSTANCE = new EggUtilities();

    private EggUtilities() {
    }

    @JvmStatic
    @NotNull
    public static final ItemStack selectEggItem(@NotNull FormData pokemon) {
        Intrinsics.checkNotNullParameter((Object)pokemon, (String)"pokemon");
        if (Intrinsics.areEqual((Object)pokemon.getSpecies().showdownId(), (Object)"manaphy")) {
            RegistrySupplier<PokemonEgg> registrySupplier = Cobbreeding.EGG_ITEMS.get("manaphy_egg");
            Intrinsics.checkNotNull(registrySupplier);
            return new ItemStack((ItemLike)registrySupplier.get());
        }
        try {
            ElementalType type1 = pokemon.getPrimaryType();
            ElementalType type2 = pokemon.getSecondaryType();
            if (type2 != null && !Intrinsics.areEqual((Object)type1, (Object)type2)) {
                RegistrySupplier<PokemonEgg> registrySupplier = Cobbreeding.EGG_ITEMS.get(type1.getName() + "_" + type2.getName() + "_pokemon_egg");
                Intrinsics.checkNotNull(registrySupplier);
                return new ItemStack((ItemLike)registrySupplier.get());
            }
            RegistrySupplier<PokemonEgg> registrySupplier = Cobbreeding.EGG_ITEMS.get(type1.getName() + "_pokemon_egg");
            Intrinsics.checkNotNull(registrySupplier);
            return new ItemStack((ItemLike)registrySupplier.get());
        }
        catch (NullPointerException nullPointerException) {
            RegistrySupplier<PokemonEgg> registrySupplier = Cobbreeding.EGG_ITEMS.get("pokemon_egg");
            Intrinsics.checkNotNull(registrySupplier);
            return new ItemStack((ItemLike)registrySupplier.get());
        }
    }

    @JvmStatic
    public static final int calculateTimer(@NotNull Species pokemon) {
        Intrinsics.checkNotNullParameter((Object)pokemon, (String)"pokemon");
        return Mth.floor((float)((float)(pokemon.getEggCycles() * 600) * Cobbreeding.INSTANCE.getConfig().getEggHatchMultiplier()));
    }

    @JvmStatic
    @Nullable
    public static final ItemStack getEggFromPokemonProperties(@NotNull PokemonProperties properties, @Nullable Integer timer) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        String string = properties.getSpecies();
        Intrinsics.checkNotNull((Object)string);
        Species species = PokemonSpecies.INSTANCE.getByName(string);
        ItemStack eggItem = null;
        if (species != null) {
            FormData form = species.getStandardForm();
            if (properties.getForm() != null) {
                String string2 = properties.getForm();
                Intrinsics.checkNotNull((Object)string2);
                form = species.getFormByShowdownId(string2);
            }
            if (Cobbreeding.INSTANCE.getConfig().getCustomColors()) {
                eggItem = EggUtilities.selectEggItem(form);
            } else {
                RegistrySupplier<PokemonEgg> registrySupplier = Cobbreeding.EGG_ITEMS.get("pokemon_egg");
                Intrinsics.checkNotNull(registrySupplier);
                eggItem = new ItemStack((ItemLike)registrySupplier.get());
            }
            eggItem.set((DataComponentType)CobbreedingComponents.EGG_INFO.get(), (Object)PokemonProperties.asString$default((PokemonProperties)properties, null, (int)1, null));
            Integer n = timer == null ? (Integer)eggItem.set((DataComponentType)CobbreedingComponents.TIMER.get(), (Object)EggUtilities.calculateTimer(species)) : (Integer)eggItem.set((DataComponentType)CobbreedingComponents.TIMER.get(), (Object)timer);
            return eggItem;
        }
        if (Intrinsics.areEqual((Object)properties.getSpecies(), (Object)"random")) {
            RegistrySupplier<PokemonEgg> registrySupplier = Cobbreeding.EGG_ITEMS.get("pokemon_egg");
            Intrinsics.checkNotNull(registrySupplier);
            eggItem = new ItemStack((ItemLike)registrySupplier.get());
            eggItem.set((DataComponentType)CobbreedingComponents.TIMER.get(), (Object)EggUtilities.calculateTimer(PokemonSpecies.INSTANCE.random()));
            eggItem.set((DataComponentType)CobbreedingComponents.EGG_INFO.get(), (Object)PokemonProperties.asString$default((PokemonProperties)properties, null, (int)1, null));
            return eggItem;
        }
        return null;
    }

    public static /* synthetic */ ItemStack getEggFromPokemonProperties$default(PokemonProperties pokemonProperties, Integer n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = null;
        }
        return EggUtilities.getEggFromPokemonProperties(pokemonProperties, n);
    }

    @NotNull
    public final FormData randomEgg() {
        Species species = PokemonSpecies.INSTANCE.random();
        while (!this.isRandomSpeciesAllowed(species)) {
            species = PokemonSpecies.INSTANCE.random();
        }
        if (((Collection)species.getForms()).size() > 0) {
            FormData form = (FormData)CollectionsKt.random((Collection)species.getForms(), (Random)((Random)Random.Default));
            return BreedingUtilities.INSTANCE.getBaby(form);
        }
        return BreedingUtilities.INSTANCE.getBaby(species.getStandardForm());
    }

    private final boolean isRandomSpeciesAllowed(Species species) {
        boolean isLegendary = species.getLabels().contains("legendary") || species.getLabels().contains("mythical");
        boolean isParadox = species.getLabels().contains("paradox");
        boolean isUltraBeast = species.getLabels().contains("ultra_beast");
        boolean isUndiscovered = species.getEggGroups().contains(EggGroup.UNDISCOVERED);
        if (!(isLegendary || isParadox || isUltraBeast || isUndiscovered)) {
            return true;
        }
        if (Cobbreeding.INSTANCE.getConfig().getDittoAndDittoAllowLegendary() && isLegendary) {
            return true;
        }
        if (!isLegendary && Cobbreeding.INSTANCE.getConfig().getDittoAndDittoAllowParadox() && isParadox) {
            return true;
        }
        if (!isLegendary && !isParadox && Cobbreeding.INSTANCE.getConfig().getDittoAndDittoAllowUltraBeast() && isUltraBeast) {
            return true;
        }
        return !isLegendary && !isParadox && !isUltraBeast && Cobbreeding.INSTANCE.getConfig().getDittoAndDittoAllowUndiscovered();
    }

    private final boolean isEgg(ItemStack itemStack) {
        return itemStack.getItem() instanceof PokemonEgg;
    }

    @JvmStatic
    public static final boolean areSameEgg(@NotNull ItemStack a, @NotNull ItemStack b) {
        Object comp_b;
        Object comp_a;
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        return INSTANCE.isEgg(a) && INSTANCE.isEgg(b) && (comp_a = a.getOrDefault((DataComponentType)CobbreedingComponents.POKEMON_PROPERTIES.get(), (Object)0)).equals(comp_b = b.getOrDefault((DataComponentType)CobbreedingComponents.POKEMON_PROPERTIES.get(), (Object)0));
    }
}

