/*
 * Decompiled with CFR 0.152.
 */
package ludichat.cobbreeding;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.reactive.Observable;
import com.cobblemon.mod.common.api.reactive.ObservableSubscription;
import com.cobblemon.mod.common.api.storage.party.PlayerPartyStore;
import com.cobblemon.mod.common.pokemon.Pokemon;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import ludichat.cobbreeding.Cobbreeding;
import ludichat.cobbreeding.net.IncubatorAbilityPacket;
import net.minecraft.server.level.ServerPlayer;
import org.apache.commons.lang3.tuple.MutablePair;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0015\u0010\t\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\t\u0010\bJ\u0015\u0010\n\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\n\u0010\bJ\u0015\u0010\u000e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0015\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0011\u0010\u0012R5\u0010\u0016\u001a \u0012\u0004\u0012\u00020\u0010\u0012\u0016\u0012\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u0015\u0012\u0004\u0012\u00020\r0\u00140\u00138\u0006\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001a"}, d2={"Lludichat/cobbreeding/IncubatorAbilitiesRegistry;", "", "<init>", "()V", "Lnet/minecraft/server/level/ServerPlayer;", "player", "", "add", "(Lnet/minecraft/server/level/ServerPlayer;)V", "update", "remove", "Lcom/cobblemon/mod/common/api/storage/party/PlayerPartyStore;", "party", "", "isIncubator", "(Lcom/cobblemon/mod/common/api/storage/party/PlayerPartyStore;)Z", "", "shouldHatchFaster", "(Ljava/lang/String;)Z", "", "Lorg/apache/commons/lang3/tuple/MutablePair;", "Lcom/cobblemon/mod/common/api/reactive/ObservableSubscription;", "registry", "Ljava/util/Map;", "getRegistry", "()Ljava/util/Map;", "common"})
public final class IncubatorAbilitiesRegistry {
    @NotNull
    private final Map<String, MutablePair<ObservableSubscription<Unit>, Boolean>> registry = new LinkedHashMap();

    @NotNull
    public final Map<String, MutablePair<ObservableSubscription<Unit>, Boolean>> getRegistry() {
        return this.registry;
    }

    public final void add(@NotNull ServerPlayer player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        PlayerPartyStore party = Cobblemon.INSTANCE.getStorage().getParty(player);
        ObservableSubscription subscription = Observable.DefaultImpls.subscribe$default((Observable)party.getAnyChangeObservable(), null, arg_0 -> IncubatorAbilitiesRegistry.add$lambda$0(this, player, arg_0), (int)1, null);
        boolean isIncubator = this.isIncubator(party);
        this.registry.put(player.getStringUUID(), (MutablePair<ObservableSubscription<Unit>, Boolean>)new MutablePair((Object)subscription, (Object)isIncubator));
        new IncubatorAbilityPacket(isIncubator).sendToPlayer(player);
    }

    public final void update(@NotNull ServerPlayer player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (this.registry.get(player.getStringUUID()) == null) {
            Cobbreeding.LOGGER.warn(player.getName() + " can't be found in Incubator Ability Registry. (update)");
            return;
        }
        boolean isIncubator = this.isIncubator(Cobblemon.INSTANCE.getStorage().getParty(player));
        Intrinsics.checkNotNull(this.registry.get(player.getStringUUID()));
        this.registry.get(player.getStringUUID()).right = isIncubator;
        new IncubatorAbilityPacket(isIncubator).sendToPlayer(player);
    }

    public final void remove(@NotNull ServerPlayer player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (this.registry.get(player.getStringUUID()) == null) {
            Cobbreeding.LOGGER.warn(player.getName() + " can't be found in Incubator Ability Registry. (remove)");
            return;
        }
        MutablePair<ObservableSubscription<Unit>, Boolean> mutablePair = this.registry.get(player.getStringUUID());
        Intrinsics.checkNotNull(mutablePair);
        ((ObservableSubscription)mutablePair.left).unsubscribe();
        this.registry.remove(player.getStringUUID());
    }

    public final boolean isIncubator(@NotNull PlayerPartyStore party) {
        Intrinsics.checkNotNullParameter((Object)party, (String)"party");
        for (int i = 0; i < 6; ++i) {
            boolean incubator;
            Pokemon pokemon = party.get(i);
            if (pokemon != null) {
                Pokemon it;
                boolean bl = false;
                String ability = it.getAbility().getTemplate().getName();
                v0 = Intrinsics.areEqual((Object)ability, (Object)"magmaarmor") || Intrinsics.areEqual((Object)ability, (Object)"flamebody") || Intrinsics.areEqual((Object)ability, (Object)"steamengine");
            } else {
                v0 = incubator = false;
            }
            if (!incubator) continue;
            return true;
        }
        return false;
    }

    public final boolean shouldHatchFaster(@NotNull String player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (this.registry.containsKey(player)) {
            MutablePair<ObservableSubscription<Unit>, Boolean> mutablePair = this.registry.get(player);
            Intrinsics.checkNotNull(mutablePair);
            Object object = mutablePair.right;
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"right");
            return (Boolean)object;
        }
        return false;
    }

    private static final Unit add$lambda$0(IncubatorAbilitiesRegistry this$0, ServerPlayer $player, Unit it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$player, (String)"$player");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.update($player);
        return Unit.INSTANCE;
    }
}

