/*
 * Decompiled with CFR 0.152.
 */
package ludichat.cobbreeding;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.events.CobblemonEvents;
import com.cobblemon.mod.common.api.events.pokemon.HatchEggEvent;
import com.cobblemon.mod.common.api.pokemon.PokemonProperties;
import com.cobblemon.mod.common.api.pokemon.PokemonSpecies;
import com.cobblemon.mod.common.api.pokemon.feature.FlagSpeciesFeature;
import com.cobblemon.mod.common.api.pokemon.feature.StringSpeciesFeature;
import com.cobblemon.mod.common.api.reactive.EventObservable;
import com.cobblemon.mod.common.api.storage.PokemonStoreManager;
import com.cobblemon.mod.common.api.storage.player.PlayerInstancedDataStoreManager;
import com.cobblemon.mod.common.pokemon.FormData;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.pokemon.Species;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import ludichat.cobbreeding.Cobbreeding;
import ludichat.cobbreeding.CobbreedingClient;
import ludichat.cobbreeding.EggUtilities;
import ludichat.cobbreeding.IncubatorAbilitiesRegistry;
import ludichat.cobbreeding.components.CobbreedingComponents;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0004\u0018\u0000 .2\u00020\u0001:\u0001.B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0017\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\t\u0010\nJ5\u0010\u0013\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0012\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014J7\u0010\u001d\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001bH\u0016\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u0017\u0010!\u001a\u00020\b2\u0006\u0010 \u001a\u00020\u001fH\u0002\u00a2\u0006\u0004\b!\u0010\"J\u001f\u0010$\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020#2\u0006\u0010 \u001a\u00020\u001fH\u0002\u00a2\u0006\u0004\b$\u0010%J\u0017\u0010(\u001a\u00020'2\u0006\u0010&\u001a\u00020\u0019H\u0002\u00a2\u0006\u0004\b(\u0010)J\u001d\u0010,\u001a\b\u0012\u0004\u0012\u00020'0+2\u0006\u0010*\u001a\u00020'H\u0002\u00a2\u0006\u0004\b,\u0010-\u00a8\u0006/"}, d2={"Lludichat/cobbreeding/PokemonEgg;", "Lnet/minecraft/world/item/Item;", "Lnet/minecraft/world/item/Item$Properties;", "settings", "<init>", "(Lnet/minecraft/world/item/Item$Properties;)V", "Lnet/minecraft/world/item/ItemStack;", "itemStack", "", "verifyComponentsAfterLoad", "(Lnet/minecraft/world/item/ItemStack;)V", "stack", "Lnet/minecraft/world/item/Item$TooltipContext;", "context", "", "Lnet/minecraft/network/chat/Component;", "lines", "Lnet/minecraft/world/item/TooltipFlag;", "type", "appendHoverText", "(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/item/Item$TooltipContext;Ljava/util/List;Lnet/minecraft/world/item/TooltipFlag;)V", "Lnet/minecraft/world/level/Level;", "world", "Lnet/minecraft/world/entity/Entity;", "entity", "", "slot", "", "selected", "inventoryTick", "(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/level/Level;Lnet/minecraft/world/entity/Entity;IZ)V", "Lcom/cobblemon/mod/common/api/pokemon/PokemonProperties;", "properties", "resolveForm", "(Lcom/cobblemon/mod/common/api/pokemon/PokemonProperties;)V", "Lnet/minecraft/world/entity/player/Player;", "hatchEgg", "(Lnet/minecraft/world/entity/player/Player;Lcom/cobblemon/mod/common/api/pokemon/PokemonProperties;)V", "ticks", "", "ticksToTime", "(I)Ljava/lang/String;", "originalString", "", "pokemonPropertiesToAspects", "(Ljava/lang/String;)Ljava/util/Set;", "Companion", "common"})
@SourceDebugExtension(value={"SMAP\nPokemonEgg.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PokemonEgg.kt\nludichat/cobbreeding/PokemonEgg\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 EventObservables.kt\ncom/cobblemon/mod/common/api/reactive/EventObservable\n+ 5 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 6 EventObservables.kt\ncom/cobblemon/mod/common/api/reactive/EventObservable$post$1\n*L\n1#1,200:1\n1#2:201\n1863#3,2:202\n14#4,5:204\n19#4:212\n14#4,5:213\n19#4:221\n13346#5:209\n13347#5:211\n13346#5:218\n13347#5:220\n14#6:210\n14#6:219\n*S KotlinDebug\n*F\n+ 1 PokemonEgg.kt\nludichat/cobbreeding/PokemonEgg\n*L\n127#1:202,2\n154#1:204,5\n154#1:212\n163#1:213,5\n163#1:221\n154#1:209\n154#1:211\n163#1:218\n163#1:220\n154#1:210\n163#1:219\n*E\n"})
public final class PokemonEgg
extends Item {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public static final int DEFAULT_TIMER = 600;
    public static final int DEFAULT_SECOND = 0;
    @NotNull
    private static final Lazy<DataComponentType<Integer>> TIMER$delegate = LazyKt.lazy(PokemonEgg::TIMER_delegate$lambda$8);
    @NotNull
    private static final Lazy<DataComponentType<Integer>> SECOND$delegate = LazyKt.lazy(PokemonEgg::SECOND_delegate$lambda$9);
    @NotNull
    private static final Lazy<DataComponentType<String>> EGG_INFO$delegate = LazyKt.lazy(PokemonEgg::EGG_INFO_delegate$lambda$10);
    @NotNull
    private static final Lazy<DataComponentType<PokemonProperties>> POKEMON_PROPERTIES$delegate = LazyKt.lazy(PokemonEgg::POKEMON_PROPERTIES_delegate$lambda$11);

    public PokemonEgg(@NotNull Item.Properties settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        super(settings);
    }

    public void verifyComponentsAfterLoad(@NotNull ItemStack itemStack) {
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
        super.verifyComponentsAfterLoad(itemStack);
        if (itemStack.has(Companion.getPOKEMON_PROPERTIES())) {
            DataComponentType<String> dataComponentType = Companion.getEGG_INFO();
            Object object = itemStack.get(Companion.getPOKEMON_PROPERTIES());
            Intrinsics.checkNotNull((Object)object);
            itemStack.set(dataComponentType, (Object)((PokemonProperties)object).asString(" "));
        }
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> lines, @NotNull TooltipFlag type) {
        PokemonProperties properties;
        PokemonProperties pokemonProperties;
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(lines, (String)"lines");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        super.appendHoverText(stack, context, lines, type);
        String string = (String)stack.get(Companion.getEGG_INFO());
        if (string != null) {
            String it = string;
            boolean bl = false;
            pokemonProperties = PokemonProperties.Companion.parse$default((PokemonProperties.Companion)PokemonProperties.Companion, (String)it, null, null, (int)6, null);
        } else {
            pokemonProperties = null;
        }
        PokemonProperties pokemonProperties2 = properties = pokemonProperties;
        if ((pokemonProperties2 != null ? pokemonProperties2.getSpecies() : null) != null) {
            String string2 = properties.getSpecies();
            Intrinsics.checkNotNull((Object)string2);
            Species pokemon = PokemonSpecies.INSTANCE.getByName(string2);
            if (pokemon != null) {
                lines.add((Component)pokemon.getTranslatedName());
                if (properties.getForm() != null) {
                    Object v4;
                    block8: {
                        Iterable iterable = pokemon.getForms();
                        for (Object t : iterable) {
                            FormData it = (FormData)t;
                            boolean bl = false;
                            if (!Intrinsics.areEqual((Object)it.formOnlyShowdownId(), (Object)properties.getForm())) continue;
                            v4 = t;
                            break block8;
                        }
                        v4 = null;
                    }
                    FormData data = v4;
                    if (data != null && !Intrinsics.areEqual((Object)data.getName(), (Object)"Normal")) {
                        MutableComponent mutableComponent = Component.literal((String)data.getName());
                        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"literal(...)");
                        lines.add((Component)mutableComponent);
                    }
                }
            }
        } else {
            MutableComponent mutableComponent = Component.literal((String)"Bad egg");
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"literal(...)");
            lines.add((Component)mutableComponent);
        }
        Integer timer = (Integer)stack.getOrDefault(Companion.getTIMER(), (Object)600);
        Intrinsics.checkNotNull((Object)timer);
        MutableComponent mutableComponent = Component.literal((String)this.ticksToTime(timer));
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"literal(...)");
        lines.add((Component)mutableComponent);
    }

    public void inventoryTick(@NotNull ItemStack stack, @NotNull Level world, @NotNull Entity entity, int slot, boolean selected) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        super.inventoryTick(stack, world, entity, slot, selected);
        if (entity instanceof Player) {
            Integer second = (Integer)stack.getOrDefault(Companion.getSECOND(), (Object)0);
            stack.set(Companion.getSECOND(), (Object)(second + 1));
            if (second < 20) {
                return;
            }
            stack.set(Companion.getSECOND(), (Object)0);
            Integer timer = (Integer)stack.getOrDefault(Companion.getTIMER(), (Object)600);
            stack.set(Companion.getTIMER(), (Object)(timer - 20));
            if (world.isClientSide && CobbreedingClient.INSTANCE.isIncubator()) {
                stack.set(Companion.getTIMER(), (Object)(timer - 40));
            } else {
                IncubatorAbilitiesRegistry incubatorAbilitiesRegistry = Cobbreeding.INSTANCE.getINCUBATOR_ABILITIES_REGISTRY();
                String string = ((Player)entity).getStringUUID();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStringUUID(...)");
                if (incubatorAbilitiesRegistry.shouldHatchFaster(string)) {
                    stack.set(Companion.getTIMER(), (Object)(timer - 40));
                }
            }
            if (timer <= 0 && !world.isClientSide) {
                String species;
                PokemonProperties pokemonProperties;
                PokemonProperties pokemonProperties2;
                String string = (String)stack.get(Companion.getEGG_INFO());
                if (string != null) {
                    String it = string;
                    boolean bl = false;
                    pokemonProperties2 = PokemonProperties.Companion.parse$default((PokemonProperties.Companion)PokemonProperties.Companion, (String)it, null, null, (int)6, null);
                } else {
                    pokemonProperties2 = null;
                }
                PokemonProperties pokemonProperties3 = pokemonProperties = pokemonProperties2;
                String string2 = species = pokemonProperties3 != null ? pokemonProperties3.getSpecies() : null;
                if (species != null && (PokemonSpecies.INSTANCE.getByName(species) != null || Intrinsics.areEqual((Object)species, (Object)"random"))) {
                    if (Intrinsics.areEqual((Object)species, (Object)"random")) {
                        FormData randomPokemon = EggUtilities.INSTANCE.randomEgg();
                        pokemonProperties.setSpecies(randomPokemon.getSpecies().showdownId());
                        pokemonProperties.setForm(randomPokemon.formOnlyShowdownId());
                    }
                    this.resolveForm(pokemonProperties);
                    this.hatchEgg((Player)entity, pokemonProperties);
                } else {
                    entity.sendSystemMessage((Component)Component.literal((String)"Couldn't resolve pokemon species to hatch, deleting egg."));
                }
                stack.shrink(1);
            }
        }
    }

    private final void resolveForm(PokemonProperties properties) {
        block6: {
            Object v3;
            block5: {
                Species species;
                if (properties.getForm() == null) break block6;
                PokemonProperties pokemonProperties = properties;
                Intrinsics.checkNotNull((Object)pokemonProperties);
                String string = pokemonProperties.getSpecies();
                if (string != null) {
                    String it = string;
                    boolean bl = false;
                    species = PokemonSpecies.INSTANCE.getByName(it);
                } else {
                    species = null;
                }
                Intrinsics.checkNotNull(species);
                Iterable iterable = species.getForms();
                for (Object bl : iterable) {
                    FormData it = (FormData)bl;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.formOnlyShowdownId(), (Object)properties.getForm())) continue;
                    v3 = bl;
                    break block5;
                }
                v3 = null;
            }
            FormData formData = v3;
            if (formData != null) {
                FormData $this$resolveForm_u24lambda_u246 = formData;
                boolean bl = false;
                Iterable $this$forEach$iv = $this$resolveForm_u24lambda_u246.getAspects();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    String it = (String)element$iv;
                    boolean bl3 = false;
                    properties.getCustomProperties().add(new FlagSpeciesFeature(it, true));
                    String[] stringArray = new String[]{"-"};
                    properties.getCustomProperties().add(new StringSpeciesFeature("region_bias", (String)CollectionsKt.last((List)StringsKt.split$default((CharSequence)it, (String[])stringArray, (boolean)false, (int)0, (int)6, null))));
                    properties.getCustomProperties().add(new StringSpeciesFeature("fish_stripes", StringsKt.removeSuffix((String)it, (CharSequence)"striped")));
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void hatchEgg(Player entity, PokemonProperties properties) {
        try {
            void $this$iv;
            void $this$iv2;
            EventObservable eventObservable = (EventObservable)CobblemonEvents.HATCH_EGG_PRE;
            EventObservable eventObservable2 = new HatchEggEvent.Pre[1];
            Intrinsics.checkNotNull((Object)entity, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerPlayer");
            eventObservable2[0] = new HatchEggEvent.Pre(properties, (ServerPlayer)entity);
            EventObservable events$iv = eventObservable2;
            boolean $i$f$post = false;
            $this$iv2.emit((Object[])Arrays.copyOf(events$iv, ((HatchEggEvent.Pre[])events$iv).length));
            EventObservable $this$forEach$iv$iv = events$iv;
            boolean $i$f$forEach = false;
            int n = ((HatchEggEvent.Pre[])$this$forEach$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                HatchEggEvent.Pre element$iv$iv;
                HatchEggEvent.Pre pre = element$iv$iv = $this$forEach$iv$iv[i];
                boolean bl = false;
                HatchEggEvent.Pre it = pre;
            }
            Pokemon pokemon = PokemonProperties.create$default((PokemonProperties)properties, null, (int)1, null);
            Pokemon.setFriendship$default((Pokemon)pokemon, (int)120, (boolean)false, (int)2, null);
            pokemon.setForcedAspects(this.pokemonPropertiesToAspects(properties.getOriginalString()));
            PokemonStoreManager pokemonStoreManager = Cobblemon.INSTANCE.getStorage();
            UUID uUID = ((ServerPlayer)entity).getUUID();
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
            RegistryAccess registryAccess = entity.registryAccess();
            Intrinsics.checkNotNullExpressionValue((Object)registryAccess, (String)"registryAccess(...)");
            pokemonStoreManager.getParty(uUID, registryAccess).add(pokemon);
            PlayerInstancedDataStoreManager playerInstancedDataStoreManager = Cobblemon.INSTANCE.getPlayerDataManager();
            UUID uUID2 = ((ServerPlayer)entity).getUUID();
            Intrinsics.checkNotNullExpressionValue((Object)uUID2, (String)"getUUID(...)");
            playerInstancedDataStoreManager.getPokedexData(uUID2).catch(pokemon);
            events$iv = CobblemonEvents.HATCH_EGG_POST;
            HatchEggEvent.Post[] postArray = new HatchEggEvent.Post[]{new HatchEggEvent.Post(properties, (ServerPlayer)entity)};
            HatchEggEvent.Post[] events$iv2 = postArray;
            boolean $i$f$post2 = false;
            $this$iv.emit((Object[])Arrays.copyOf(events$iv2, events$iv2.length));
            HatchEggEvent.Post[] $this$forEach$iv$iv2 = events$iv2;
            boolean $i$f$forEach2 = false;
            int n2 = $this$forEach$iv$iv2.length;
            for (n = 0; n < n2; ++n) {
                HatchEggEvent.Post element$iv$iv;
                HatchEggEvent.Post bl = element$iv$iv = $this$forEach$iv$iv2[n];
                boolean $i$a$-post-EventObservable$post$2 = false;
                HatchEggEvent.Post it = bl;
            }
        }
        catch (Exception e) {
            Cobbreeding.LOGGER.error("Egg hatching failed: " + e.getMessage() + "\n" + e.getStackTrace());
            entity.sendSystemMessage((Component)Component.translatable((String)"cobbreeding.msg.egg_hatch.fail"));
        }
    }

    private final String ticksToTime(int ticks) {
        int minutes = (int)Math.floor(ticks / 1200);
        String string = "%02d";
        Object[] objectArray = new Object[]{(int)Math.floor(ticks % 1200 / 20)};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        String seconds = string2;
        return minutes <= 0 ? seconds : minutes + ":" + seconds;
    }

    private final Set<String> pokemonPropertiesToAspects(String originalString) {
        if (StringsKt.contains$default((CharSequence)originalString, (CharSequence)"aspects=", (boolean)false, (int)2, null)) {
            Object v0;
            String[] stringArray;
            block2: {
                stringArray = new String[]{" "};
                Iterable iterable = StringsKt.split$default((CharSequence)originalString, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
                for (Object t : iterable) {
                    String it = (String)t;
                    boolean bl = false;
                    if (!StringsKt.contains$default((CharSequence)it, (CharSequence)"aspects", (boolean)false, (int)2, null)) continue;
                    v0 = t;
                    break block2;
                }
                v0 = null;
            }
            Intrinsics.checkNotNull(v0);
            stringArray = new String[]{"="};
            String aspects = StringsKt.replace$default((String)StringsKt.removeSuffix((String)StringsKt.removePrefix((String)((String)StringsKt.split$default((CharSequence)v0, (String[])stringArray, (boolean)false, (int)0, (int)6, null).get(1)), (CharSequence)"["), (CharSequence)"]"), (String)" ", (String)"", (boolean)false, (int)4, null);
            stringArray = new String[]{","};
            return CollectionsKt.toSet((Iterable)StringsKt.split$default((CharSequence)aspects, (String[])stringArray, (boolean)false, (int)0, (int)6, null));
        }
        return SetsKt.emptySet();
    }

    private static final DataComponentType TIMER_delegate$lambda$8() {
        return (DataComponentType)CobbreedingComponents.TIMER.get();
    }

    private static final DataComponentType SECOND_delegate$lambda$9() {
        return (DataComponentType)CobbreedingComponents.SECOND.get();
    }

    private static final DataComponentType EGG_INFO_delegate$lambda$10() {
        return (DataComponentType)CobbreedingComponents.EGG_INFO.get();
    }

    private static final DataComponentType POKEMON_PROPERTIES_delegate$lambda$11() {
        return (DataComponentType)CobbreedingComponents.POKEMON_PROPERTIES.get();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0005\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u0006R!\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\b8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u000b\u0010\fR!\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00040\b8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\n\u001a\u0004\b\u000f\u0010\fR!\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00110\b8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\n\u001a\u0004\b\u0013\u0010\fR!\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00150\b8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0016\u0010\n\u001a\u0004\b\u0017\u0010\f\u00a8\u0006\u0019"}, d2={"Lludichat/cobbreeding/PokemonEgg$Companion;", "", "<init>", "()V", "", "DEFAULT_TIMER", "I", "DEFAULT_SECOND", "Lnet/minecraft/core/component/DataComponentType;", "TIMER$delegate", "Lkotlin/Lazy;", "getTIMER", "()Lnet/minecraft/core/component/DataComponentType;", "TIMER", "SECOND$delegate", "getSECOND", "SECOND", "", "EGG_INFO$delegate", "getEGG_INFO", "EGG_INFO", "Lcom/cobblemon/mod/common/api/pokemon/PokemonProperties;", "POKEMON_PROPERTIES$delegate", "getPOKEMON_PROPERTIES", "POKEMON_PROPERTIES", "common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DataComponentType<Integer> getTIMER() {
            Lazy lazy = TIMER$delegate;
            Object object = lazy.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
            return (DataComponentType)object;
        }

        @NotNull
        public final DataComponentType<Integer> getSECOND() {
            Lazy lazy = SECOND$delegate;
            Object object = lazy.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
            return (DataComponentType)object;
        }

        @NotNull
        public final DataComponentType<String> getEGG_INFO() {
            Lazy lazy = EGG_INFO$delegate;
            Object object = lazy.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
            return (DataComponentType)object;
        }

        @NotNull
        public final DataComponentType<PokemonProperties> getPOKEMON_PROPERTIES() {
            Lazy lazy = POKEMON_PROPERTIES$delegate;
            Object object = lazy.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
            return (DataComponentType)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

