/*
 * Decompiled with CFR 0.152.
 */
package ludichat.cobbreeding.mixin;

import com.cobblemon.mod.common.block.PastureBlock;
import ludichat.cobbreeding.CustomProperties;
import ludichat.cobbreeding.PastureBreedingData;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={PastureBlock.class})
public abstract class PastureBlockMixin
extends Block {
    @Unique
    private static final BooleanProperty HAS_EGG = CustomProperties.HAS_EGG;

    public PastureBlockMixin(BlockBehaviour.Properties settings) {
        super(settings);
    }

    @Inject(at={@At(value="TAIL")}, method={"<init>"})
    private void init(BlockBehaviour.Properties properties, CallbackInfo ci) {
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)HAS_EGG, (Comparable)Boolean.valueOf(false)));
    }

    @Inject(at={@At(value="TAIL")}, method={"createBlockStateDefinition"})
    private void appendProperties(StateDefinition.Builder<Block, BlockState> builder, CallbackInfo ci) {
        builder.add(new Property[]{HAS_EGG});
    }

    @Inject(at={@At(value="HEAD")}, method={"useWithoutItem"}, cancellable=true)
    private void onUse(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult hit, CallbackInfoReturnable<InteractionResult> cir) {
        if (!world.isClientSide) {
            boolean is_bottom_part = state.getValue((Property)PastureBlock.Companion.getPART()) == PastureBlock.PasturePart.BOTTOM;
            Container pastureInventory = (Container)world.getBlockEntity(pos);
            if (pastureInventory != null && !pastureInventory.getItem(0).isEmpty() && is_bottom_part) {
                player.getInventory().placeItemBackInInventory(pastureInventory.getItem(0));
                pastureInventory.removeItemNoUpdate(0);
                player.getInventory().tick();
                cir.setReturnValue((Object)InteractionResult.SUCCESS);
            }
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"playerWillDestroy"})
    private void onBroken(Level world, BlockPos pos, BlockState state, Player player, CallbackInfoReturnable<BlockState> cir) {
        if (!world.isClientSide) {
            int hash = state.hashCode();
            PastureBreedingData.registry.remove(hash);
        }
    }
}

