/*
 * Decompiled with CFR 0.152.
 */
package ludichat.cobbreeding.mixin;

import com.cobblemon.mod.common.api.pokemon.PokemonProperties;
import com.cobblemon.mod.common.api.pokemon.PokemonSpecies;
import com.cobblemon.mod.common.block.entity.PokemonPastureBlockEntity;
import com.cobblemon.mod.common.pokemon.FormData;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.pokemon.Species;
import java.util.List;
import kotlin.UninitializedPropertyAccessException;
import ludichat.cobbreeding.BreedingUtilities;
import ludichat.cobbreeding.Cobbreeding;
import ludichat.cobbreeding.Config;
import ludichat.cobbreeding.CustomProperties;
import ludichat.cobbreeding.EggUtilities;
import ludichat.cobbreeding.PastureBreedingData;
import ludichat.cobbreeding.PastureInventory;
import ludichat.cobbreeding.components.CobbreedingComponents;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PokemonPastureBlockEntity.class})
public abstract class PokemonPastureBlockEntityMixin
implements PastureInventory,
WorldlyContainer {
    @Unique
    private static final Logger LOGGER = Cobbreeding.LOGGER;
    @Unique
    private static final BooleanProperty HAS_EGG = CustomProperties.HAS_EGG;

    @Override
    public NonNullList<ItemStack> getItems() {
        PastureBreedingData data;
        int hash = this.hashCode();
        if (PastureBreedingData.registry.containsKey(hash)) {
            data = PastureBreedingData.registry.get(hash);
        } else {
            data = new PastureBreedingData(PokemonPastureBlockEntityMixin.getConfig().getEggCheckTicks(), (NonNullList<ItemStack>)NonNullList.withSize((int)1, (Object)ItemStack.EMPTY));
            PastureBreedingData.registry.put(hash, data);
        }
        return data.getEgg();
    }

    @Unique
    private static Config getConfig() {
        Config config;
        try {
            config = Cobbreeding.INSTANCE.getConfig();
        }
        catch (UninitializedPropertyAccessException e) {
            LOGGER.warn("Trying to read configurations but they haven't been initialized. Returning Default configs instead. This might happen because the client is running logic it shouldn't.");
            return new Config();
        }
        return config;
    }

    @Inject(at={@At(value="HEAD")}, method={"TICKER$lambda$14"})
    private static void init(Level world, BlockPos pos, BlockState state, PokemonPastureBlockEntity blockEntity, CallbackInfo ci) {
        PastureBreedingData data;
        if (world.isClientSide) {
            return;
        }
        int hash = blockEntity.hashCode();
        if (PastureBreedingData.registry.containsKey(hash)) {
            data = PastureBreedingData.registry.get(hash);
        } else {
            data = new PastureBreedingData(PokemonPastureBlockEntityMixin.getConfig().getEggCheckTicks(), (NonNullList<ItemStack>)NonNullList.withSize((int)1, (Object)ItemStack.EMPTY));
            PastureBreedingData.registry.put(hash, data);
        }
        world.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)HAS_EGG, (Comparable)Boolean.valueOf(!((ItemStack)data.getEgg().getFirst()).isEmpty())));
        int time = data.getTime();
        if (--time <= 0) {
            time = PokemonPastureBlockEntityMixin.getConfig().getEggCheckTicks();
            List tetheredPokemon = blockEntity.getTetheredPokemon();
            List<Pokemon> pokemon = BreedingUtilities.getPokemon(tetheredPokemon);
            BreedingUtilities.applyMirrorHerb(pokemon);
            double randomNumber = Math.random();
            double eggChance = PokemonPastureBlockEntityMixin.getConfig().getEggCheckChance();
            LOGGER.trace("Trying egg, roll: %b (%f >= 1 - %f)".formatted(randomNumber >= (double)(1.0f - PokemonPastureBlockEntityMixin.getConfig().getEggCheckChance()), randomNumber, eggChance));
            if (((ItemStack)data.getEgg().getFirst()).isEmpty() && randomNumber >= 1.0 - eggChance) {
                PokemonProperties eggData = BreedingUtilities.chooseEgg(pokemon);
                ItemStack eggItem = null;
                if (eggData != null) {
                    if (eggData.getSpecies() != null) {
                        Species egg_pokemon = PokemonSpecies.INSTANCE.getByName(eggData.getSpecies());
                        if (egg_pokemon != null) {
                            FormData form = egg_pokemon.getStandardForm();
                            if (eggData.getForm() != null) {
                                form = egg_pokemon.getFormByShowdownId(eggData.getForm());
                            }
                            eggItem = Cobbreeding.config.getCustomColors() ? EggUtilities.selectEggItem(form) : new ItemStack((ItemLike)Cobbreeding.EGG_ITEMS.get("pokemon_egg").get());
                            eggItem.set((DataComponentType)CobbreedingComponents.TIMER.get(), (Object)EggUtilities.calculateTimer(egg_pokemon));
                        }
                        if (eggData.getSpecies().equals("random")) {
                            eggItem = new ItemStack((ItemLike)Cobbreeding.EGG_ITEMS.get("pokemon_egg").get());
                            eggItem.set((DataComponentType)CobbreedingComponents.TIMER.get(), (Object)EggUtilities.calculateTimer(PokemonSpecies.INSTANCE.random()));
                        }
                        if (egg_pokemon != null || eggData.getSpecies().equals("random")) {
                            eggItem.set((DataComponentType)CobbreedingComponents.EGG_INFO.get(), (Object)(eggData.asString(" ") + " aspects=" + eggData.getAspects().toString().replace(" ", "")));
                            data.getEgg().set(0, (Object)eggItem);
                            world.playSound(null, pos, SoundEvents.CHICKEN_EGG, SoundSource.BLOCKS, 1.0f, 1.0f);
                        }
                    }
                    if (eggItem == null) {
                        Cobbreeding.LOGGER.error("Couldn't add egg to pasture. Properties : " + String.valueOf(eggData));
                    }
                }
            }
        }
        data.setTime(time);
    }

    @Inject(at={@At(value="HEAD")}, method={"saveAdditional"})
    private void writeNbt(CompoundTag nbt, HolderLookup.Provider provider, CallbackInfo ci) {
        ContainerHelper.saveAllItems((CompoundTag)nbt, this.getItems(), (HolderLookup.Provider)provider);
    }

    @Inject(at={@At(value="TAIL")}, method={"loadAdditional"})
    private void readNbt(CompoundTag nbt, HolderLookup.Provider provider, CallbackInfo ci) {
        ContainerHelper.loadAllItems((CompoundTag)nbt, this.getItems(), (HolderLookup.Provider)provider);
    }

    public boolean canPlaceItemThroughFace(int slot, ItemStack stack, Direction direction) {
        return false;
    }

    public boolean canTakeItemThroughFace(int slot, ItemStack stack, Direction direction) {
        return PokemonPastureBlockEntityMixin.getConfig().getAllowHoppersToPullFromPastureBlock();
    }

    public int @NotNull [] getSlotsForFace(Direction direction) {
        return new int[]{0};
    }
}

