/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbfiltersystem.api.client.gui;

import dev.ftb.mods.ftbfiltersystem.api.NumericComparison;
import dev.ftb.mods.ftbfiltersystem.api.client.gui.AbstractFilterConfigScreen;
import dev.ftb.mods.ftbfiltersystem.api.client.gui.AbstractFilterScreen;
import dev.ftb.mods.ftbfiltersystem.api.client.gui.widget.CustomCheckbox;
import dev.ftb.mods.ftbfiltersystem.api.filter.AbstractComparisonFilter;
import dev.ftb.mods.ftbfiltersystem.api.filter.SmartFilter;
import java.util.Objects;
import java.util.function.BiFunction;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.GridLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LayoutSettings;
import net.minecraft.client.gui.layouts.SpacerElement;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import org.apache.commons.lang3.math.NumberUtils;

public abstract class AbstractComparisonConfigScreen<T extends AbstractComparisonFilter>
extends AbstractFilterConfigScreen<T> {
    private final BiFunction<SmartFilter.Compound, NumericComparison, T> comparisonFactory;
    protected CycleButton<NumericComparison.ComparisonOp> opBtn;
    protected EditBox numBox;
    protected CustomCheckbox pctCheckBox;

    public AbstractComparisonConfigScreen(T filter, AbstractFilterScreen parentScreen, BiFunction<SmartFilter.Compound, NumericComparison, T> comparisonFactory) {
        super(filter, parentScreen, 176, 55);
        this.comparisonFactory = comparisonFactory;
    }

    @Override
    protected void init() {
        super.init();
        GridLayout layout = new GridLayout(this.leftPos + 8, this.topPos + 20);
        GridLayout.RowHelper rowHelper = layout.createRowHelper(5);
        CycleButton.Builder builder = CycleButton.builder(NumericComparison.ComparisonOp::getDisplayName).withValues((Object[])NumericComparison.ComparisonOp.values()).withInitialValue((Object)((AbstractComparisonFilter)this.filter).getComparison().op()).displayOnlyValue();
        Objects.requireNonNull(this.font);
        this.opBtn = (CycleButton)rowHelper.addChild((LayoutElement)builder.create(0, 0, 20, 9 + 8, (Component)Component.empty(), (btn, val) -> {}));
        rowHelper.addChild((LayoutElement)SpacerElement.width((int)10));
        rowHelper.addChild((LayoutElement)Button.builder((Component)Component.literal((String)"-"), b -> this.adjustVal(-1)).size(12, 12).build(), LayoutSettings.defaults().alignVerticallyMiddle().paddingRight(2));
        Objects.requireNonNull(this.font);
        this.numBox = (EditBox)rowHelper.addChild((LayoutElement)new EditBox(this.font, 0, 0, 30, 9 + 8, (Component)Component.empty()));
        rowHelper.addChild((LayoutElement)Button.builder((Component)Component.literal((String)"+"), b -> this.adjustVal(1)).size(12, 12).build(), LayoutSettings.defaults().alignVerticallyMiddle().paddingLeft(2));
        this.numBox.setValue(Integer.toString(((AbstractComparisonFilter)this.filter).getComparison().value()));
        this.numBox.setResponder(str -> this.adjustVal(0));
        this.numBox.setFilter(str -> this.isValidNumber((String)str) || str.isEmpty());
        if (((AbstractComparisonFilter)this.filter).allowsPercentage()) {
            rowHelper.addChild((LayoutElement)SpacerElement.height((int)5), 5);
            MutableComponent txt = Component.translatable((String)"ftbfiltersystem.gui.percentage");
            this.pctCheckBox = (CustomCheckbox)rowHelper.addChild((LayoutElement)new CustomCheckbox(0, 0, this.font.width((FormattedText)txt), 20, (Component)txt, ((AbstractComparisonFilter)this.filter).getComparison().percentage()), 5);
        }
        layout.arrangeElements();
        layout.visitWidgets(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
        });
    }

    public boolean keyPressed(int pKeyCode, int pScanCode, int pModifiers) {
        if ((pKeyCode == 257 || pKeyCode == 335) && this.numBox.canConsumeInput()) {
            this.applyChanges();
        }
        return super.keyPressed(pKeyCode, pScanCode, pModifiers);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double dirX, double dirY) {
        this.adjustVal(dirY < 0.0 ? -1 : 1);
        return true;
    }

    private boolean isValidNumber(String str) {
        if (NumberUtils.isDigits((String)str)) {
            if (this.isPercent()) {
                int v = Integer.parseInt(str);
                return v >= 0 && v <= 100;
            }
            return true;
        }
        return false;
    }

    private void adjustVal(int amount) {
        try {
            String s = this.numBox.getValue();
            int value = (s.isEmpty() ? 0 : Integer.parseInt(s)) + amount;
            this.numBox.setResponder(str -> {});
            this.numBox.setValue(String.valueOf(value));
            this.numBox.setResponder(str -> this.adjustVal(0));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    @Override
    protected T makeNewFilter() {
        try {
            int value = Integer.parseInt(this.numBox.getValue());
            NumericComparison comparison = new NumericComparison((NumericComparison.ComparisonOp)((Object)this.opBtn.getValue()), value, this.isPercent());
            return (T)((AbstractComparisonFilter)this.comparisonFactory.apply(((AbstractComparisonFilter)this.filter).getParent(), comparison));
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    protected boolean isPercent() {
        return this.pctCheckBox != null && this.pctCheckBox.selected();
    }
}

