/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.tiles;

import java.util.ArrayList;
import net.mehvahdjukaar.moonlight.api.block.ItemDisplayTile;
import net.mehvahdjukaar.supplementaries.common.block.ModBlockProperties;
import net.mehvahdjukaar.supplementaries.common.block.blocks.PulleyBlock;
import net.mehvahdjukaar.supplementaries.common.inventories.PulleyContainerMenu;
import net.mehvahdjukaar.supplementaries.common.utils.RopeHelper;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.mehvahdjukaar.supplementaries.reg.ModTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChainBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class PulleyBlockTile
extends ItemDisplayTile {
    public PulleyBlockTile(BlockPos pos, BlockState state) {
        super(ModRegistry.PULLEY_BLOCK_TILE.get(), pos, state);
    }

    public void updateTileOnInventoryChanged() {
        ModBlockProperties.Winding type = PulleyBlockTile.getContentType(this.getDisplayedItem().getItem());
        BlockState state = this.getBlockState();
        if (state.getValue(PulleyBlock.TYPE) != type) {
            this.level.setBlockAndUpdate(this.worldPosition, (BlockState)state.setValue(PulleyBlock.TYPE, (Comparable)((Object)type)));
        }
    }

    public static ModBlockProperties.Winding getContentType(Item item) {
        BlockItem bi;
        ModBlockProperties.Winding type = ModBlockProperties.Winding.NONE;
        if (item instanceof BlockItem && (bi = (BlockItem)item).getBlock() instanceof ChainBlock || item.builtInRegistryHolder().is(ModTags.CHAINS)) {
            type = ModBlockProperties.Winding.CHAIN;
        } else if (item.builtInRegistryHolder().is(ModTags.ROPES)) {
            type = ModBlockProperties.Winding.ROPE;
        }
        return type;
    }

    public Component getDefaultName() {
        return Component.translatable((String)"gui.supplementaries.pulley_block");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int i, Inventory inventory, Player player) {
        return new PulleyContainerMenu(i, inventory, (Container)this);
    }

    public boolean canPlaceItem(int index, ItemStack stack) {
        return PulleyBlockTile.getContentType(stack.getItem()) != ModBlockProperties.Winding.NONE;
    }

    public boolean canPlaceItemThroughFace(int index, ItemStack stack, @Nullable Direction direction) {
        return this.canPlaceItem(index, stack);
    }

    public boolean canTakeItemThroughFace(int index, ItemStack stack, Direction direction) {
        return true;
    }

    public int getMaxStackSize() {
        return 64;
    }

    public boolean rotateDirectly(Rotation rot) {
        if (rot == Rotation.CLOCKWISE_90) {
            return this.pullRopeUp();
        }
        if (rot == Rotation.COUNTERCLOCKWISE_90) {
            return this.releaseRopeDown();
        }
        return false;
    }

    public boolean pullRopeUp() {
        return this.pullRope(Direction.DOWN, Integer.MAX_VALUE, true);
    }

    public boolean pullRope(Direction moveDir, int maxDist, boolean addItem) {
        ItemStack stack = this.getDisplayedItem();
        boolean addNewItem = false;
        if (stack.isEmpty()) {
            Item i = this.level.getBlockState(this.worldPosition.below()).getBlock().asItem();
            if (PulleyBlockTile.getContentType(i) == ModBlockProperties.Winding.NONE) {
                return false;
            }
            stack = new ItemStack((ItemLike)i);
            addNewItem = true;
        }
        if (stack.getCount() + 1 > stack.getMaxStackSize() || !(stack.getItem() instanceof BlockItem)) {
            return false;
        }
        Block ropeBlock = ((BlockItem)stack.getItem()).getBlock();
        boolean success = RopeHelper.removeRope(this.worldPosition.relative(moveDir), this.level, ropeBlock, moveDir, maxDist);
        if (success) {
            SoundType soundtype = ropeBlock.defaultBlockState().getSoundType();
            this.level.playSound(null, this.worldPosition, soundtype.getBreakSound(), SoundSource.BLOCKS, (soundtype.getVolume() + 1.0f) / 2.0f, soundtype.getPitch() * 0.8f);
            if (addNewItem) {
                this.setDisplayedItem(stack);
            } else if (addItem) {
                stack.grow(1);
            }
            this.setChanged();
        }
        return success;
    }

    public boolean releaseRopeDown() {
        return this.releaseRope(Direction.DOWN, Integer.MAX_VALUE, true);
    }

    public boolean releaseRope(Direction dir, int maxDist, boolean removeItem) {
        Item item;
        ItemStack stack = this.getDisplayedItem();
        if (stack.getCount() < 1 || !((item = stack.getItem()) instanceof BlockItem)) {
            return false;
        }
        BlockItem bi = (BlockItem)item;
        Block ropeBlock = bi.getBlock();
        boolean success = RopeHelper.addRope(this.worldPosition.relative(dir), this.level, null, InteractionHand.MAIN_HAND, ropeBlock, dir, dir == Direction.DOWN, maxDist);
        if (success) {
            SoundType soundtype = ropeBlock.defaultBlockState().getSoundType();
            this.level.playSound(null, this.worldPosition, soundtype.getPlaceSound(), SoundSource.BLOCKS, (soundtype.getVolume() + 1.0f) / 2.0f, soundtype.getPitch() * 0.8f);
            if (removeItem) {
                stack.shrink(1);
                this.setChanged();
            }
        }
        return success;
    }

    public boolean rotateIndirect(Player player, InteractionHand hand, Block ropeBlock, Direction moveDir, boolean retracting) {
        Direction[] directionArray;
        ItemStack stack = this.getDisplayedItem();
        if (stack.isEmpty()) {
            if (retracting) {
                return false;
            }
            this.setDisplayedItem(new ItemStack((ItemLike)ropeBlock));
            return true;
        }
        if (!stack.is(ropeBlock.asItem())) {
            return false;
        }
        BlockState state = this.getBlockState();
        Direction.Axis axis = (Direction.Axis)state.getValue((Property)PulleyBlock.AXIS);
        if (axis == moveDir.getAxis()) {
            return false;
        }
        this.level.setBlockAndUpdate(this.worldPosition, (BlockState)state.cycle((Property)PulleyBlock.FLIPPED));
        if (moveDir.getAxis().isHorizontal()) {
            Direction[] directionArray2 = new Direction[1];
            directionArray = directionArray2;
            directionArray2[0] = Direction.DOWN;
        } else {
            Direction[] directionArray3 = new Direction[3];
            directionArray3[0] = moveDir;
            directionArray3[1] = moveDir.getClockWise(axis);
            directionArray = directionArray3;
            directionArray3[2] = moveDir.getCounterClockWise(axis);
        }
        Direction[] order = directionArray;
        ArrayList<Direction> remaining = new ArrayList<Direction>();
        int maxSideDist = 7;
        for (Direction d : order) {
            if (RopeHelper.isCorrectRope(ropeBlock, this.level.getBlockState(this.worldPosition.relative(d)), d)) {
                return this.moveConnected(retracting, maxSideDist, d);
            }
            remaining.add(d);
        }
        for (Direction d : remaining) {
            if (!this.moveConnected(retracting, maxSideDist, d)) continue;
            return true;
        }
        if (retracting) {
            stack.shrink(1);
            this.setChanged();
            return true;
        }
        return false;
    }

    private boolean moveConnected(boolean retracting, int maxSideDist, Direction d) {
        int dist;
        int n = dist = d == Direction.DOWN ? Integer.MAX_VALUE : maxSideDist;
        if (retracting) {
            return this.pullRope(d, dist, false);
        }
        return this.releaseRope(d, dist, false);
    }

    public boolean needsToUpdateClientWhenChanged() {
        return false;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return null;
    }
}

