/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.items.loot;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class RandomEnchantFunction
extends LootItemConditionalFunction {
    public static final MapCodec<RandomEnchantFunction> CODEC = RecordCodecBuilder.mapCodec(instance -> RandomEnchantFunction.commonFields((RecordCodecBuilder.Instance)instance).and(instance.group((App)Codec.DOUBLE.fieldOf("chance").forGetter(f -> f.chance), (App)RegistryCodecs.homogeneousList((ResourceKey)Registries.ENCHANTMENT).fieldOf("enchantments").forGetter(f -> f.curses))).apply((Applicative)instance, RandomEnchantFunction::new));
    private final double chance;
    private final HolderSet<Enchantment> curses;

    public RandomEnchantFunction(List<LootItemCondition> pConditions, double chance, HolderSet<Enchantment> curses) {
        super(pConditions);
        this.chance = chance;
        this.curses = curses;
    }

    public LootItemFunctionType<RandomEnchantFunction> getType() {
        return ModRegistry.CURSE_LOOT_FUNCTION.get();
    }

    public ItemStack run(ItemStack pStack, LootContext context) {
        ItemEnchantments.Mutable enchantments = new ItemEnchantments.Mutable(EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)pStack));
        RandomSource random = context.getRandom();
        if ((double)random.nextFloat() < this.chance && this.curses.stream().noneMatch(h -> enchantments.getLevel(h) != 0)) {
            Optional e = this.curses.getRandomElement(random);
            e.ifPresent(enchantmentHolder -> enchantments.set(enchantmentHolder, 1));
        }
        EnchantmentHelper.setEnchantments((ItemStack)pStack, (ItemEnchantments)enchantments.toImmutable());
        return pStack;
    }
}

