/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.utils;

import io.netty.buffer.ByteBuf;
import net.mehvahdjukaar.moonlight.api.misc.StreamCodecMapRegistry;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.supplementaries.api.IQuiverEntity;
import net.mehvahdjukaar.supplementaries.common.items.QuiverItem;
import net.minecraft.Util;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public interface SlotReference {
    public static final Empty EMPTY = new Empty();
    public static final StreamCodecMapRegistry<SlotReference> REGISTRY = (StreamCodecMapRegistry)Util.make(() -> {
        StreamCodecMapRegistry m = new StreamCodecMapRegistry("slot_reference");
        m.register("hand", Hand.CODEC);
        m.register("inv", Inv.CODEC);
        m.register("empty", Empty.CODEC);
        m.register("eq_slot", EqSlot.CODEC);
        m.register("quiver", Quiver.CODEC);
        return m;
    });
    public static final StreamCodec<FriendlyByteBuf, SlotReference> STREAM_CODEC = REGISTRY.getStreamCodec().dispatch(SlotReference::getCodec, c -> c);

    default public Item getItem(LivingEntity player) {
        return this.get(player).getItem();
    }

    public ItemStack get(LivingEntity var1);

    public static SlotReference hand(InteractionHand pUsedHand) {
        return new Hand(pUsedHand);
    }

    public static SlotReference slot(EquipmentSlot equipmentSlot) {
        return new EqSlot(equipmentSlot);
    }

    public static SlotReference inv(int invSlot) {
        return new Inv(invSlot);
    }

    @NotNull
    public static SlotReference quiver(IQuiverEntity e) {
        return Quiver.INSTANCE;
    }

    default public boolean isEmpty() {
        return this == EMPTY;
    }

    public StreamCodec<? super RegistryFriendlyByteBuf, ? extends SlotReference> getCodec();

    public record Hand(InteractionHand hand) implements SlotReference
    {
        public static final StreamCodec<FriendlyByteBuf, Hand> CODEC = Utils.enumStreamCodec(InteractionHand.class).map(Hand::new, Hand::hand);

        @Override
        public ItemStack get(LivingEntity player) {
            return player.getItemInHand(this.hand);
        }

        public StreamCodec<FriendlyByteBuf, Hand> getCodec() {
            return CODEC;
        }
    }

    public record EqSlot(EquipmentSlot slot) implements SlotReference
    {
        public static final StreamCodec<FriendlyByteBuf, EqSlot> CODEC = Utils.enumStreamCodec(EquipmentSlot.class).map(EqSlot::new, EqSlot::slot);

        @Override
        public ItemStack get(LivingEntity player) {
            return player.getItemBySlot(this.slot);
        }

        public StreamCodec<FriendlyByteBuf, EqSlot> getCodec() {
            return CODEC;
        }
    }

    public record Inv(int invSlot) implements SlotReference
    {
        public static final StreamCodec<ByteBuf, Inv> CODEC = ByteBufCodecs.INT.map(Inv::new, Inv::invSlot);

        @Override
        public ItemStack get(LivingEntity player) {
            return player.getSlot(this.invSlot).get();
        }

        public StreamCodec<ByteBuf, Inv> getCodec() {
            return CODEC;
        }
    }

    public record Quiver() implements SlotReference
    {
        private static final Quiver INSTANCE = new Quiver();
        private static final StreamCodec<FriendlyByteBuf, Quiver> CODEC = StreamCodec.unit((Object)INSTANCE);

        @Override
        public ItemStack get(LivingEntity player) {
            if (player instanceof Player) {
                Player p = (Player)player;
                return QuiverItem.findActiveQuiver((LivingEntity)p);
            }
            return ItemStack.EMPTY;
        }

        public StreamCodec<FriendlyByteBuf, Quiver> getCodec() {
            return CODEC;
        }
    }

    public record Empty() implements SlotReference
    {
        public static final StreamCodec<ByteBuf, Empty> CODEC = StreamCodec.unit((Object)EMPTY);

        @Override
        public ItemStack get(LivingEntity player) {
            return ItemStack.EMPTY;
        }

        public StreamCodec<ByteBuf, Empty> getCodec() {
            return CODEC;
        }
    }
}

