/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.client.render;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.neoforged.neoforge.client.model.geometry.IGeometryBakingContext;
import net.neoforged.neoforge.client.model.geometry.StandaloneGeometryBakingContext;
import net.neoforged.neoforge.client.model.obj.ObjLoader;
import net.neoforged.neoforge.client.model.obj.ObjModel;
import net.neoforged.neoforge.client.model.renderable.CompositeRenderable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Vector4f;
import tv.soaryn.xycraft.core.datagen.CoreResources;
import tv.soaryn.xycraft.core.utils.ColorUtils;

public class ModelHandle {
    private final CompositeRenderable renderable;

    public static ModelHandle of(String modelLocation) {
        return new ModelHandle(ResourceLocation.parse((String)modelLocation));
    }

    public static ModelHandle of(String modId, String location) {
        return new ModelHandle(ResourceLocation.fromNamespaceAndPath((String)modId, (String)location));
    }

    public static ModelHandle of(ResourceLocation location) {
        return new ModelHandle(location);
    }

    public static ModelHandle of(ResourceLocation location, boolean automaticCulling, boolean shadeQuads, boolean flipV, boolean emissiveAmbient, @Nullable String mtlOverride) {
        return new ModelHandle(new ObjModel.ModelSettings(location, automaticCulling, shadeQuads, flipV, emissiveAmbient, mtlOverride));
    }

    public ModelHandle(ObjModel.ModelSettings modelSettings) {
        ObjModel model = ObjLoader.INSTANCE.loadModel(modelSettings);
        this.renderable = model.bakeRenderable((IGeometryBakingContext)StandaloneGeometryBakingContext.create((ResourceLocation)modelSettings.modelLocation()));
    }

    public ModelHandle(ResourceLocation modelLocation) {
        ObjModel model = ObjLoader.INSTANCE.loadModel(new ObjModel.ModelSettings(modelLocation, false, true, true, true, null));
        this.renderable = model.bakeRenderable((IGeometryBakingContext)StandaloneGeometryBakingContext.create((ResourceLocation)modelLocation));
    }

    public void render(PoseStack poseStack, MultiBufferSource bufferIn, RenderType rt, int packedLightIn, int color) {
        Vector4f components = ColorUtils.convertToRGBAVec((int)color);
        bufferIn = new ColoringBufferSource(components.x(), components.y(), components.z(), components.w(), bufferIn);
        this.renderable.render(poseStack, bufferIn, t -> rt, packedLightIn, OverlayTexture.NO_OVERLAY, 0.0f, CompositeRenderable.Transforms.EMPTY);
    }

    public static class ColoringBufferSource
    implements MultiBufferSource {
        public final float _r;
        public final float _g;
        public final float _b;
        public final float _a;
        private final MultiBufferSource inner;

        public ColoringBufferSource(float r, float g, float b, float a, MultiBufferSource inner) {
            this._r = r;
            this._g = g;
            this._b = b;
            this._a = a;
            this.inner = inner;
            TextureAtlas atlas = (TextureAtlas)Minecraft.getInstance().getTextureManager().getTexture(InventoryMenu.BLOCK_ATLAS);
            TextureAtlasSprite _sprite = atlas.getSprite(CoreResources.CloudFX);
        }

        @NotNull
        public VertexConsumer getBuffer(@NotNull RenderType rt) {
            return new ConsumerWrapper(this.inner.getBuffer(rt));
        }

        private class ConsumerWrapper
        implements VertexConsumer {
            private final VertexConsumer buffer;

            public ConsumerWrapper(VertexConsumer buffer) {
                this.buffer = buffer;
            }

            @NotNull
            public VertexConsumer addVertex(@NotNull Matrix4f matrix, float x, float y, float z) {
                return this.buffer.addVertex(matrix, x, y, z);
            }

            @NotNull
            public VertexConsumer addVertex(float x, float y, float z) {
                return this.buffer.addVertex(x, y, z);
            }

            @NotNull
            public VertexConsumer setColor(int r, int g, int b, int a) {
                return this.buffer.setColor((int)((float)r * ColoringBufferSource.this._r), (int)((float)g * ColoringBufferSource.this._g), (int)((float)b * ColoringBufferSource.this._b), (int)((float)a * ColoringBufferSource.this._a));
            }

            @NotNull
            public VertexConsumer setColor(float r, float g, float b, float a) {
                return this.buffer.setColor(r * ColoringBufferSource.this._r, g * ColoringBufferSource.this._g, b * ColoringBufferSource.this._b, a * ColoringBufferSource.this._a);
            }

            @NotNull
            public VertexConsumer setUv(float u, float v) {
                return this.buffer.setUv(u, v);
            }

            public VertexConsumer setUv1(int u, int v) {
                return this.buffer.setUv1(u, v);
            }

            @NotNull
            public VertexConsumer setOverlay(int u) {
                return this.buffer.setOverlay(u);
            }

            @NotNull
            public VertexConsumer setUv2(int u, int v) {
                return this.buffer.setUv2(u, v);
            }

            @NotNull
            public VertexConsumer setNormal(float x, float y, float z) {
                return this.buffer.setNormal(x, y, z);
            }

            @NotNull
            public VertexConsumer setNormal(// Could not load outer class - annotation placement on inner may be incorrect
            @NotNull PoseStack.Pose pose, float x, float y, float z) {
                return this.buffer.setNormal(pose, x, y, z);
            }
        }
    }

    public static class BuilderBufferSource
    implements MultiBufferSource {
        private final BufferBuilder _builder;

        public BuilderBufferSource(BufferBuilder builder) {
            this._builder = builder;
        }

        @NotNull
        public VertexConsumer getBuffer(@NotNull RenderType type) {
            return this._builder;
        }
    }
}

