/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.content.blocks.pipe;

import java.util.List;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.level.BlockDropsEvent;
import tv.soaryn.xycraft.core.content.XyCraftTags;

@EventBusSubscriber(modid="xycraft_machines", bus=EventBusSubscriber.Bus.GAME)
public class QuickRemoveEvents {
    public static boolean isMineable(BlockState state) {
        return state.is(XyCraftTags.Blocks.MineableQuickRemove.tag()) && !state.is(XyCraftTags.Blocks.IncorrectForQuickRemove.tag());
    }

    public static boolean isUsingQuickRemover(Player player) {
        return QuickRemoveEvents.isQuickRemover(player.getItemInHand(InteractionHand.MAIN_HAND));
    }

    public static boolean isQuickRemover(ItemStack stack) {
        return stack.is(XyCraftTags.Items.QuickPickup.tag());
    }

    public static boolean isAbleToBeQuickRemoved(BlockState state) {
        return state.is(XyCraftTags.Blocks.QuickRemovable.tag());
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    private static void mineSpeedPipeWithWrench(PlayerEvent.BreakSpeed event) {
        if (!QuickRemoveEvents.isAbleToBeQuickRemoved(event.getState())) {
            return;
        }
        if (!QuickRemoveEvents.isUsingQuickRemover(event.getEntity())) {
            return;
        }
        event.setNewSpeed(Float.POSITIVE_INFINITY);
    }

    @SubscribeEvent
    private static void harvestCheck(PlayerEvent.HarvestCheck event) {
        if (event.canHarvest() || !QuickRemoveEvents.isMineable(event.getTargetBlock()) || !QuickRemoveEvents.isUsingQuickRemover(event.getEntity())) {
            return;
        }
        event.setCanHarvest(true);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    private static void breakPipeWithWrench(BlockDropsEvent event) {
        ServerPlayer player;
        if (!QuickRemoveEvents.isAbleToBeQuickRemoved(event.getState()) || !QuickRemoveEvents.isQuickRemover(event.getTool())) {
            return;
        }
        Entity entity = event.getBreaker();
        if (!(entity instanceof ServerPlayer) || (player = (ServerPlayer)entity).isFakePlayer()) {
            return;
        }
        boolean hasItems = false;
        List drops = event.getDrops();
        for (int i = drops.size() - 1; i >= 0; --i) {
            ItemEntity drop = (ItemEntity)drops.get(i);
            player.getInventory().add(drop.getItem());
            if (drop.getItem().isEmpty()) {
                drops.remove(i);
                continue;
            }
            hasItems = true;
        }
        event.setCanceled(!hasItems);
    }
}

