/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.content.recipes.energy.isolator;

import net.minecraft.advancements.Advancement;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;
import tv.soaryn.xycraft.core.content.recipe.IRecipeBuilder;
import tv.soaryn.xycraft.core.utils.rules.BlockRule;
import tv.soaryn.xycraft.core.utils.rules.BlockTagRule;
import tv.soaryn.xycraft.core.utils.rules.IRule;
import tv.soaryn.xycraft.machines.content.recipes.energy.isolator.IsolatorRecipe;

public class IsolatorRecipeBuilder
implements IRecipeBuilder<IsolatorRecipeBuilder, IsolatorRecipe> {
    private long _xynergy;
    private IRule _target;
    private final Advancement.Builder advancement = Advancement.Builder.advancement();

    public static IsolatorRecipeBuilder create(long xynergy) {
        if (xynergy > 0L) {
            return new IsolatorRecipeBuilder().output(xynergy);
        }
        throw new IllegalArgumentException("Xynergy amount must be greater than 0");
    }

    private IsolatorRecipeBuilder output(long xynergy) {
        if (xynergy <= 0L) {
            throw new IllegalArgumentException("Xynergy amount must be greater than 0");
        }
        this._xynergy = xynergy;
        return this;
    }

    public IsolatorRecipeBuilder target(IRule test) {
        this._target = test;
        return this;
    }

    public IsolatorRecipeBuilder target(Block block) {
        this._target = new BlockRule(block);
        return this;
    }

    public IsolatorRecipeBuilder target(TagKey<Block> tag) {
        this._target = new BlockTagRule(tag);
        return this;
    }

    @NotNull
    public IsolatorRecipeBuilder ticks(long ticks) {
        return this;
    }

    @NotNull
    public IsolatorRecipe makeRecipe() {
        return new IsolatorRecipe(this._xynergy, this._target);
    }

    public void ensureValid(String id) {
        if (this._target == null) {
            throw new RuntimeException("Target is null in Isolator recipe - " + id);
        }
        if (this._xynergy <= 0L) {
            throw new RuntimeException("Xynergy is 0 in Isolator recipe - " + id);
        }
    }
}

