/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.content.recipes.producers.extractor;

import java.util.EnumSet;
import java.util.Objects;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.conditions.ModLoadedCondition;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import tv.soaryn.xycraft.core.content.CompatContent;
import tv.soaryn.xycraft.core.content.XyCraftTags;
import tv.soaryn.xycraft.core.utils.rules.BlockRule;
import tv.soaryn.xycraft.core.utils.rules.BlockTagRule;
import tv.soaryn.xycraft.core.utils.rules.FluidTagRule;
import tv.soaryn.xycraft.core.utils.rules.FluidTypeRule;
import tv.soaryn.xycraft.core.utils.rules.IRule;
import tv.soaryn.xycraft.machines.content.recipes.producers.extractor.ExtractorRecipeBuilder;
import tv.soaryn.xycraft.machines.content.registries.MachinesContent;
import tv.soaryn.xycraft.world.content.registries.WorldContent;

public interface ExtractorRecipeList {
    public static void build(@NotNull RecipeOutput recipeOutput) {
        ExtractorRecipeList.makeStoneVariantRecipe(recipeOutput, (ItemLike)Blocks.COBBLESTONE, (IRule)new BlockRule(Blocks.COBBLESTONE));
        ExtractorRecipeList.makeStoneVariantRecipe(recipeOutput, (ItemLike)Blocks.GRANITE, (IRule)new BlockRule(Blocks.GRANITE));
        ExtractorRecipeList.makeStoneVariantRecipe(recipeOutput, (ItemLike)Blocks.ANDESITE, (IRule)new BlockRule(Blocks.ANDESITE));
        ExtractorRecipeList.makeStoneVariantRecipe(recipeOutput, (ItemLike)Blocks.DIORITE, (IRule)new BlockRule(Blocks.DIORITE));
        ExtractorRecipeList.makeStoneVariantRecipe(recipeOutput, (ItemLike)Blocks.TUFF, (IRule)new BlockRule(Blocks.TUFF));
        ExtractorRecipeList.makeStoneVariantRecipe(recipeOutput, (ItemLike)WorldContent.Block.Kivi.block(), (IRule)new BlockRule(WorldContent.Block.Kivi.block()));
        ((ExtractorRecipeBuilder)ExtractorRecipeBuilder.create().output((ItemLike)Items.SNOWBALL)).validDirections(EnumSet.of(Direction.DOWN)).target(Blocks.PUMPKIN).catalyst((TagKey<Block>)BlockTags.SNOW).ticks(5L).hidden().save(recipeOutput, "snowball");
        ((ExtractorRecipeBuilder)ExtractorRecipeBuilder.create().output((ItemLike)Items.SNOWBALL)).validDirections(EnumSet.of(Direction.DOWN)).target(Blocks.CARVED_PUMPKIN).catalyst((TagKey<Block>)BlockTags.SNOW).ticks(5L).save(recipeOutput, "snowball_0");
        ((ExtractorRecipeBuilder)ExtractorRecipeBuilder.create().output((ItemLike)Items.SNOWBALL)).validDirections(EnumSet.of(Direction.UP)).catalyst(Blocks.PUMPKIN).target((TagKey<Block>)BlockTags.SNOW).ticks(5L).hidden().save(recipeOutput, "snowball_1");
        ((ExtractorRecipeBuilder)ExtractorRecipeBuilder.create().output((ItemLike)Items.SNOWBALL)).validDirections(EnumSet.of(Direction.UP)).target((TagKey<Block>)BlockTags.SNOW).catalyst(Blocks.CARVED_PUMPKIN).ticks(5L).save(recipeOutput, "snowball_2");
        ((ExtractorRecipeBuilder)ExtractorRecipeBuilder.create().output((ItemLike)Blocks.STONE)).target(Blocks.COBBLESTONE).catalyst(Blocks.MAGMA_BLOCK).adjacentRule((IRule)FluidTypeRule.water()).adjacentRule((IRule)FluidTypeRule.lava()).ticks(30L).save(recipeOutput, "stone");
        ((ExtractorRecipeBuilder)ExtractorRecipeBuilder.create().output((ItemLike)Blocks.STONE)).target(Blocks.COBBLESTONE).adjacentRule((IRule)FluidTypeRule.lava()).catalyst(Blocks.MAGMA_BLOCK).waterLogged().ticks(30L).hidden().save(recipeOutput, "stone_waterlogged");
        ((ExtractorRecipeBuilder)ExtractorRecipeBuilder.create().output((ItemLike)Blocks.STONE)).target(Blocks.STONE).adjacentRule((IRule)FluidTypeRule.water()).adjacentRule((IRule)FluidTypeRule.lava()).catalyst(Blocks.MAGMA_BLOCK).ticks(30L).save(recipeOutput, "stone_0");
        ((ExtractorRecipeBuilder)ExtractorRecipeBuilder.create().output((ItemLike)Blocks.STONE)).target(Blocks.STONE).adjacentRule((IRule)FluidTypeRule.lava()).catalyst(Blocks.MAGMA_BLOCK).waterLogged().ticks(30L).hidden().save(recipeOutput, "stone_0_waterlogged");
        ((ExtractorRecipeBuilder)ExtractorRecipeBuilder.create().output((ItemLike)Blocks.STONE)).target(Blocks.COBBLESTONE).adjacentRule(MachinesContent.Block.WaterBlock).adjacentRule((IRule)FluidTypeRule.lava()).catalyst(Blocks.MAGMA_BLOCK).ticks(30L).hidden().save(recipeOutput, "stone_wb");
        ((ExtractorRecipeBuilder)ExtractorRecipeBuilder.create().output((ItemLike)Blocks.STONE)).target(Blocks.STONE).adjacentRule(MachinesContent.Block.WaterBlock.block()).adjacentRule((IRule)FluidTypeRule.lava()).catalyst(Blocks.MAGMA_BLOCK).ticks(30L).hidden().save(recipeOutput, "stone_0_wb");
        ((ExtractorRecipeBuilder)ExtractorRecipeBuilder.create().output((ItemLike)Blocks.NETHERRACK)).target(Blocks.GRAVEL).adjacentRule((IRule)FluidTypeRule.lava()).adjacentRule((IRule)FluidTypeRule.lava()).ticks(30L).save(recipeOutput, "netherrack");
        ((ExtractorRecipeBuilder)ExtractorRecipeBuilder.create().output((ItemLike)Blocks.NETHERRACK)).target(Blocks.GRAVEL).adjacentRule((IRule)FluidTypeRule.lava()).catalyst((IRule)FluidTypeRule.lava()).ticks(30L).hidden().save(recipeOutput, "netherrack_catalyst");
        ((ExtractorRecipeBuilder)ExtractorRecipeBuilder.create().output((ItemLike)Blocks.COBBLED_DEEPSLATE)).target(Blocks.COBBLED_DEEPSLATE).adjacentRule((IRule)FluidTypeRule.lava()).adjacentRule(Blocks.PACKED_ICE).ticks(30L).save(recipeOutput, "cobbled_deepslate");
        ((ExtractorRecipeBuilder)ExtractorRecipeBuilder.create().output((ItemLike)Blocks.COBBLED_DEEPSLATE)).target(Blocks.COBBLED_DEEPSLATE).adjacentRule((IRule)FluidTypeRule.lava()).catalyst(Blocks.PACKED_ICE).ticks(30L).hidden().save(recipeOutput, "cobbled_deepslate_catalyst");
        ((ExtractorRecipeBuilder)ExtractorRecipeBuilder.create().output((ItemLike)Blocks.COBBLED_DEEPSLATE)).target(Blocks.COBBLED_DEEPSLATE).catalyst((IRule)FluidTypeRule.lava()).adjacentRule(Blocks.PACKED_ICE).ticks(30L).hidden().save(recipeOutput, "cobbled_deepslate_catalyst_0");
        ((ExtractorRecipeBuilder)ExtractorRecipeBuilder.create().output((ItemLike)Blocks.DEEPSLATE)).target(Blocks.COBBLED_DEEPSLATE).adjacentRule((IRule)FluidTypeRule.lava()).adjacentRule(Blocks.PACKED_ICE).catalyst(Blocks.MAGMA_BLOCK).ticks(30L).save(recipeOutput, "deepslate");
        ((ExtractorRecipeBuilder)ExtractorRecipeBuilder.create().output((ItemLike)Blocks.BASALT)).target(Blocks.BASALT).adjacentRule((IRule)FluidTypeRule.lava()).adjacentRule(Blocks.BLUE_ICE).adjacentRule(Blocks.SOUL_SOIL).ticks(30L).save(recipeOutput, "basalt");
        ((ExtractorRecipeBuilder)ExtractorRecipeBuilder.create().output((ItemLike)Blocks.BASALT)).target(Blocks.BASALT).adjacentRule((IRule)FluidTypeRule.lava()).adjacentRule(Blocks.SOUL_SOIL).catalyst(Blocks.BLUE_ICE).ticks(30L).hidden().save(recipeOutput, "basalt_catalyst");
        ((ExtractorRecipeBuilder)ExtractorRecipeBuilder.create().output((ItemLike)Blocks.BASALT)).target(Blocks.BASALT).catalyst((IRule)FluidTypeRule.lava()).adjacentRule(Blocks.BLUE_ICE).adjacentRule(Blocks.SOUL_SOIL).ticks(30L).hidden().save(recipeOutput, "basalt_catalyst_0");
        ((ExtractorRecipeBuilder)ExtractorRecipeBuilder.create().output((ItemLike)Blocks.BASALT)).target(Blocks.BASALT).adjacentRule((IRule)FluidTypeRule.lava()).adjacentRule(Blocks.BLUE_ICE).catalyst(Blocks.SOUL_SOIL).ticks(30L).hidden().save(recipeOutput, "basalt_catalyst_1");
        ((ExtractorRecipeBuilder)ExtractorRecipeBuilder.create().output((ItemLike)Blocks.SMOOTH_BASALT)).target(Blocks.BASALT).adjacentRule((IRule)FluidTypeRule.lava()).adjacentRule(Blocks.BLUE_ICE).adjacentRule(Blocks.SOUL_SOIL).catalyst(Blocks.MAGMA_BLOCK).ticks(30L).save(recipeOutput, "smooth_basalt");
        ((ExtractorRecipeBuilder)ExtractorRecipeBuilder.create().output((ItemLike)Blocks.POINTED_DRIPSTONE)).target(Blocks.DRIPSTONE_BLOCK).catalyst((IRule)FluidTypeRule.water()).validDirections(EnumSet.of(Direction.UP)).ticks(1200L).save(recipeOutput, "pointed_dripstone");
        ((ExtractorRecipeBuilder)ExtractorRecipeBuilder.create().output((ItemLike)Blocks.POINTED_DRIPSTONE)).target(Blocks.DRIPSTONE_BLOCK).catalyst((IRule)new BlockRule(MachinesContent.Block.WaterBlock.block())).validDirections(EnumSet.of(Direction.UP)).ticks(1200L).hidden().save(recipeOutput, "pointed_dripstone_waterblock");
        ExtractorRecipeBuilder.create().output(new FluidStack((Fluid)Fluids.LAVA, 5)).target(Blocks.DRIPSTONE_BLOCK).catalyst((IRule)FluidTypeRule.lava()).validDirections(EnumSet.of(Direction.UP)).ticks(10L).save(recipeOutput, "lava");
        ((ExtractorRecipeBuilder)ExtractorRecipeBuilder.create().output((ItemLike)Items.AMETHYST_SHARD)).target(Blocks.BUDDING_AMETHYST).adjacentRule((IRule)FluidTypeRule.water()).ticks(1200L).save(recipeOutput, "amethyst_shard");
        ((ExtractorRecipeBuilder)ExtractorRecipeBuilder.create().output((ItemLike)Items.AMETHYST_SHARD)).target(Blocks.BUDDING_AMETHYST).catalyst((IRule)FluidTypeRule.water()).ticks(1200L).hidden().save(recipeOutput, "amethyst_shard_catalyst");
        ((ExtractorRecipeBuilder)ExtractorRecipeBuilder.create().output((ItemLike)Items.AMETHYST_SHARD)).target(Blocks.BUDDING_AMETHYST).adjacentRule(MachinesContent.Block.WaterBlock.block()).ticks(1200L).hidden().save(recipeOutput, "amethyst_shard_wb");
        ((ExtractorRecipeBuilder)ExtractorRecipeBuilder.create().output((ItemLike)Items.AMETHYST_SHARD)).target(Blocks.BUDDING_AMETHYST).catalyst(MachinesContent.Block.WaterBlock.block()).ticks(1200L).hidden().save(recipeOutput, "amethyst_shard_wb_catalyst");
        ((ExtractorRecipeBuilder)ExtractorRecipeBuilder.create().output((ItemLike)Items.AMETHYST_SHARD)).target(Blocks.BUDDING_AMETHYST).waterLogged().ticks(1200L).hidden().save(recipeOutput, "amethyst_shard_waterlogged");
        ((ExtractorRecipeBuilder)ExtractorRecipeBuilder.create().output((ItemLike)Blocks.MUD)).target((TagKey<Block>)BlockTags.DIRT).adjacentRule((IRule)FluidTagRule.water()).ticks(10L).save(recipeOutput, "mud");
        ((ExtractorRecipeBuilder)ExtractorRecipeBuilder.create().output((ItemLike)Blocks.MUD)).target((TagKey<Block>)BlockTags.DIRT).catalyst((IRule)FluidTypeRule.water()).ticks(10L).hidden().save(recipeOutput, "mud_catalyst");
        ((ExtractorRecipeBuilder)ExtractorRecipeBuilder.create().output((ItemLike)Blocks.MUD)).target((TagKey<Block>)BlockTags.DIRT).adjacentRule(MachinesContent.Block.WaterBlock.block()).ticks(10L).hidden().save(recipeOutput, "mud_wb");
        ((ExtractorRecipeBuilder)ExtractorRecipeBuilder.create().output((ItemLike)Blocks.MUD)).target((TagKey<Block>)BlockTags.DIRT).catalyst(MachinesContent.Block.WaterBlock.block()).ticks(10L).hidden().save(recipeOutput, "mud_wb_catalyst");
        ((ExtractorRecipeBuilder)ExtractorRecipeBuilder.create().output((ItemLike)Blocks.BLACKSTONE)).target(Blocks.BLACKSTONE).adjacentRule((IRule)FluidTypeRule.lava()).adjacentRule(Blocks.BLUE_ICE).adjacentRule(Blocks.SOUL_SOIL).ticks(30L).save(recipeOutput, "blackstone");
        ((ExtractorRecipeBuilder)ExtractorRecipeBuilder.create().output((ItemLike)Blocks.BLACKSTONE)).target(Blocks.BLACKSTONE).adjacentRule((IRule)FluidTypeRule.lava()).adjacentRule(Blocks.SOUL_SOIL).catalyst(Blocks.BLUE_ICE).ticks(30L).hidden().save(recipeOutput, "blackstone_catalyst");
        ((ExtractorRecipeBuilder)ExtractorRecipeBuilder.create().output((ItemLike)Blocks.BLACKSTONE)).target(Blocks.BLACKSTONE).catalyst((IRule)FluidTypeRule.lava()).adjacentRule(Blocks.BLUE_ICE).adjacentRule(Blocks.SOUL_SOIL).ticks(30L).hidden().save(recipeOutput, "blackstone_catalyst_0");
        ((ExtractorRecipeBuilder)ExtractorRecipeBuilder.create().output((ItemLike)Blocks.BLACKSTONE)).target(Blocks.BLACKSTONE).adjacentRule((IRule)FluidTypeRule.lava()).adjacentRule(Blocks.BLUE_ICE).catalyst(Blocks.SOUL_SOIL).ticks(30L).hidden().save(recipeOutput, "blackstone_catalyst_1");
        ((ExtractorRecipeBuilder)ExtractorRecipeBuilder.create().output((ItemLike)Blocks.ICE)).target(Blocks.BLUE_ICE).waterLogged().ticks(80L).save(recipeOutput, "ice");
        ((ExtractorRecipeBuilder)ExtractorRecipeBuilder.create().output((ItemLike)Blocks.MYCELIUM)).target((TagKey<Block>)BlockTags.DIRT).adjacentRule((IRule)new BlockTagRule(XyCraftTags.Blocks.MushroomBlock.tag())).adjacentRule((IRule)new BlockTagRule(XyCraftTags.Blocks.MushroomBlock.tag())).adjacentRule((IRule)new BlockTagRule(XyCraftTags.Blocks.MushroomBlock.tag())).adjacentRule((IRule)new BlockTagRule(XyCraftTags.Blocks.MushroomBlock.tag())).ticks(400L).save(recipeOutput, "mycelium");
        ((ExtractorRecipeBuilder)ExtractorRecipeBuilder.create().output((ItemLike)Blocks.MOSS_BLOCK)).target(Blocks.STONE).adjacentRule(Blocks.MOSS_BLOCK).adjacentRule(Blocks.MOSS_BLOCK).adjacentRule(Blocks.MOSS_BLOCK).adjacentRule(Blocks.MOSS_BLOCK).catalyst(Blocks.BONE_BLOCK).ticks(40L).save(recipeOutput, "moss");
        ((ExtractorRecipeBuilder)ExtractorRecipeBuilder.create().output((ItemLike)Blocks.CALCITE)).target(Blocks.BONE_BLOCK).adjacentRule((IRule)FluidTagRule.water()).ticks(60L).save(recipeOutput, "calcite");
        ((ExtractorRecipeBuilder)ExtractorRecipeBuilder.create().output((ItemLike)Blocks.CALCITE)).target(Blocks.BONE_BLOCK).catalyst((IRule)FluidTagRule.water()).ticks(60L).hidden().save(recipeOutput, "calcite_catalyst");
        ((ExtractorRecipeBuilder)ExtractorRecipeBuilder.create().output((ItemLike)Blocks.CALCITE)).target(Blocks.BONE_BLOCK).adjacentRule(MachinesContent.Block.WaterBlock.block()).ticks(60L).hidden().save(recipeOutput, "calcite_wb");
        ((ExtractorRecipeBuilder)ExtractorRecipeBuilder.create().output((ItemLike)Blocks.CALCITE)).target(Blocks.BONE_BLOCK).catalyst(MachinesContent.Block.WaterBlock.block()).ticks(60L).hidden().save(recipeOutput, "calcite_wb_catalyst");
        ((ExtractorRecipeBuilder)ExtractorRecipeBuilder.create().output((ItemLike)Blocks.CALCITE)).target(Blocks.BONE_BLOCK).waterLogged().ticks(60L).hidden().save(recipeOutput, "calcite_water_logged");
        ((ExtractorRecipeBuilder)ExtractorRecipeBuilder.create().output((ItemLike)Items.DRAGON_EGG)).target(Blocks.DRAGON_EGG).ticks(300L).validDirections(EnumSet.of(Direction.UP)).save(recipeOutput, "dragon_egg");
        ((ExtractorRecipeBuilder)ExtractorRecipeBuilder.create().output((ItemLike)Items.DRAGON_BREATH)).target((IRule)new BlockTagRule(XyCraftTags.Blocks.DragonHead.tag())).ticks(200L).save(recipeOutput, "dragon_breath");
        ((ExtractorRecipeBuilder)ExtractorRecipeBuilder.create().output((ItemLike)Items.CHORUS_FRUIT)).target(Blocks.END_STONE).catalyst((IRule)new BlockTagRule(XyCraftTags.Blocks.ChorusFruitStem.tag())).validDirections(EnumSet.of(Direction.UP)).ticks(200L).save(recipeOutput, "chorus_fruit");
        ((ExtractorRecipeBuilder)ExtractorRecipeBuilder.create().output((ItemLike)Blocks.END_STONE)).target(Blocks.END_STONE).catalyst((IRule)new BlockTagRule(XyCraftTags.Blocks.PurpurBlocks.tag())).ticks(30L).save(recipeOutput, "end_stone");
        ExtractorRecipeBuilder.create().output(new FluidStack((Fluid)MachinesContent.Fluid.Resin.Source.get(), 10)).target((TagKey<Block>)BlockTags.LOGS).catalyst((TagKey<Block>)BlockTags.LEAVES).ticks(10L).validDirections(EnumSet.of(Direction.UP)).save(recipeOutput, "resin");
        ExtractorRecipeList.buildCreateExtractorRecipes(recipeOutput);
    }

    private static void makeStoneVariantRecipe(@NotNull RecipeOutput finished, ItemLike stack, IRule target) {
        ExtractorRecipeList.makeStoneVariantRecipe(finished, new ItemStack(stack), target);
    }

    private static void makeStoneVariantRecipe(@NotNull RecipeOutput finished, ItemStack stack, IRule target) {
        String item = Objects.requireNonNull(BuiltInRegistries.ITEM.getKey((Object)stack.getItem())).getPath();
        Block waterBlockTest = MachinesContent.Block.WaterBlock.block();
        ExtractorRecipeBuilder.create().output(stack).target(target).adjacentRule((IRule)FluidTagRule.water()).adjacentRule((IRule)FluidTypeRule.lava()).ticks(30L).save(finished, item);
        ExtractorRecipeBuilder.create().output(stack).target(target).adjacentRule(waterBlockTest).adjacentRule((IRule)FluidTypeRule.lava()).ticks(30L).hidden().save(finished, item + "_waterblock");
        ExtractorRecipeBuilder.create().output(stack).target(target).adjacentRule((IRule)FluidTypeRule.lava()).waterLogged().ticks(30L).hidden().save(finished, item + "_waterlogged");
        ExtractorRecipeBuilder.create().output(stack).target(target).adjacentRule((IRule)FluidTagRule.water()).catalyst((IRule)FluidTypeRule.lava()).ticks(30L).hidden().save(finished, item + "_catalyst");
        ExtractorRecipeBuilder.create().output(stack).target(target).adjacentRule(waterBlockTest).catalyst((IRule)FluidTypeRule.lava()).ticks(30L).hidden().save(finished, item + "_catalyst_waterblock");
        ExtractorRecipeBuilder.create().output(stack).target(target).catalyst((IRule)FluidTagRule.water()).adjacentRule((IRule)FluidTypeRule.lava()).ticks(30L).hidden().save(finished, item + "_catalyst_0");
        ExtractorRecipeBuilder.create().output(stack).target(target).catalyst(waterBlockTest).adjacentRule((IRule)FluidTypeRule.lava()).ticks(30L).hidden().save(finished, item + "_catalyst_0_waterblock");
        ExtractorRecipeBuilder.create().output(stack).target(target).waterLogged().catalyst((IRule)FluidTypeRule.lava()).ticks(30L).hidden().save(finished, item + "_waterlogged_catalyst");
    }

    private static void buildCreateExtractorRecipes(@NotNull RecipeOutput finished) {
    }

    private static void fluidVariantRecipe(@NotNull RecipeOutput finished, ItemLike stack, IRule target, IRule a, IRule b) {
        String item = Objects.requireNonNull(BuiltInRegistries.ITEM.getKey((Object)stack.asItem())).getPath();
        RecipeOutput finishedWithConditions = finished.withConditions(new ICondition[]{new ModLoadedCondition(CompatContent.Create.Mod.modId())});
        ((ExtractorRecipeBuilder)ExtractorRecipeBuilder.create().output(stack)).target(target).adjacentRule(a).adjacentRule(b).ticks(30L).save(finishedWithConditions, item);
        ((ExtractorRecipeBuilder)ExtractorRecipeBuilder.create().output(stack)).target(target).adjacentRule(a).catalyst(b).ticks(30L).save(finishedWithConditions, "%s_catalyst".formatted(item));
        ((ExtractorRecipeBuilder)ExtractorRecipeBuilder.create().output(stack)).target(target).catalyst(a).adjacentRule(b).ticks(30L).save(finishedWithConditions, "%s_catalyst_0".formatted(item));
    }
}

