/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.mixins;

import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import tv.soaryn.xycraft.machines.content.blocks.pipe.QuickRemoveEvents;

@Mixin(value={Block.class})
public class PlayerDestroyBlockMixin {
    @Inject(method={"spawnDestroyParticles"}, at={@At(value="HEAD")}, cancellable=true)
    public void xycraft$destroy(Level level, Player player, BlockPos pos, BlockState state, CallbackInfo ci) {
        if (!QuickRemoveEvents.isMineable(state) || !QuickRemoveEvents.isUsingQuickRemover(player)) {
            return;
        }
        if (!state.isAir()) {
            level.addDestroyBlockEffect(pos, state);
            if (!level.isClientSide()) {
                level.playSound(null, pos, SoundEvents.ITEM_PICKUP, SoundSource.PLAYERS, 0.7f, 1.0f);
            }
        }
        ci.cancel();
    }
}

