/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.network;

import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import tv.soaryn.xycraft.core.network.Packet;
import tv.soaryn.xycraft.core.utils.serialization.BinarySerializer;
import tv.soaryn.xycraft.core.utils.serialization.Serializer;
import tv.soaryn.xycraft.machines.network.TerrainParticleClient;

public record CBHardenBlockPacket(BlockPos pos, BlockState state) implements Packet.ClientBound
{
    public static final BinarySerializer<CBHardenBlockPacket> SerDes = BinarySerializer.ofType(CBHardenBlockPacket::new, CBHardenBlockPacket::pos, (BinarySerializer)Serializer.BLOCK_POS, CBHardenBlockPacket::state, (BinarySerializer)Serializer.BLOCK_STATE);
    static final VoxelShape _full = Shapes.box((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)1.0);

    public void handle(Packet.ClientBound.Context context) {
        context.enqueueMainThread(() -> {
            BlockPos pos = this.pos();
            BlockState state = this.state();
            ClientLevel level = Minecraft.getInstance().level;
            if (level == null) {
                return;
            }
            ParticleEngine particleEngine = Minecraft.getInstance().particleEngine;
            VoxelShape voxelshape = state.getShape((BlockGetter)level, pos);
            if (voxelshape.isEmpty()) {
                voxelshape = _full;
            }
            voxelshape.forAllBoxes((minX, minY, minZ, maxX, maxY, maxZ) -> {
                double d1 = Math.min(1.0, maxX - minX);
                double d2 = Math.min(1.0, maxY - minY);
                double d3 = Math.min(1.0, maxZ - minZ);
                double i = Math.max(2.0, (double)Mth.ceil((double)(d1 / 0.25)));
                double j = Math.max(2.0, (double)Mth.ceil((double)(d2 / 0.25)));
                double k = Math.max(2.0, (double)Mth.ceil((double)(d3 / 0.25)));
                int x = 0;
                while ((double)x < i) {
                    int y = 0;
                    while ((double)y < j) {
                        int z = 0;
                        while ((double)z < k) {
                            double d4 = ((double)x + 0.5) / i;
                            double d5 = ((double)y + 0.5) / j;
                            double d6 = ((double)z + 0.5) / k;
                            double d7 = d4 * d1 + minX;
                            double d8 = d5 * d2 + minY;
                            double d9 = d6 * d3 + minZ;
                            TerrainParticleClient.createParticle(particleEngine, level, pos, d7, d8, d9, d4, d5, d6, state);
                            ++z;
                        }
                        ++y;
                    }
                    ++x;
                }
            });
        });
    }
}

