/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.net;

import dev.architectury.hooks.item.ItemStackHooks;
import dev.architectury.networking.NetworkManager;
import dev.ftb.mods.ftbquests.api.FTBQuestsAPI;
import dev.ftb.mods.ftbquests.quest.ServerQuestFile;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.util.UUID;
import net.minecraft.Util;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;

public record GetEmergencyItemsMessage() implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<GetEmergencyItemsMessage> TYPE = new CustomPacketPayload.Type(FTBQuestsAPI.rl("get_emergency_items_message"));
    public static final GetEmergencyItemsMessage INSTANCE = new GetEmergencyItemsMessage();
    public static final StreamCodec<FriendlyByteBuf, GetEmergencyItemsMessage> STREAM_CODEC = StreamCodec.unit((Object)INSTANCE);
    private static final Object2LongMap<UUID> lastItemsGot = new Object2LongOpenHashMap();

    public CustomPacketPayload.Type<GetEmergencyItemsMessage> type() {
        return TYPE;
    }

    public static void handle(GetEmergencyItemsMessage message, NetworkManager.PacketContext context) {
        context.queue(() -> {
            ServerPlayer player = (ServerPlayer)context.getPlayer();
            long now = Util.getEpochMillis();
            long delta = now - lastItemsGot.getOrDefault((Object)player.getUUID(), 0L);
            if (delta >= (long)ServerQuestFile.INSTANCE.getEmergencyItemsCooldown() * 1000L) {
                ServerQuestFile.INSTANCE.getEmergencyItems().forEach(stack -> ItemStackHooks.giveItem((ServerPlayer)player, (ItemStack)stack.copy()));
                lastItemsGot.put((Object)player.getUUID(), now);
            }
        });
    }
}

