/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.quest.task;

import com.mojang.datafixers.util.Either;
import dev.architectury.networking.NetworkManager;
import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.NameMap;
import dev.ftb.mods.ftbquests.net.SyncStructuresRequestMessage;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.quest.task.AbstractBooleanTask;
import dev.ftb.mods.ftbquests.quest.task.TaskType;
import dev.ftb.mods.ftbquests.quest.task.TaskTypes;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class StructureTask
extends AbstractBooleanTask {
    private static final ResourceLocation DEFAULT_STRUCTURE = ResourceLocation.withDefaultNamespace((String)"mineshaft");
    private static final List<String> KNOWN_STRUCTURES = new ArrayList<String>();
    private Either<ResourceKey<Structure>, TagKey<Structure>> structure = Either.left((Object)ResourceKey.create((ResourceKey)Registries.STRUCTURE, (ResourceLocation)DEFAULT_STRUCTURE));

    public StructureTask(long id, Quest quest) {
        super(id, quest);
    }

    public static void syncKnownStructureList(List<String> data) {
        KNOWN_STRUCTURES.clear();
        KNOWN_STRUCTURES.addAll(data);
    }

    @Override
    public TaskType getType() {
        return TaskTypes.STRUCTURE;
    }

    @Override
    public void writeData(CompoundTag nbt, HolderLookup.Provider provider) {
        super.writeData(nbt, provider);
        nbt.putString("structure", this.getStructure());
    }

    @Override
    public void readData(CompoundTag nbt, HolderLookup.Provider provider) {
        super.readData(nbt, provider);
        this.setStructure(nbt.getString("structure"));
    }

    @Override
    public void writeNetData(RegistryFriendlyByteBuf buffer) {
        super.writeNetData(buffer);
        buffer.writeUtf(this.getStructure());
    }

    @Override
    public void readNetData(RegistryFriendlyByteBuf buffer) {
        super.readNetData(buffer);
        this.setStructure(buffer.readUtf(1024));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void fillConfigGroup(ConfigGroup config) {
        super.fillConfigGroup(config);
        if (KNOWN_STRUCTURES.isEmpty()) {
            config.addString("structure", this.getStructure(), this::setStructure, "minecraft:mineshaft");
        } else {
            config.addEnum("structure", (Object)this.getStructure(), this::setStructure, NameMap.of((Object)DEFAULT_STRUCTURE.toString(), KNOWN_STRUCTURES).create());
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public MutableComponent getAltTitle() {
        return Component.translatable((String)"ftbquests.task.ftbquests.structure").append(": ").append((Component)Component.literal((String)this.getStructure()).withStyle(ChatFormatting.DARK_GREEN));
    }

    @Override
    public int autoSubmitOnPlayerTick() {
        return 20;
    }

    @Override
    public boolean checkOnLogin() {
        return false;
    }

    @Override
    public boolean canSubmit(TeamData teamData, ServerPlayer player) {
        if (player.isSpectator()) {
            return false;
        }
        ServerLevel level = (ServerLevel)player.level();
        StructureManager mgr = level.structureManager();
        return (Boolean)this.structure.map(key -> {
            Structure structure = (Structure)mgr.registryAccess().registryOrThrow(Registries.STRUCTURE).get(key);
            return structure != null && mgr.getStructureWithPieceAt(player.blockPosition(), structure).isValid();
        }, tag -> mgr.getStructureWithPieceAt(player.blockPosition(), tag).isValid());
    }

    private void setStructure(String resLoc) {
        this.structure = resLoc.startsWith("#") ? Either.right((Object)TagKey.create((ResourceKey)Registries.STRUCTURE, (ResourceLocation)this.safeResourceLocation(resLoc.substring(1), DEFAULT_STRUCTURE))) : Either.left((Object)ResourceKey.create((ResourceKey)Registries.STRUCTURE, (ResourceLocation)this.safeResourceLocation(resLoc, DEFAULT_STRUCTURE)));
    }

    private String getStructure() {
        return (String)this.structure.map(key -> key.location().toString(), tag -> "#" + String.valueOf(tag.location()));
    }

    public static void maybeRequestStructureSync() {
        if (KNOWN_STRUCTURES.isEmpty()) {
            NetworkManager.sendToServer((CustomPacketPayload)SyncStructuresRequestMessage.INSTANCE);
        }
    }
}

