/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createdragonsplus.common.kinetics.fan.coloring;

import com.simibubi.create.content.kinetics.fan.processing.FanProcessingType;
import com.simibubi.create.content.processing.recipe.ProcessingRecipe;
import com.simibubi.create.foundation.item.ItemHelper;
import com.simibubi.create.foundation.recipe.RecipeApplier;
import com.simibubi.create.infrastructure.config.AllConfigs;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.createmod.catnip.theme.Color;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.monster.Shulker;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.registries.DeferredHolder;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import plus.dragons.createdragonsplus.common.kinetics.fan.coloring.ColoringRecipe;
import plus.dragons.createdragonsplus.common.kinetics.fan.coloring.ColoringRecipeInput;
import plus.dragons.createdragonsplus.common.registry.CDPDataMaps;
import plus.dragons.createdragonsplus.common.registry.CDPRecipes;
import plus.dragons.createdragonsplus.config.CDPConfig;
import plus.dragons.createdragonsplus.integration.ModIntegration;
import plus.dragons.createdragonsplus.util.PersistentDataHelper;

public class ColoringFanProcessingType
implements FanProcessingType {
    private final DyeColor color;
    private final Vector3f rgb;
    private final DeferredHolder<RecipeType<?>, RecipeType<ProcessingRecipe<SingleRecipeInput, ?>>> createGarnishedRecipe;

    public ColoringFanProcessingType(DyeColor color) {
        this.color = color;
        this.rgb = new Color(this.color.getTextureDiffuseColor()).asVectorF();
        this.createGarnishedRecipe = DeferredHolder.create((ResourceKey)Registries.RECIPE_TYPE, (ResourceLocation)ModIntegration.CREATE_GARNISHED.asResource(color.getSerializedName() + "_dye_blowing"));
    }

    public boolean isValidAt(Level level, BlockPos pos) {
        if (!((Boolean)CDPConfig.recipes().enableBulkColoring.get()).booleanValue()) {
            return false;
        }
        if (level.getFluidState(pos).holder().getData(CDPDataMaps.FLUID_FAN_COLORING_CATALYSTS) == this.color) {
            return true;
        }
        return level.getBlockState(pos).getBlockHolder().getData(CDPDataMaps.BLOCK_FAN_COLORING_CATALYSTS) == this.color;
    }

    public int getPriority() {
        return 500;
    }

    public boolean canProcess(ItemStack stack, Level level) {
        Optional recipe = level.getRecipeManager().getRecipeFor(CDPRecipes.COLORING.getType(), (RecipeInput)new ColoringRecipeInput(this.color, stack), level);
        if (recipe.isPresent()) {
            return true;
        }
        if (this.canProcessByCreateGarnished(stack, level)) {
            return true;
        }
        return this.processByCrafting(stack, level).isPresent();
    }

    @Nullable
    public List<ItemStack> process(ItemStack stack, Level level) {
        return level.getRecipeManager().getRecipeFor(CDPRecipes.COLORING.getType(), (RecipeInput)new ColoringRecipeInput(this.color, stack), level).map(recipe -> RecipeApplier.applyRecipeOn((Level)level, (ItemStack)stack, (RecipeHolder)recipe)).or(() -> this.processByCreateGarnished(stack, level)).or(() -> this.processByCrafting(stack, level).map(result -> ItemHelper.multipliedOutput((ItemStack)stack, (ItemStack)result))).orElse(null);
    }

    public void spawnProcessingParticles(Level level, Vec3 pos) {
        if (level.random.nextInt(8) == 0) {
            level.addParticle((ParticleOptions)new DustParticleOptions(this.rgb, 2.0f), pos.x + (double)((level.random.nextFloat() - 0.5f) * 0.5f), pos.y + 0.5, pos.z + (double)((level.random.nextFloat() - 0.5f) * 0.5f), 0.0, 0.125, 0.0);
        }
    }

    public void morphAirFlow(FanProcessingType.AirFlowParticleAccess particleAccess, RandomSource random) {
        particleAccess.setColor(this.color.getTextureDiffuseColor());
        particleAccess.setAlpha(1.0f);
    }

    public void affectEntity(Entity entity, Level level) {
        if (level.isClientSide) {
            return;
        }
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            this.applyColoring(livingEntity, level);
        }
        if (entity instanceof EnderMan || entity.getType() == EntityType.SNOW_GOLEM || entity.getType() == EntityType.BLAZE) {
            entity.hurt(entity.damageSources().drown(), 2.0f);
        }
        if (entity.isOnFire()) {
            entity.clearFire();
            level.playSound(null, entity.blockPosition(), SoundEvents.GENERIC_EXTINGUISH_FIRE, SoundSource.NEUTRAL, 0.7f, 1.6f + (level.random.nextFloat() - level.random.nextFloat()) * 0.4f);
        }
    }

    private boolean canProcessByCreateGarnished(ItemStack stack, Level level) {
        if (!this.createGarnishedRecipe.isBound()) {
            return false;
        }
        return level.getRecipeManager().getRecipeFor((RecipeType)this.createGarnishedRecipe.get(), (RecipeInput)new SingleRecipeInput(stack), level).isPresent();
    }

    private Optional<List<ItemStack>> processByCreateGarnished(ItemStack stack, Level level) {
        if (!this.createGarnishedRecipe.isBound()) {
            return Optional.empty();
        }
        return level.getRecipeManager().getRecipeFor((RecipeType)this.createGarnishedRecipe.get(), (RecipeInput)new SingleRecipeInput(stack), level).map(recipe -> RecipeApplier.applyRecipeOn((Level)level, (ItemStack)stack, (RecipeHolder)recipe));
    }

    private Optional<ItemStack> processByCrafting(ItemStack stack, Level level) {
        CraftingInput input = CraftingInput.of((int)2, (int)1, List.of(stack, new ItemStack((ItemLike)DyeItem.byColor((DyeColor)this.color))));
        Optional optional = level.getRecipeManager().getRecipeFor(RecipeType.CRAFTING, (RecipeInput)input, level);
        if (optional.isPresent()) {
            CraftingRecipe recipe = (CraftingRecipe)((RecipeHolder)optional.get()).value();
            ItemStack result = recipe.assemble((RecipeInput)input, (HolderLookup.Provider)level.registryAccess());
            return result.getCount() == 1 ? Optional.of(result) : Optional.empty();
        }
        NonNullList items = NonNullList.withSize((int)9, (Object)stack);
        items.set(4, (Object)new ItemStack((ItemLike)DyeItem.byColor((DyeColor)this.color)));
        input = CraftingInput.of((int)3, (int)3, (List)items);
        optional = level.getRecipeManager().getRecipeFor(RecipeType.CRAFTING, (RecipeInput)input, level);
        if (optional.isPresent()) {
            CraftingRecipe recipe = (CraftingRecipe)((RecipeHolder)optional.get()).value();
            ItemStack result = recipe.assemble((RecipeInput)input, (HolderLookup.Provider)level.registryAccess());
            if (result.getCount() != 8) {
                return Optional.empty();
            }
            result.setCount(1);
            return Optional.of(result);
        }
        return Optional.empty();
    }

    public void applyColoring(LivingEntity entity, Level level) {
        if (this.processColoring((LivingEntity)entity)) {
            Objects.requireNonNull(entity);
            EquipmentSlot[] equipmentSlotArray = entity;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Sheep.class, Shulker.class, Cat.class, Wolf.class}, (Object)equipmentSlotArray, n)) {
                case 0: {
                    Sheep sheep = (Sheep)equipmentSlotArray;
                    sheep.setColor(this.color);
                    break;
                }
                case 1: {
                    Shulker shulker = (Shulker)equipmentSlotArray;
                    shulker.setVariant(Optional.of(this.color));
                    break;
                }
                case 2: {
                    Cat cat = (Cat)equipmentSlotArray;
                    cat.setCollarColor(this.color);
                    break;
                }
                case 3: {
                    Wolf wolf = (Wolf)equipmentSlotArray;
                    wolf.setCollarColor(this.color);
                    break;
                }
            }
            for (EquipmentSlot slot : EquipmentSlot.values()) {
                ItemStack stack = entity.getItemBySlot(slot);
                if (stack.isEmpty()) continue;
                this.applyColoring(stack, level).ifPresent(arg_0 -> ColoringFanProcessingType.lambda$applyColoring$5(stack, (LivingEntity)entity, slot, arg_0));
            }
        }
    }

    private boolean processColoring(LivingEntity entity) {
        CompoundTag nbt = PersistentDataHelper.getOrCreate(entity.getPersistentData(), "CreateDragonsPlusData", "Coloring");
        int sinceLastProcess = 0;
        if (!nbt.contains("Color", 8) || !nbt.getString("Color").equals(this.color.getName())) {
            nbt.putString("Color", this.color.getName());
            nbt.remove("Time");
        } else if (nbt.contains("LastProcess", 3)) {
            int lastProcess = nbt.getInt("LastProcess");
            sinceLastProcess = entity.tickCount - lastProcess - 1;
        }
        nbt.putInt("LastProcess", entity.tickCount);
        int processingTime = (Integer)AllConfigs.server().kinetics.fanProcessingTime.get();
        if (!nbt.contains("Time", 3) || sinceLastProcess < 0) {
            nbt.putInt("Time", processingTime);
            return false;
        }
        int time = nbt.getInt("Time") + sinceLastProcess;
        if (time == 0) {
            nbt.remove("Color");
            nbt.remove("LastProcess");
            nbt.remove("Time");
            return true;
        }
        nbt.putInt("Time", Math.min(processingTime, time - 1));
        return false;
    }

    private Optional<ItemStack> applyColoring(ItemStack stack, Level level) {
        ColoringRecipeInput coloringInput = new ColoringRecipeInput(this.color, stack);
        Optional coloringRecipe = level.getRecipeManager().getRecipeFor(CDPRecipes.COLORING.getType(), (RecipeInput)coloringInput, level);
        if (coloringRecipe.isPresent()) {
            ItemStack result = ((ColoringRecipe)((RecipeHolder)coloringRecipe.get()).value()).assemble(coloringInput, (HolderLookup.Provider)level.registryAccess());
            return Optional.of(result);
        }
        return this.processByCrafting(stack, level);
    }

    private static /* synthetic */ void lambda$applyColoring$5(ItemStack stack, LivingEntity entity, EquipmentSlot slot, ItemStack it) {
        it.setCount(stack.getCount());
        entity.setItemSlot(slot, it);
    }
}

