/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createdragonsplus.common.kinetics.fan.ending;

import com.simibubi.create.content.kinetics.fan.processing.FanProcessingType;
import com.simibubi.create.foundation.recipe.RecipeApplier;
import java.util.List;
import net.createmod.catnip.theme.Color;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import plus.dragons.createdragonsplus.common.registry.CDPBlocks;
import plus.dragons.createdragonsplus.common.registry.CDPFluids;
import plus.dragons.createdragonsplus.common.registry.CDPRecipes;
import plus.dragons.createdragonsplus.config.CDPConfig;

public class EndingFanProcessingType
implements FanProcessingType {
    public boolean isValidAt(Level level, BlockPos pos) {
        if (!((Boolean)CDPConfig.recipes().enableBulkEnding.get()).booleanValue()) {
            return false;
        }
        FluidState fluidState = level.getFluidState(pos);
        if (fluidState.is(CDPFluids.MOD_TAGS.fanEndingCatalysts)) {
            return true;
        }
        BlockState state = level.getBlockState(pos);
        return state.is(CDPBlocks.MOD_TAGS.fanEndingCatalysts);
    }

    public int getPriority() {
        return 350;
    }

    public boolean canProcess(ItemStack stack, Level level) {
        RecipeManager recipeManager = level.getRecipeManager();
        SingleRecipeInput input = new SingleRecipeInput(stack);
        return recipeManager.getRecipeFor(CDPRecipes.ENDING.getType(), (RecipeInput)input, level).isPresent();
    }

    @Nullable
    public List<ItemStack> process(ItemStack stack, Level level) {
        RecipeManager recipeManager = level.getRecipeManager();
        SingleRecipeInput input = new SingleRecipeInput(stack);
        return recipeManager.getRecipeFor(CDPRecipes.ENDING.getType(), (RecipeInput)input, level).map(recipe -> RecipeApplier.applyRecipeOn((Level)level, (ItemStack)stack, (RecipeHolder)recipe)).orElse(null);
    }

    public void spawnProcessingParticles(Level level, Vec3 pos) {
        if (level.random.nextInt(8) == 0) {
            level.addParticle((ParticleOptions)ParticleTypes.DRAGON_BREATH, pos.x + (double)((level.random.nextFloat() - 0.5f) * 0.5f), pos.y + 0.5, pos.z + (double)((level.random.nextFloat() - 0.5f) * 0.5f), 0.0, 0.125, 0.0);
        }
    }

    public void morphAirFlow(FanProcessingType.AirFlowParticleAccess particleAccess, RandomSource random) {
        particleAccess.setColor(Color.mixColors((int)11993298, (int)14614777, (float)random.nextFloat()));
        particleAccess.setAlpha(1.0f);
        if (random.nextFloat() < 0.03125f) {
            particleAccess.spawnExtraParticle((ParticleOptions)ParticleTypes.DRAGON_BREATH, 0.0f);
        }
    }

    public void affectEntity(Entity entity, Level level) {
        LivingEntity livingEntity;
        if (level.isClientSide) {
            return;
        }
        if (entity instanceof LivingEntity && (livingEntity = (LivingEntity)entity).isAffectedByPotions() && entity.tickCount % 5 == 0) {
            livingEntity.addEffect(new MobEffectInstance(MobEffects.HARM, 1, 1));
        }
    }
}

