/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createdragonsplus.data.internal;

import net.createmod.catnip.lang.LangBuilder;
import net.createmod.catnip.lang.LangNumberFormat;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class CDPLang {
    public static LangBuilder builder() {
        return new LangBuilder("create_dragons_plus");
    }

    public static LangBuilder number(double d) {
        return CDPLang.builder().text(LangNumberFormat.format((double)d));
    }

    public static LangBuilder text(String text) {
        return CDPLang.builder().text(text);
    }

    public static LangBuilder translate(String key, Object ... args) {
        return CDPLang.builder().translate(key, args);
    }

    public static LangBuilder description(String category, ResourceLocation location, Object ... args) {
        return CDPLang.builder().add(Component.translatable((String)Util.makeDescriptionId((String)category, (ResourceLocation)location), (Object[])args));
    }

    public static LangBuilder description(String category, ResourceLocation location, String suffix, Object ... args) {
        return CDPLang.builder().add(Component.translatable((String)(Util.makeDescriptionId((String)category, (ResourceLocation)location) + "." + suffix), (Object[])args));
    }

    public static LangBuilder description(Holder<?> holder, Object ... args) {
        ResourceKey key = holder.getKey();
        if (key == null) {
            throw new IllegalArgumentException("Can not build description for unregistered object: " + String.valueOf(holder));
        }
        return CDPLang.description(key.registry().getPath(), key.location(), args);
    }

    public static LangBuilder description(Holder<?> holder, String suffix, Object ... args) {
        ResourceKey key = holder.getKey();
        if (key == null) {
            throw new IllegalArgumentException("Can not build description for unregistered object: " + String.valueOf(holder));
        }
        return CDPLang.description(key.registry().getPath(), key.location(), suffix, args);
    }

    public static LangBuilder block(BlockState state) {
        return CDPLang.builder().add(state.getBlock().getName());
    }

    public static LangBuilder item(ItemStack stack) {
        return CDPLang.builder().add(stack.getHoverName().copy());
    }

    public static LangBuilder fluid(FluidStack stack) {
        return CDPLang.builder().add(stack.getHoverName().copy());
    }
}

