/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createdragonsplus.util;

import com.google.common.base.Preconditions;
import java.util.Optional;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.ShortTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;

public class PersistentDataHelper {
    private static final String EXCEPTION_EMPTY_PATH = "Path must not be empty";

    public static CompoundTag getOrCreate(CompoundTag nbt, String ... path) {
        Preconditions.checkArgument((path.length > 0 ? 1 : 0) != 0, (Object)EXCEPTION_EMPTY_PATH);
        if (path.length == 1) {
            String key = path[path.length - 1];
            if (!nbt.contains(key, 10)) {
                nbt.put(key, (Tag)new CompoundTag());
            }
            return nbt.getCompound(key);
        }
        for (String key : path) {
            if (!nbt.contains(key, 10)) {
                nbt.put(key, (Tag)new CompoundTag());
            }
            nbt = nbt.getCompound(key);
        }
        return nbt;
    }

    public static ListTag getOrCreateList(CompoundTag nbt, int type, String ... path) {
        ListTag list;
        Preconditions.checkArgument((path.length > 0 ? 1 : 0) != 0, (Object)EXCEPTION_EMPTY_PATH);
        String key = path[path.length - 1];
        if (path.length > 1) {
            nbt = PersistentDataHelper.getParent(nbt, path);
        }
        if ((list = (ListTag)nbt.get(key)) == null || !list.isEmpty() && list.getElementType() != type) {
            list = new ListTag();
            nbt.put(key, (Tag)list);
        }
        return list;
    }

    public static void put(CompoundTag nbt, Tag value, String ... path) {
        Preconditions.checkArgument((path.length > 0 ? 1 : 0) != 0, (Object)EXCEPTION_EMPTY_PATH);
        if (path.length == 1) {
            nbt.put(path[0], value);
            return;
        }
        int lastIndex = path.length - 1;
        for (int index = 0; index < lastIndex; ++index) {
            String key = path[index];
            if (!nbt.contains(key, 10)) {
                nbt.put(key, (Tag)new CompoundTag());
            }
            nbt = nbt.getCompound(key);
        }
        nbt.put(path[path.length - 1], value);
    }

    private static CompoundTag getParent(CompoundTag nbt, String ... path) {
        int lastIndex = path.length - 1;
        for (int index = 0; index < lastIndex; ++index) {
            String key = path[index];
            if (!nbt.contains(key, 10)) {
                nbt.put(key, (Tag)new CompoundTag());
            }
            nbt = nbt.getCompound(key);
        }
        return nbt;
    }

    public static byte getByte(CompoundTag nbt, String ... path) {
        Preconditions.checkArgument((path.length > 0 ? 1 : 0) != 0, (Object)EXCEPTION_EMPTY_PATH);
        if (path.length == 1) {
            return nbt.getByte(path[0]);
        }
        return PersistentDataHelper.getParent(nbt, path).getByte(path[path.length - 1]);
    }

    public static void putByte(CompoundTag nbt, byte value, String ... path) {
        PersistentDataHelper.put(nbt, (Tag)ByteTag.valueOf((byte)value), path);
    }

    public static byte addByte(CompoundTag nbt, byte value, String ... path) {
        Preconditions.checkArgument((path.length > 0 ? 1 : 0) != 0, (Object)EXCEPTION_EMPTY_PATH);
        String key = path[path.length - 1];
        if (path.length > 1) {
            nbt = PersistentDataHelper.getParent(nbt, path);
        }
        value = (byte)(nbt.getByte(key) + value);
        nbt.putByte(key, value);
        return value;
    }

    public static short getShort(CompoundTag nbt, String ... path) {
        Preconditions.checkArgument((path.length > 0 ? 1 : 0) != 0, (Object)EXCEPTION_EMPTY_PATH);
        if (path.length == 1) {
            return nbt.getShort(path[0]);
        }
        return PersistentDataHelper.getParent(nbt, path).getShort(path[path.length - 1]);
    }

    public static void putShort(CompoundTag nbt, short value, String ... path) {
        PersistentDataHelper.put(nbt, (Tag)ShortTag.valueOf((short)value), path);
    }

    public static short addShort(CompoundTag nbt, short value, String ... path) {
        Preconditions.checkArgument((path.length > 0 ? 1 : 0) != 0, (Object)EXCEPTION_EMPTY_PATH);
        String key = path[path.length - 1];
        if (path.length > 1) {
            nbt = PersistentDataHelper.getParent(nbt, path);
        }
        value = (short)(value + nbt.getShort(key));
        nbt.putShort(key, value);
        return value;
    }

    public static int getInt(CompoundTag nbt, String ... path) {
        Preconditions.checkArgument((path.length > 0 ? 1 : 0) != 0, (Object)EXCEPTION_EMPTY_PATH);
        if (path.length == 1) {
            return nbt.getInt(path[0]);
        }
        return PersistentDataHelper.getParent(nbt, path).getInt(path[path.length - 1]);
    }

    public static void putInt(CompoundTag nbt, int value, String ... path) {
        PersistentDataHelper.put(nbt, (Tag)IntTag.valueOf((int)value), path);
    }

    public static int addInt(CompoundTag nbt, int value, String ... path) {
        Preconditions.checkArgument((path.length > 0 ? 1 : 0) != 0, (Object)EXCEPTION_EMPTY_PATH);
        String key = path[path.length - 1];
        if (path.length > 1) {
            nbt = PersistentDataHelper.getParent(nbt, path);
        }
        nbt.putInt(key, value += nbt.getInt(key));
        return value;
    }

    public static long getLong(CompoundTag nbt, String ... path) {
        Preconditions.checkArgument((path.length > 0 ? 1 : 0) != 0, (Object)EXCEPTION_EMPTY_PATH);
        if (path.length == 1) {
            return nbt.getLong(path[0]);
        }
        return PersistentDataHelper.getParent(nbt, path).getLong(path[path.length - 1]);
    }

    public static void putLong(CompoundTag nbt, long value, String ... path) {
        PersistentDataHelper.put(nbt, (Tag)LongTag.valueOf((long)value), path);
    }

    public static long addLong(CompoundTag nbt, long value, String ... path) {
        Preconditions.checkArgument((path.length > 0 ? 1 : 0) != 0, (Object)EXCEPTION_EMPTY_PATH);
        String key = path[path.length - 1];
        if (path.length > 1) {
            nbt = PersistentDataHelper.getParent(nbt, path);
        }
        nbt.putLong(key, value += nbt.getLong(key));
        return value;
    }

    public static float getFloat(CompoundTag nbt, String ... path) {
        Preconditions.checkArgument((path.length > 0 ? 1 : 0) != 0, (Object)EXCEPTION_EMPTY_PATH);
        if (path.length == 1) {
            return nbt.getFloat(path[0]);
        }
        return PersistentDataHelper.getParent(nbt, path).getFloat(path[path.length - 1]);
    }

    public static void putFloat(CompoundTag nbt, float value, String ... path) {
        PersistentDataHelper.put(nbt, (Tag)FloatTag.valueOf((float)value), path);
    }

    public static float addFloat(CompoundTag nbt, float value, String ... path) {
        Preconditions.checkArgument((path.length > 0 ? 1 : 0) != 0, (Object)EXCEPTION_EMPTY_PATH);
        String key = path[path.length - 1];
        if (path.length > 1) {
            nbt = PersistentDataHelper.getParent(nbt, path);
        }
        nbt.putFloat(key, value += nbt.getFloat(key));
        return value;
    }

    public static double getDouble(CompoundTag nbt, String ... path) {
        Preconditions.checkArgument((path.length > 0 ? 1 : 0) != 0, (Object)EXCEPTION_EMPTY_PATH);
        if (path.length == 1) {
            return nbt.getDouble(path[0]);
        }
        return PersistentDataHelper.getParent(nbt, path).getDouble(path[path.length - 1]);
    }

    public static void putDouble(CompoundTag nbt, double value, String ... path) {
        PersistentDataHelper.put(nbt, (Tag)DoubleTag.valueOf((double)value), path);
    }

    public static double addDouble(CompoundTag nbt, double value, String ... path) {
        Preconditions.checkArgument((path.length > 0 ? 1 : 0) != 0, (Object)EXCEPTION_EMPTY_PATH);
        String key = path[path.length - 1];
        if (path.length > 1) {
            nbt = PersistentDataHelper.getParent(nbt, path);
        }
        nbt.putDouble(key, value += nbt.getDouble(key));
        return value;
    }

    public static String getString(CompoundTag nbt, String ... path) {
        Preconditions.checkArgument((path.length > 0 ? 1 : 0) != 0, (Object)EXCEPTION_EMPTY_PATH);
        if (path.length == 1) {
            return nbt.getString(path[0]);
        }
        return PersistentDataHelper.getParent(nbt, path).getString(path[path.length - 1]);
    }

    public static Optional<String> getOptionalString(CompoundTag nbt, String ... path) {
        Preconditions.checkArgument((path.length > 0 ? 1 : 0) != 0, (Object)EXCEPTION_EMPTY_PATH);
        String key = path[path.length - 1];
        if (path.length > 1) {
            nbt = PersistentDataHelper.getParent(nbt, path);
        }
        if (nbt.contains(key, 8)) {
            return Optional.of(nbt.get(key).getAsString());
        }
        return Optional.empty();
    }

    public static void putString(CompoundTag nbt, String value, String ... path) {
        PersistentDataHelper.put(nbt, (Tag)StringTag.valueOf((String)value), path);
    }
}

