/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.amendments.client;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import net.mehvahdjukaar.amendments.Amendments;
import net.mehvahdjukaar.amendments.common.block.WallLanternBlock;
import net.mehvahdjukaar.amendments.integration.CompatHandler;
import net.mehvahdjukaar.amendments.integration.FarmersDelightCompat;
import net.mehvahdjukaar.amendments.integration.SuppCompat;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.TorchBlock;
import net.minecraft.world.level.block.WallTorchBlock;
import org.jetbrains.annotations.NotNull;

public class BlockScanner {
    private static BlockScanner INSTANCE = null;
    private final Set<Block> lanterns;
    private final Set<Block> torches;
    private final Set<Block> candleHolders;
    private final Set<Block> fdSigns;

    public static BlockScanner getInstance() {
        if (INSTANCE == null) {
            Amendments.LOGGER.debug("Scanning blocks for Amendments");
            INSTANCE = new BlockScanner();
        }
        return INSTANCE;
    }

    private BlockScanner() {
        ImmutableSet.Builder lanternBuilder = ImmutableSet.builder();
        ImmutableSet.Builder torchesBuilder = ImmutableSet.builder();
        ImmutableSet.Builder candleBuilder = ImmutableSet.builder();
        ImmutableSet.Builder fdSignsBuilder = ImmutableSet.builder();
        for (Block block : BuiltInRegistries.BLOCK) {
            if (WallLanternBlock.isValidBlock(block)) {
                lanternBuilder.add((Object)block);
                continue;
            }
            if (block instanceof TorchBlock && !(block instanceof WallTorchBlock) || CompatHandler.SUPPLEMENTARIES && SuppCompat.isSconce(block)) {
                torchesBuilder.add((Object)block);
                continue;
            }
            if (CompatHandler.SUPPLEMENTARIES && SuppCompat.isCandleHolder(block)) {
                candleBuilder.add((Object)block);
                continue;
            }
            if (!CompatHandler.FARMERS_DELIGHT || !FarmersDelightCompat.isStandingSign(block)) continue;
            fdSignsBuilder.add((Object)block);
        }
        torchesBuilder.add((Object)Blocks.REDSTONE_TORCH);
        this.lanterns = lanternBuilder.build();
        this.torches = torchesBuilder.build();
        this.candleHolders = candleBuilder.build();
        this.fdSigns = fdSignsBuilder.build();
    }

    @NotNull
    public Set<Block> getLanterns() {
        return this.lanterns;
    }

    @NotNull
    public Set<Block> getTorches() {
        return this.torches;
    }

    @NotNull
    public Set<Block> getCandleHolders() {
        return this.candleHolders;
    }

    public Set<Block> getFdSigns() {
        return this.fdSigns;
    }
}

