/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.client.screen.description.research.widgets;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import it.hurts.sskirillss.relics.client.screen.base.ITickingWidget;
import it.hurts.sskirillss.relics.client.screen.description.general.widgets.base.AbstractDescriptionWidget;
import it.hurts.sskirillss.relics.client.screen.description.research.AbilityResearchScreen;
import it.hurts.sskirillss.relics.client.screen.description.research.particles.ResearchParticleData;
import it.hurts.sskirillss.relics.client.screen.utils.ParticleStorage;
import it.hurts.sskirillss.relics.items.relics.base.IRelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.research.StarData;
import it.hurts.sskirillss.relics.utils.data.AnimationData;
import it.hurts.sskirillss.relics.utils.data.GUIRenderer;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;

public class StarWidget
extends AbstractDescriptionWidget
implements ITickingWidget {
    private AbilityResearchScreen screen;
    private StarData star;

    public StarWidget(int x, int y, AbilityResearchScreen screen, StarData star) {
        super(x, y, 17, 17);
        this.screen = screen;
        this.star = star;
    }

    @Override
    public boolean isLocked() {
        IRelicItem relic;
        Item item = this.screen.stack.getItem();
        return item instanceof IRelicItem && (relic = (IRelicItem)item).isAbilityResearched(this.screen.stack, this.screen.ability);
    }

    @Override
    public void onPress() {
        if (!this.isLocked() && this.screen.getOccupiedConnectionsCount(this.star) < this.screen.getTotalConnectionsCount(this.star)) {
            this.screen.selectedStar = this.star;
        }
    }

    public void renderWidget(GuiGraphics guiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        this.isHovered = guiGraphics.containsPointInScissor(pMouseX, pMouseY) && pMouseX >= this.getX() && pMouseY >= this.getY() && pMouseX < this.getX() + this.width && pMouseY < this.getY() + this.height;
        int index = this.star.getIndex();
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        PoseStack poseStack = guiGraphics.pose();
        poseStack.pushPose();
        float time = (float)player.tickCount + pPartialTick + (float)index * 100.0f;
        poseStack.pushPose();
        RenderSystem.enableBlend();
        poseStack.translate((float)this.getX() + (float)this.width / 2.0f, (float)this.getY() + (float)this.height / 2.0f, 0.0f);
        int totalCount = this.screen.getTotalConnectionsCount(this.star);
        int connectedCount = this.screen.getOccupiedConnectionsCount(this.star);
        float angle = time * 0.05f;
        float radius = (float)(8.0 + Math.sin(time * 0.1f));
        float angleStep = (float)(Math.PI * 2 / (double)totalCount);
        for (int i = 0; i < totalCount; ++i) {
            float color = (float)(0.25 + Math.sin((time + (float)(i * 10)) * 0.25f) * 0.5);
            if (i < connectedCount) {
                RenderSystem.setShaderColor((float)0.25f, (float)(1.0f + color), (float)1.0f, (float)1.0f);
            } else {
                RenderSystem.setShaderColor((float)(1.0f + color), (float)(1.0f + color), (float)(1.0f + color), (float)1.0f);
            }
            float currentAngle = angle + (float)i * angleStep;
            float x = (float)((double)radius * Math.cos(currentAngle));
            float y = (float)((double)radius * Math.sin(currentAngle));
            GUIRenderer.begin(ResourceLocation.fromNamespaceAndPath((String)"relics", (String)"textures/gui/description/research/dot.png"), poseStack).pos(x, y).end();
        }
        RenderSystem.disableBlend();
        poseStack.popPose();
        poseStack.pushPose();
        float color = (float)((double)1.1f + Math.sin(time) * (double)0.2f);
        RenderSystem.setShaderColor((float)color, (float)color, (float)color, (float)1.0f);
        RenderSystem.enableBlend();
        poseStack.translate((float)this.getX() + 0.5f + (float)this.width / 2.0f, (float)this.getY() + 0.5f + (float)this.height / 2.0f, 0.0f);
        poseStack.mulPose(Axis.ZN.rotationDegrees(time * 0.75f * (float)(index % 2 == 0 ? 1 : -1)));
        GUIRenderer.begin(ResourceLocation.fromNamespaceAndPath((String)"relics", (String)"textures/gui/description/research/star.png"), poseStack).texSize(17, 136).patternSize(17, 17).scale((float)(1.0 + Math.sin(time * 0.5f) * (double)0.1f)).animation(AnimationData.builder().frame(0, 2).frame(1, 2).frame(2, 2).frame(3, 2).frame(4, 2).frame(5, 2).frame(6, 2).frame(7, 2)).end();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
        poseStack.popPose();
        poseStack.popPose();
    }

    @Override
    public void onTick() {
        RandomSource random = this.minecraft.player.getRandom();
        if (this.minecraft.player.tickCount % 5 == 0) {
            ParticleStorage.addParticle(this.screen, new ResearchParticleData(new Color(100 + random.nextInt(150), random.nextInt(25), 200 + random.nextInt(50)), (float)this.getX() + random.nextFloat() * (float)this.width, (float)this.getY() + random.nextFloat() * (float)this.height, 1.0f + random.nextFloat() * 0.25f, 10 + random.nextInt(30), 0.01f));
        }
    }

    @Override
    public void playDownSound(SoundManager handler) {
    }

    public StarData getStar() {
        return this.star;
    }
}

