/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.beachparty.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.world.entity.Entity;
import net.satisfy.beachparty.client.model.ChestplateModel;
import net.satisfy.beachparty.core.util.BeachpartyIdentifier;

public class SwimWingsModel<T extends Entity>
extends EntityModel<T>
implements ChestplateModel {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(BeachpartyIdentifier.identifier("swim_wings"), "main");
    private final ModelPart right_arm;
    private final ModelPart left_arm;

    public SwimWingsModel(ModelPart root) {
        this.right_arm = root.getChild("right_arm");
        this.left_arm = root.getChild("left_arm");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition right_arm = partdefinition.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(0, 3).addBox(-8.0f, 1.0f, -2.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.25f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition left_arm = partdefinition.addOrReplaceChild("left_arm", CubeListBuilder.create().texOffs(0, 3).mirror().addBox(-8.0f, 1.0f, -2.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.25f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)16, (int)16);
    }

    public void setupAnim(Entity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
    }

    @Override
    public void copyBody(ModelPart body, ModelPart leftArm, ModelPart rightArm) {
        this.left_arm.copyFrom(leftArm);
        this.right_arm.copyFrom(rightArm);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int buffer, int packedLight, int color) {
        poseStack.pushPose();
        poseStack.translate(0.375f, 0.0f, 0.0f);
        poseStack.scale(1.1f, 1.1f, 1.1f);
        this.right_arm.render(poseStack, vertexConsumer, buffer, packedLight, color);
        poseStack.popPose();
        poseStack.pushPose();
        poseStack.translate(0.45f, -0.05f, 0.0f);
        poseStack.scale(1.1f, 1.1f, 1.1f);
        this.left_arm.render(poseStack, vertexConsumer, buffer, packedLight, color);
        poseStack.popPose();
    }
}

