/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.beachparty.core.block;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CocktailBlock
extends Block {
    public static final EnumProperty<Direction> FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final IntegerProperty STAGE = IntegerProperty.create((String)"stage", (int)0, (int)3);
    public static final VoxelShape SWEETBERRIES_COCKTAIL_SHAPE = Shapes.or((VoxelShape)Shapes.box((double)0.375, (double)0.0, (double)0.375, (double)0.625, (double)0.3125, (double)0.625), (VoxelShape)Shapes.box((double)0.3125, (double)0.3125, (double)0.3125, (double)0.6875, (double)0.75, (double)0.6875));
    public static final VoxelShape MELON_COCKTAIL_SHAPE = Shapes.or((VoxelShape)Shapes.box((double)0.375, (double)0.0, (double)0.375, (double)0.625, (double)0.0625, (double)0.625), (VoxelShape[])new VoxelShape[]{Shapes.box((double)0.4375, (double)0.0625, (double)0.4375, (double)0.5625, (double)0.375, (double)0.5625), Shapes.box((double)0.3125, (double)0.375, (double)0.3125, (double)0.6875, (double)0.75, (double)0.6875)});
    public static final VoxelShape COCONUT_COCKTAIL_SHAPE = Shapes.box((double)0.25, (double)0.0, (double)0.25, (double)0.75, (double)0.5, (double)0.75);
    public static final VoxelShape PUMPKIN_COCKTAIL_SHAPE = Shapes.box((double)0.25, (double)0.0, (double)0.25, (double)0.75, (double)0.625, (double)0.75);
    public static final VoxelShape HONEY_COCKTAIL_SHAPE = Shapes.or((VoxelShape)Shapes.box((double)0.375, (double)0.0, (double)0.375, (double)0.625, (double)0.0625, (double)0.625), (VoxelShape[])new VoxelShape[]{Shapes.box((double)0.4375, (double)0.0625, (double)0.4375, (double)0.5625, (double)0.25, (double)0.5625), Shapes.box((double)0.3125, (double)0.25, (double)0.3125, (double)0.6875, (double)0.8125, (double)0.6875)});
    public static final VoxelShape COCOA_COCKTAIL_SHAPE = Shapes.or((VoxelShape)Shapes.box((double)0.375, (double)0.0, (double)0.375, (double)0.625, (double)0.0625, (double)0.625), (VoxelShape[])new VoxelShape[]{Shapes.box((double)0.4375, (double)0.0625, (double)0.4375, (double)0.5625, (double)0.375, (double)0.5625), Shapes.box((double)0.3125, (double)0.375, (double)0.3125, (double)0.6875, (double)0.75, (double)0.6875)});
    private final MobEffect effect;
    private final int effectDuration;
    private final Supplier<VoxelShape> shapeSupplier;

    public CocktailBlock(BlockBehaviour.Properties settings, MobEffect effect, int effectDuration, Supplier<VoxelShape> shapeSupplier) {
        super(settings);
        this.effect = effect;
        this.effectDuration = effectDuration;
        this.shapeSupplier = shapeSupplier;
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue(FACING, (Comparable)Direction.NORTH)).setValue((Property)STAGE, (Comparable)Integer.valueOf(3)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, STAGE});
    }

    @NotNull
    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return this.shapeSupplier.get();
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return (BlockState)this.defaultBlockState().setValue(FACING, (Comparable)ctx.getHorizontalDirection().getOpposite());
    }

    @NotNull
    protected InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult blockHitResult) {
        if (!world.isClientSide()) {
            int stage = (Integer)state.getValue((Property)STAGE);
            if (stage > 0) {
                player.addEffect(new MobEffectInstance(BuiltInRegistries.MOB_EFFECT.wrapAsHolder((Object)this.effect), this.effectDuration, 0));
                world.playSound(null, pos, SoundEvents.GENERIC_DRINK, SoundSource.BLOCKS, 1.0f, 1.0f);
                world.setBlock(pos, (BlockState)state.setValue((Property)STAGE, (Comparable)Integer.valueOf(stage - 1)), 3);
            } else {
                world.destroyBlock(pos, false);
            }
        }
        return InteractionResult.SUCCESS;
    }
}

