/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.beachparty.core.block.entity;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.satisfy.beachparty.client.gui.handler.PalmBarGuiHandler;
import net.satisfy.beachparty.core.recipe.PalmBarRecipe;
import net.satisfy.beachparty.core.registry.EntityTypeRegistry;
import net.satisfy.beachparty.core.registry.ObjectRegistry;
import net.satisfy.beachparty.core.registry.RecipeTypeRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PalmBarBlockEntity
extends BlockEntity
implements WorldlyContainer,
MenuProvider {
    public static final int CAPACITY = 5;
    private static final int[] SLOTS_FOR_SIDE = new int[]{2, 3, 4};
    private static final int[] SLOTS_FOR_UP = new int[]{1};
    private static final int[] SLOTS_FOR_DOWN = new int[]{0};
    private static final int OUTPUT_SLOT = 0;
    protected float experience;
    private NonNullList<ItemStack> inventory;
    private int shakingTime = 0;
    private int totalShakingTime;
    private final ContainerData propertyDelegate = new ContainerData(){

        public int get(int index) {
            return switch (index) {
                case 0 -> PalmBarBlockEntity.this.shakingTime;
                case 1 -> PalmBarBlockEntity.this.totalShakingTime;
                default -> 0;
            };
        }

        public void set(int index, int value) {
            switch (index) {
                case 0: {
                    PalmBarBlockEntity.this.shakingTime = value;
                    break;
                }
                case 1: {
                    PalmBarBlockEntity.this.totalShakingTime = value;
                }
            }
        }

        public int getCount() {
            return 2;
        }
    };

    public PalmBarBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)EntityTypeRegistry.PALM_BAR_BLOCK_ENTITY.get(), pos, state);
        this.inventory = NonNullList.withSize((int)5, (Object)ItemStack.EMPTY);
    }

    public static void tick(Level world, BlockPos pos, BlockState state, PalmBarBlockEntity blockEntity) {
        if (world.isClientSide) {
            return;
        }
        boolean dirty = false;
        List recipes = world.getRecipeManager().getAllRecipesFor((RecipeType)RecipeTypeRegistry.PALM_BAR_RECIPE_TYPE.get());
        Optional<PalmBarRecipe> recipe = Optional.ofNullable(blockEntity.getRecipe(recipes));
        RegistryAccess access = world.registryAccess();
        if (recipe.isPresent() && blockEntity.canCraft(recipe.get(), access)) {
            ++blockEntity.shakingTime;
            if (blockEntity.shakingTime >= blockEntity.totalShakingTime) {
                blockEntity.shakingTime = 0;
                blockEntity.craft(recipe.get(), access);
                dirty = true;
            }
        } else {
            blockEntity.shakingTime = 0;
        }
        if (dirty) {
            blockEntity.setChanged();
            world.sendBlockUpdated(pos, state, state, 3);
        }
    }

    protected void loadAdditional(CompoundTag nbt, HolderLookup.Provider provider) {
        super.loadAdditional(nbt, provider);
        this.inventory = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
        ContainerHelper.loadAllItems((CompoundTag)nbt, this.inventory, (HolderLookup.Provider)provider);
        this.shakingTime = nbt.getShort("ShakingTime");
        this.totalShakingTime = nbt.getShort("TotalShakingTime");
        this.experience = nbt.getFloat("Experience");
    }

    protected void saveAdditional(CompoundTag nbt, HolderLookup.Provider provider) {
        super.saveAdditional(nbt, provider);
        ContainerHelper.saveAllItems((CompoundTag)nbt, this.inventory, (HolderLookup.Provider)provider);
        nbt.putFloat("Experience", this.experience);
        nbt.putShort("ShakingTime", (short)this.shakingTime);
        nbt.putShort("TotalShakingTime", (short)this.totalShakingTime);
    }

    private boolean canCraft(@Nullable PalmBarRecipe recipe, RegistryAccess access) {
        if (recipe == null) {
            return false;
        }
        ItemStack recipeResultItem = recipe.getResultItem((HolderLookup.Provider)access);
        if (recipeResultItem.isEmpty() || this.areInputsEmpty()) {
            return false;
        }
        ItemStack outputSlotItem = this.getItem(0);
        if (outputSlotItem.isEmpty()) {
            return true;
        }
        return ItemStack.isSameItem((ItemStack)outputSlotItem, (ItemStack)recipeResultItem) && outputSlotItem.getCount() + recipeResultItem.getCount() <= outputSlotItem.getMaxStackSize();
    }

    private boolean areInputsEmpty() {
        for (int i = 1; i <= 4; ++i) {
            if (this.getItem(i).isEmpty()) continue;
            return false;
        }
        return true;
    }

    private void craft(PalmBarRecipe recipe, RegistryAccess access) {
        if (!this.canCraft(recipe, access)) {
            return;
        }
        ItemStack recipeOutput = recipe.getResultItem((HolderLookup.Provider)access).copy();
        ItemStack outputSlotStack = this.getItem(0);
        if (outputSlotStack.isEmpty()) {
            this.setItem(0, recipeOutput);
        } else if (ItemStack.isSameItem((ItemStack)outputSlotStack, (ItemStack)recipeOutput)) {
            outputSlotStack.grow(recipeOutput.getCount());
            if (outputSlotStack.getCount() > outputSlotStack.getMaxStackSize()) {
                outputSlotStack.setCount(outputSlotStack.getMaxStackSize());
            }
        }
        this.consumeIngredients(recipe);
    }

    private ItemStack getRemainderItem(ItemStack stack) {
        if (stack.getItem().hasCraftingRemainingItem()) {
            return new ItemStack((ItemLike)Objects.requireNonNull(stack.getItem().getCraftingRemainingItem()));
        }
        return ItemStack.EMPTY;
    }

    private void consumeIngredients(PalmBarRecipe recipe) {
        block0: for (Ingredient ingredient : recipe.getIngredients()) {
            for (int i = 1; i <= 4; ++i) {
                ItemStack slotItem = this.getItem(i);
                if (!ingredient.test(slotItem)) continue;
                ItemStack remainder = this.getRemainderItem(slotItem);
                slotItem.shrink(1);
                if (slotItem.isEmpty() && !remainder.isEmpty()) {
                    this.setItem(i, remainder);
                    continue block0;
                }
                if (!slotItem.isEmpty()) continue block0;
                this.setItem(i, ItemStack.EMPTY);
                continue block0;
            }
        }
    }

    @NotNull
    public ItemStack getItem(int i) {
        return (ItemStack)this.inventory.get(i);
    }

    @NotNull
    public ItemStack removeItem(int i, int j) {
        return ContainerHelper.removeItem(this.inventory, (int)i, (int)j);
    }

    @NotNull
    public ItemStack removeItemNoUpdate(int i) {
        return (ItemStack)this.inventory.remove(i);
    }

    public int @NotNull [] getSlotsForFace(Direction side) {
        if (side.equals((Object)Direction.UP)) {
            return SLOTS_FOR_UP;
        }
        if (side.equals((Object)Direction.DOWN)) {
            return SLOTS_FOR_DOWN;
        }
        return SLOTS_FOR_SIDE;
    }

    public boolean canPlaceItemThroughFace(int i, ItemStack itemStack, @Nullable Direction direction) {
        return false;
    }

    public boolean canTakeItemThroughFace(int i, ItemStack itemStack, Direction direction) {
        return false;
    }

    public int getContainerSize() {
        return 5;
    }

    public boolean isEmpty() {
        return this.inventory.stream().allMatch(Predicate.isEqual(ItemStack.EMPTY));
    }

    public void setItem(int slot, ItemStack stack) {
        this.inventory.set(slot, (Object)stack);
        if (stack.getCount() > this.getMaxStackSize()) {
            stack.setCount(this.getMaxStackSize());
        }
        if (slot >= 1 && slot <= 4) {
            this.totalShakingTime = 50;
            this.shakingTime = 0;
            this.setChanged();
        }
    }

    public boolean stillValid(Player player) {
        return this.level != null && this.level.getBlockEntity(this.worldPosition) == this && player.distanceToSqr((double)this.worldPosition.getX() + 0.5, (double)this.worldPosition.getY() + 0.5, (double)this.worldPosition.getZ() + 0.5) <= 64.0;
    }

    @NotNull
    public Component getDisplayName() {
        return ((Block)ObjectRegistry.PALM_BAR.get()).getName();
    }

    @Nullable
    public AbstractContainerMenu createMenu(int syncId, Inventory inv, Player player) {
        return new PalmBarGuiHandler(syncId, inv, (Container)this, this.propertyDelegate);
    }

    public void clearContent() {
        this.inventory.clear();
    }

    private PalmBarRecipe getRecipe(List<RecipeHolder<PalmBarRecipe>> recipes) {
        block0: for (RecipeHolder<PalmBarRecipe> holder : recipes) {
            PalmBarRecipe recipe = (PalmBarRecipe)holder.value();
            for (Ingredient ingredient : recipe.getIngredients()) {
                boolean ok = false;
                for (int slotIndex = 1; slotIndex < this.inventory.size(); ++slotIndex) {
                    ItemStack slotItem = (ItemStack)this.inventory.get(slotIndex);
                    if (!ingredient.test(slotItem)) continue;
                    ok = true;
                    break;
                }
                if (ok) continue;
                continue block0;
            }
            return recipe;
        }
        return null;
    }
}

