/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.beachparty.core.compat.jei;

import java.util.List;
import java.util.Objects;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.satisfy.beachparty.core.compat.jei.categorys.MiniFridgeCategory;
import net.satisfy.beachparty.core.compat.jei.categorys.PalmBarCategory;
import net.satisfy.beachparty.core.registry.ObjectRegistry;
import net.satisfy.beachparty.core.registry.RecipeTypeRegistry;
import net.satisfy.beachparty.core.util.BeachpartyIdentifier;
import org.jetbrains.annotations.NotNull;

@JeiPlugin
public class BeachpartyJEIPlugin
implements IModPlugin {
    @NotNull
    public ResourceLocation getPluginUid() {
        return BeachpartyIdentifier.identifier("jei_plugin");
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        registration.addRecipeCategories(new IRecipeCategory[]{new MiniFridgeCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new PalmBarCategory(registration.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        RecipeManager rm = Objects.requireNonNull(Minecraft.getInstance().level).getRecipeManager();
        List fridgeHolders = rm.getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)RecipeTypeRegistry.MINI_FRIDGE_RECIPE_TYPE.get());
        registration.addRecipes(MiniFridgeCategory.RECIPE_TYPE, fridgeHolders.stream().map(RecipeHolder::value).toList());
        List barHolders = rm.getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)RecipeTypeRegistry.PALM_BAR_RECIPE_TYPE.get());
        registration.addRecipes(PalmBarCategory.PALM_BAR, barHolders.stream().map(RecipeHolder::value).toList());
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)((Block)ObjectRegistry.MINI_FRIDGE.get()).asItem()), new RecipeType[]{MiniFridgeCategory.RECIPE_TYPE});
        registration.addRecipeCatalyst(((Block)ObjectRegistry.PALM_BAR.get()).asItem().getDefaultInstance(), new RecipeType[]{PalmBarCategory.PALM_BAR});
    }
}

