/*
 * Decompiled with CFR 0.152.
 */
package com.github.L_Ender.cataclysm.client.render.entity;

import com.github.L_Ender.cataclysm.client.model.CMModelLayers;
import com.github.L_Ender.cataclysm.client.model.entity.Elemental_Spear_Model;
import com.github.L_Ender.cataclysm.client.render.CMRenderTypes;
import com.github.L_Ender.cataclysm.entity.projectile.Water_Spear_Entity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class Water_Spear_Renderer
extends EntityRenderer<Water_Spear_Entity> {
    private static final ResourceLocation[] TEXTURE_PROGRESS = new ResourceLocation[6];
    public Elemental_Spear_Model model;

    public Water_Spear_Renderer(EntityRendererProvider.Context manager) {
        super(manager);
        this.model = new Elemental_Spear_Model(manager.bakeLayer(CMModelLayers.ELEMENTAL_SPEAR_MODEL));
        for (int i = 0; i < 6; ++i) {
            Water_Spear_Renderer.TEXTURE_PROGRESS[i] = ResourceLocation.fromNamespaceAndPath((String)"cataclysm", (String)("textures/entity/sea/spear/water_spear_" + i + ".png"));
        }
    }

    public void render(Water_Spear_Entity entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        poseStack.pushPose();
        poseStack.scale(-1.0f, -1.0f, 1.0f);
        float f = Mth.rotLerp((float)partialTicks, (float)entity.yRotO, (float)entity.getYRot());
        float f1 = Mth.lerp((float)partialTicks, (float)entity.xRotO, (float)entity.getXRot());
        this.model.setupAnim(entity, 0.0f, 0.0f, (float)entity.tickCount + partialTicks, f, f1);
        VertexConsumer vertexconsumer = buffer.getBuffer(CMRenderTypes.getGhost(this.getTextureLocation(entity)));
        this.model.renderToBuffer(poseStack, vertexconsumer, packedLight, OverlayTexture.NO_OVERLAY);
        poseStack.popPose();
        super.render((Entity)entity, entityYaw, partialTicks, poseStack, buffer, packedLight);
    }

    public ResourceLocation getTextureLocation(Water_Spear_Entity entity) {
        return this.getGrowingTexture((int)((float)entity.tickCount * 0.5f % 5.0f));
    }

    public ResourceLocation getGrowingTexture(int age) {
        return TEXTURE_PROGRESS[Mth.clamp((int)age, (int)0, (int)5)];
    }
}

