/*
 * Decompiled with CFR 0.152.
 */
package com.github.L_Ender.cataclysm.entity.effect;

import com.github.L_Ender.cataclysm.client.particle.Options.LightningZapParticleOptions;
import com.github.L_Ender.cataclysm.client.particle.Options.RainFogParticleOptions;
import com.github.L_Ender.cataclysm.init.ModEntities;
import com.github.L_Ender.cataclysm.util.CMDamageTypes;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.PushReaction;

public class Lightning_Area_Effect_Entity
extends Entity {
    private static final EntityDataAccessor<Float> DATA_RADIUS = SynchedEntityData.defineId(Lightning_Area_Effect_Entity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> DAMAGE = SynchedEntityData.defineId(Lightning_Area_Effect_Entity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Boolean> DATA_WAITING = SynchedEntityData.defineId(Lightning_Area_Effect_Entity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final float MAX_RADIUS = 32.0f;
    private int duration = 600;
    private int waitTime = 20;
    private int durationOnUse;
    private float radiusOnUse;
    private float radiusPerTick;
    @Nullable
    private LivingEntity owner;
    @Nullable
    private UUID ownerUUID;

    public Lightning_Area_Effect_Entity(EntityType<? extends Lightning_Area_Effect_Entity> p_19704_, Level p_19705_) {
        super(p_19704_, p_19705_);
        this.noPhysics = true;
        this.setRadius(3.0f);
    }

    public Lightning_Area_Effect_Entity(Level p_19707_, double p_19708_, double p_19709_, double p_19710_) {
        this((EntityType<? extends Lightning_Area_Effect_Entity>)((EntityType)ModEntities.LIGHTNING_AREA_EFFECT.get()), p_19707_);
        this.setPos(p_19708_, p_19709_, p_19710_);
    }

    protected void defineSynchedData(SynchedEntityData.Builder p_326229_) {
        p_326229_.define(DATA_RADIUS, (Object)Float.valueOf(0.5f));
        p_326229_.define(DAMAGE, (Object)Float.valueOf(0.0f));
        p_326229_.define(DATA_WAITING, (Object)false);
    }

    public void setRadius(float p_19713_) {
        if (!this.level().isClientSide) {
            this.getEntityData().set(DATA_RADIUS, (Object)Float.valueOf(Mth.clamp((float)p_19713_, (float)0.0f, (float)32.0f)));
        }
    }

    public void refreshDimensions() {
        double d0 = this.getX();
        double d1 = this.getY();
        double d2 = this.getZ();
        super.refreshDimensions();
        this.setPos(d0, d1, d2);
    }

    public float getDamage() {
        return ((Float)this.entityData.get(DAMAGE)).floatValue();
    }

    public void setDamage(float f) {
        this.entityData.set(DAMAGE, (Object)Float.valueOf(f));
    }

    public float getRadius() {
        return ((Float)this.getEntityData().get(DATA_RADIUS)).floatValue();
    }

    protected void setWaiting(boolean p_19731_) {
        this.getEntityData().set(DATA_WAITING, (Object)p_19731_);
    }

    public boolean isWaiting() {
        return (Boolean)this.getEntityData().get(DATA_WAITING);
    }

    public int getDuration() {
        return this.duration;
    }

    public void setDuration(int p_19735_) {
        this.duration = p_19735_;
    }

    public void tick() {
        super.tick();
        boolean flag = this.isWaiting();
        float f = this.getRadius();
        if (this.level().isClientSide) {
            if (flag) {
                return;
            }
            for (int j = 0; j < 2 + this.random.nextInt(1); ++j) {
                float f2 = this.random.nextFloat() * ((float)Math.PI * 2);
                float f3 = Mth.sqrt((float)this.random.nextFloat()) * f;
                double d0 = this.getX() + (double)(Mth.cos((float)f2) * f3);
                double d2 = this.getY() + 0.2;
                double d4 = this.getZ() + (double)(Mth.sin((float)f2) * f3);
                this.level().addAlwaysVisibleParticle((ParticleOptions)new LightningZapParticleOptions(99, 194, 201, 0.0f), d0, d2, d4, 0.0, this.random.nextGaussian() * 0.07, 0.0);
            }
            if (this.tickCount % 10 == 0) {
                this.level().addAlwaysVisibleParticle((ParticleOptions)new RainFogParticleOptions(f), this.getX(), this.getY() + 0.01, this.getZ(), this.random.nextGaussian() * 0.01, 0.0, this.random.nextGaussian() * 0.01);
            }
        } else {
            boolean flag1;
            if (this.tickCount >= this.waitTime + this.duration) {
                this.discard();
                return;
            }
            boolean bl = flag1 = this.tickCount < this.waitTime;
            if (flag != flag1) {
                this.setWaiting(flag1);
            }
            if (flag1) {
                return;
            }
            if (this.radiusPerTick != 0.0f) {
                if ((f += this.radiusPerTick) < 0.5f) {
                    this.discard();
                    return;
                }
                this.setRadius(f);
            }
            if (this.tickCount % 5 == 0) {
                for (LivingEntity livingentity : this.level().getEntitiesOfClass(LivingEntity.class, this.getBoundingBox())) {
                    this.damage(livingentity);
                }
            }
        }
    }

    protected void damage(LivingEntity Hitentity) {
        LivingEntity caster = this.getOwner();
        if (Hitentity.isAlive() && !Hitentity.isInvulnerable() && Hitentity != caster && this.tickCount % 5 == 0) {
            if (caster == null) {
                Hitentity.hurt(this.damageSources().lightningBolt(), this.getDamage());
            } else if (!caster.isAlliedTo((Entity)Hitentity) && !Hitentity.isAlliedTo((Entity)caster)) {
                Hitentity.hurt(CMDamageTypes.causeLightningDamage(this, (Entity)caster), this.getDamage());
            }
        }
    }

    public float getRadiusOnUse() {
        return this.radiusOnUse;
    }

    public void setRadiusOnUse(float p_19733_) {
        this.radiusOnUse = p_19733_;
    }

    public float getRadiusPerTick() {
        return this.radiusPerTick;
    }

    public void setRadiusPerTick(float p_19739_) {
        this.radiusPerTick = p_19739_;
    }

    public int getDurationOnUse() {
        return this.durationOnUse;
    }

    public void setDurationOnUse(int p_146786_) {
        this.durationOnUse = p_146786_;
    }

    public int getWaitTime() {
        return this.waitTime;
    }

    public void setWaitTime(int p_19741_) {
        this.waitTime = p_19741_;
    }

    public void setOwner(@Nullable LivingEntity p_19719_) {
        this.owner = p_19719_;
        this.ownerUUID = p_19719_ == null ? null : p_19719_.getUUID();
    }

    @Nullable
    public LivingEntity getOwner() {
        Entity entity;
        if (this.owner == null && this.ownerUUID != null && this.level() instanceof ServerLevel && (entity = ((ServerLevel)this.level()).getEntity(this.ownerUUID)) instanceof LivingEntity) {
            this.owner = (LivingEntity)entity;
        }
        return this.owner;
    }

    protected void readAdditionalSaveData(CompoundTag p_19727_) {
        this.tickCount = p_19727_.getInt("Age");
        this.duration = p_19727_.getInt("Duration");
        this.waitTime = p_19727_.getInt("WaitTime");
        this.durationOnUse = p_19727_.getInt("DurationOnUse");
        this.radiusOnUse = p_19727_.getFloat("RadiusOnUse");
        this.radiusPerTick = p_19727_.getFloat("RadiusPerTick");
        this.setRadius(p_19727_.getFloat("Radius"));
        if (p_19727_.hasUUID("Owner")) {
            this.ownerUUID = p_19727_.getUUID("Owner");
        }
    }

    protected void addAdditionalSaveData(CompoundTag p_19737_) {
        p_19737_.putInt("Age", this.tickCount);
        p_19737_.putInt("Duration", this.duration);
        p_19737_.putInt("WaitTime", this.waitTime);
        p_19737_.putInt("DurationOnUse", this.durationOnUse);
        p_19737_.putFloat("RadiusOnUse", this.radiusOnUse);
        p_19737_.putFloat("RadiusPerTick", this.radiusPerTick);
        p_19737_.putFloat("Radius", this.getRadius());
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> p_19729_) {
        if (DATA_RADIUS.equals(p_19729_)) {
            this.refreshDimensions();
        }
        super.onSyncedDataUpdated(p_19729_);
    }

    public PushReaction getPistonPushReaction() {
        return PushReaction.IGNORE;
    }

    public EntityDimensions getDimensions(Pose p_19721_) {
        return EntityDimensions.scalable((float)(this.getRadius() * 2.0f), (float)0.5f);
    }
}

