/*
 * Decompiled with CFR 0.152.
 */
package fuzs.betteranimationscollection.client.model;

import fuzs.betteranimationscollection.client.element.GhastTentaclesElement;
import fuzs.betteranimationscollection.mixin.client.accessor.LayerDefinitionAccessor;
import net.minecraft.client.model.GhastModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;

public class GhastTentaclesModel<T extends Entity>
extends GhastModel<T> {
    public static final int GHAST_MAX_TENTACLES_LENGTH = 14;
    private final ModelPart[] tentacles = new ModelPart[9];
    private final ModelPart[][] tentacleParts = new ModelPart[9][];

    public GhastTentaclesModel(ModelPart modelPart) {
        super(modelPart);
        for (int i = 0; i < this.tentacles.length; ++i) {
            ModelPart tentacle = this.tentacles[i] = modelPart.getChild("tentacle" + i);
            this.tentacleParts[i] = new ModelPart[14];
            for (int j = 0; j < this.tentacleParts[i].length; ++j) {
                ModelPart modelPart2 = tentacle.getChild("tentacle_part" + j);
                this.tentacleParts[i][j] = modelPart2;
                tentacle = modelPart2;
            }
        }
    }

    public static LayerDefinition createAnimatedBodyLayer() {
        LayerDefinition layerDefinition = GhastModel.createBodyLayer();
        MeshDefinition meshDefinition = ((LayerDefinitionAccessor)layerDefinition).getMesh();
        PartDefinition partDefinition = meshDefinition.getRoot();
        for (int i = 0; i < 9; ++i) {
            float offsetX = (((float)(i % 3) - (float)(i / 3 % 2) * 0.5f + 0.25f) / 2.0f * 2.0f - 1.0f) * 5.0f;
            float offsetY = 24.6f;
            float offsetZ = ((float)(i / 3) / 2.0f * 2.0f - 1.0f) * 5.0f;
            PartDefinition partDefinition1 = partDefinition.addOrReplaceChild("tentacle" + i, CubeListBuilder.create().texOffs(0, 0).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 1.0f, 2.0f), PartPose.offset((float)offsetX, (float)offsetY, (float)offsetZ));
            for (int j = 0; j < 14; ++j) {
                partDefinition1 = partDefinition1.addOrReplaceChild("tentacle_part" + j, CubeListBuilder.create().texOffs(0, 1 + j).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 1.0f, 2.0f), PartPose.offset((float)0.0f, (float)1.0f, (float)0.0f));
            }
        }
        return layerDefinition;
    }

    public void setupAnim(T entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float speed = 1.0f / (float)GhastTentaclesElement.animationSpeed;
        RandomSource randomSource = RandomSource.create((long)1660L);
        for (int i = 0; i < this.tentacles.length; ++i) {
            this.tentacles[i].xRot = speed * Mth.sin((float)(ageInTicks * speed + (float)i)) + 0.4f;
            int randomLength = randomSource.nextInt(GhastTentaclesElement.maxTentaclesLength / 2) + GhastTentaclesElement.maxTentaclesLength / 2 + 1;
            for (int j = 0; j < this.tentacleParts[i].length; ++j) {
                this.tentacleParts[i][j].xRot = speed * Mth.sin((float)(ageInTicks * speed + (float)i - (float)j / 2.0f));
                this.tentacleParts[i][j].visible = j < randomLength;
            }
        }
    }
}

