/*
 * Decompiled with CFR 0.152.
 */
package fuzs.betteranimationscollection.client.model;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import fuzs.betteranimationscollection.client.element.PlayfulDoggyElement;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.minecraft.client.model.WolfModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.animal.Wolf;

public class PlayfulDoggyModel<T extends Wolf>
extends WolfModel<T> {
    public static final int WOLF_TAIL_LENGTH = 7;
    private final ModelPart head;
    private final ModelPart realHead;
    private final ModelPart body;
    private final ModelPart rightHindLeg;
    private final ModelPart leftHindLeg;
    private final ModelPart rightFrontLeg;
    private final ModelPart leftFrontLeg;
    private final ModelPart tail;
    private final ModelPart realTail;
    private final ModelPart[] realTailParts;
    private final ModelPart fluffyTail;
    private final ModelPart realFluffyTail;
    private final ModelPart[] realFluffyTailParts;
    private final ModelPart upperBody;
    private boolean isInSittingPose;
    private float rollOverAmount;
    private float tickDelta;

    public PlayfulDoggyModel(ModelPart modelPart) {
        super(modelPart);
        this.head = modelPart.getChild("head");
        this.realHead = this.head.getChild("real_head");
        this.body = modelPart.getChild("body");
        this.upperBody = modelPart.getChild("upper_body");
        this.rightHindLeg = modelPart.getChild("right_hind_leg");
        this.leftHindLeg = modelPart.getChild("left_hind_leg");
        this.rightFrontLeg = modelPart.getChild("right_front_leg");
        this.leftFrontLeg = modelPart.getChild("left_front_leg");
        this.tail = modelPart.getChild("tail");
        this.fluffyTail = modelPart.getChild("fluffy_tail");
        ModelPart modelPart1 = this.realTail = this.tail.getChild("real_tail");
        this.realTailParts = new ModelPart[7];
        for (int i = 0; i < this.realTailParts.length; ++i) {
            this.realTailParts[i] = modelPart1 = modelPart1.getChild("real_tail" + i);
        }
        ModelPart modelPart2 = this.realFluffyTail = this.fluffyTail.getChild("real_fluffy_tail");
        this.realFluffyTailParts = new ModelPart[7];
        for (int i = 0; i < this.realFluffyTailParts.length; ++i) {
            this.realFluffyTailParts[i] = modelPart2 = modelPart2.getChild("real_fluffy_tail" + i);
        }
    }

    public static MeshDefinition createAnimatedBodyLayer(CubeDeformation cubeDeformation) {
        MeshDefinition meshDefinition = WolfModel.createMeshDefinition((CubeDeformation)cubeDeformation);
        PartDefinition partDefinition = meshDefinition.getRoot();
        PartDefinition partDefinition1 = partDefinition.getChild("tail");
        PartDefinition partDefinition3 = partDefinition.addOrReplaceChild("fluffy_tail", CubeListBuilder.create(), PartPose.offsetAndRotation((float)-1.0f, (float)12.0f, (float)8.0f, (float)0.62831855f, (float)0.0f, (float)0.0f));
        CubeListBuilder cubeListBuilder = CubeListBuilder.create().texOffs(9, 18).addBox(0.0f, 0.0f, -1.0f, 2.0f, 1.0f, 2.0f, cubeDeformation);
        PartDefinition partDefinition2 = partDefinition1.addOrReplaceChild("real_tail", cubeListBuilder, PartPose.ZERO);
        PartDefinition partDefinition4 = partDefinition3.addOrReplaceChild("real_fluffy_tail", cubeListBuilder, PartPose.ZERO);
        for (int i = 0; i < 7; ++i) {
            partDefinition2 = partDefinition2.addOrReplaceChild("real_tail" + i, CubeListBuilder.create().texOffs(9, Math.min(19 + i, 25)).addBox(0.0f, 0.0f, -1.0f, 2.0f, 1.0f, 2.0f, cubeDeformation), PartPose.offset((float)0.0f, (float)1.0f, (float)0.0f));
            CubeDeformation cubeDeformation1 = cubeDeformation.extend(PlayfulDoggyModel.getTailFluffiness(i));
            partDefinition4 = partDefinition4.addOrReplaceChild("real_fluffy_tail" + i, CubeListBuilder.create().texOffs(9, Math.min(19 + i, 25)).addBox(0.0f, 0.0f, -1.0f, 2.0f, 1.0f, 2.0f, cubeDeformation1), PartPose.offset((float)0.0f, (float)(1.0f + PlayfulDoggyModel.getTailFluffiness(i)), (float)0.0f));
        }
        return meshDefinition;
    }

    private static float getTailFluffiness(int index) {
        if (index < 5) {
            return 0.1f + 0.1f * (float)index;
        }
        if (index == 5) {
            return 0.4f;
        }
        return 0.15f;
    }

    protected Iterable<ModelPart> bodyParts() {
        return (Iterable)Stream.concat(StreamSupport.stream(super.bodyParts().spliterator(), false), Stream.of(this.fluffyTail)).collect(ImmutableList.toImmutableList());
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, int color) {
        if (!this.isInSittingPose || !PlayfulDoggyElement.sittingBehaviour.rollOver() || PlayfulDoggyElement.sittingBehaviour.begForMeat() && (double)this.rollOverAmount < 1.0E-4) {
            super.renderToBuffer(poseStack, buffer, packedLight, packedOverlay, color);
            return;
        }
        float rollOverAmount = PlayfulDoggyElement.sittingBehaviour.begForMeat() ? this.rollOverAmount : 0.47123888f;
        poseStack.pushPose();
        poseStack.translate(0.0f, 1.25f, 0.0f);
        poseStack.mulPose(Axis.ZP.rotationDegrees(180.0f * rollOverAmount));
        poseStack.translate(0.0f, -1.25f, 0.0f);
        this.rightHindLeg.xRot += rollOverAmount * 1.5f;
        this.leftHindLeg.xRot += rollOverAmount * 1.5f;
        this.rightFrontLeg.xRot += rollOverAmount * 1.5f;
        this.leftFrontLeg.xRot += rollOverAmount * 1.5f;
        this.rightHindLeg.y -= rollOverAmount * 1.75f;
        this.leftHindLeg.y -= rollOverAmount * 1.75f;
        this.rightFrontLeg.y -= rollOverAmount * 1.75f;
        this.leftFrontLeg.y -= rollOverAmount * 1.75f;
        this.realHead.zRot = -rollOverAmount * 1.5f;
        super.renderToBuffer(poseStack, buffer, packedLight, packedOverlay, color);
        poseStack.popPose();
    }

    public void prepareMobModel(T entity, float limbSwing, float limbSwingAmount, float partialTick) {
        this.tickDelta = partialTick;
        super.prepareMobModel(entity, limbSwing, limbSwingAmount, partialTick);
        if (entity.isInSittingPose()) {
            if (PlayfulDoggyElement.sittingBehaviour.lieDown()) {
                this.upperBody.setPos(-1.0f, 17.5f, -3.0f);
                this.upperBody.xRot = 1.5707964f;
                this.upperBody.yRot = 0.0f;
                this.body.setPos(0.0f, 17.5f, 0.0f);
                this.body.xRot = 1.3463969f;
                this.tail.setPos(-1.0f, 19.0f, 6.0f);
                this.rightHindLeg.setPos(-2.5f, 22.0f, 5.25f);
                this.rightHindLeg.xRot = 4.712389f;
                this.rightHindLeg.yRot = 0.4f;
                this.leftHindLeg.setPos(0.5f, 22.0f, 5.25f);
                this.leftHindLeg.xRot = 4.712389f;
                this.leftHindLeg.yRot = -0.4f;
                this.rightFrontLeg.xRot = 4.712389f;
                this.rightFrontLeg.setPos(-2.49f, 21.5f, -2.0f);
                this.rightFrontLeg.yRot = 0.15f;
                this.leftFrontLeg.xRot = 4.712389f;
                this.leftFrontLeg.setPos(0.51f, 21.5f, -2.0f);
                this.leftFrontLeg.yRot = -0.15f;
                this.head.y = this.young ? 15.5f : 17.0f;
            } else {
                this.upperBody.setPos(-1.0f, 16.0f, -3.0f);
                this.upperBody.xRot = 1.2566371f;
                this.upperBody.yRot = 0.0f;
                this.tail.setPos(-1.0f, 21.0f, 6.0f);
            }
        } else {
            this.upperBody.setPos(-1.0f, 14.0f, -3.0f);
            this.upperBody.xRot = this.body.xRot;
            this.tail.setPos(-1.0f, 12.0f, 8.0f);
            this.head.y = 13.5f;
            this.leftFrontLeg.yRot = 0.0f;
            this.rightFrontLeg.yRot = 0.0f;
            this.leftHindLeg.yRot = 0.0f;
            this.rightHindLeg.yRot = 0.0f;
        }
        this.upperBody.zRot = entity.getBodyRollAngle(partialTick, -0.08f);
        this.realTail.zRot = entity.getBodyRollAngle(partialTick, -0.2f);
    }

    public void setupAnim(T entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        super.setupAnim(entityIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        this.isInSittingPose = entityIn.isInSittingPose();
        this.rollOverAmount = entityIn.getHeadRollAngle(1.0f) + entityIn.getBodyRollAngle(1.0f, 0.0f);
        this.setupAnimTail(entityIn, limbSwing, limbSwingAmount, this.tickDelta);
    }

    private void setupAnimTail(T entitylivingbaseIn, float limbSwing, float limbSwingAmount, float partialTickTime) {
        float progress = ((float)((Wolf)entitylivingbaseIn).tickCount + partialTickTime) / 3.978873f;
        float magnitude = (0.5f + Math.max(limbSwingAmount, entitylivingbaseIn.getHeadRollAngle(partialTickTime) * 1.5f)) * 0.25f;
        float amplitude = limbSwing * 0.6662f + progress * 0.6662f;
        if (!entitylivingbaseIn.isTame()) {
            this.tail.xRot += Mth.sin((float)amplitude) * magnitude;
            this.tail.yRot = 0.0f;
            for (int i = 0; i < this.realTailParts.length; ++i) {
                this.realTailParts[i].zRot = 0.0f;
                this.realTailParts[i].xRot = Mth.sin((float)(amplitude - (float)(i + 1) * (float)PlayfulDoggyElement.animationSpeed * 0.15f)) * magnitude;
            }
        } else {
            this.tail.yRot = Mth.sin((float)amplitude) * magnitude;
            for (int i = 0; i < this.realTailParts.length; ++i) {
                this.realTailParts[i].xRot = 0.0f;
                this.realTailParts[i].zRot = Mth.sin((float)(amplitude - (float)(i + 1) * (float)PlayfulDoggyElement.animationSpeed * 0.15f)) * magnitude;
            }
        }
        this.copyAllTailParts();
        this.setModelPartVisibilities();
    }

    private void copyAllTailParts() {
        this.fluffyTail.copyFrom(this.tail);
        this.realFluffyTail.copyFrom(this.realTail);
        for (int i = 0; i < this.realTailParts.length; ++i) {
            this.realFluffyTailParts[i].copyFrom(this.realTailParts[i]);
        }
    }

    private void setModelPartVisibilities() {
        this.tail.visible = !PlayfulDoggyElement.fluffyTail;
        this.fluffyTail.visible = PlayfulDoggyElement.fluffyTail;
    }
}

