/*
 * Decompiled with CFR 0.152.
 */
package fuzs.betteranimationscollection.client.model;

import net.minecraft.client.model.SnowGolemModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;

public class SnowGolemStickModel<T extends Entity>
extends SnowGolemModel<T> {
    private final ModelPart leftArm;
    private final ModelPart rightArm;

    public SnowGolemStickModel(ModelPart modelPart) {
        super(modelPart);
        this.leftArm = modelPart.getChild("left_arm");
        this.rightArm = modelPart.getChild("right_arm");
    }

    public void setupAnim(T entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        super.setupAnim(entityIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        if (entityIn instanceof Mob) {
            boolean leftHanded;
            Mob mob = (Mob)entityIn;
            int soundTime = mob.ambientSoundTime + mob.getAmbientSoundInterval();
            boolean bl = leftHanded = Math.abs(mob.getUUID().getLeastSignificantBits() % 20L) == 0L;
            if (0 < soundTime && soundTime < 8) {
                if (leftHanded) {
                    this.leftArm.xRot = 1.5f - (float)soundTime * 1.5f / 8.0f;
                    this.leftArm.yRot += (1.0f - (float)soundTime / 8.0f) * 2.0f;
                } else {
                    this.rightArm.xRot = 1.5f - (float)soundTime * 1.5f / 8.0f;
                    this.rightArm.yRot -= (1.0f - (float)soundTime / 8.0f) * 2.0f;
                }
            } else {
                this.leftArm.xRot = 0.0f;
                this.rightArm.xRot = 0.0f;
            }
        }
    }
}

