/*
 * Decompiled with CFR 0.152.
 */
package fonnymunkey.simplehats.client.hat;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import fonnymunkey.simplehats.common.init.SimpleHatsConfigAbstract;
import fonnymunkey.simplehats.common.item.HatItem;
import fonnymunkey.simplehats.util.HatEntry;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.AccessoriesContainer;
import io.wispforest.accessories.api.EquipmentChecking;
import io.wispforest.accessories.api.slot.SlotEntryReference;
import java.util.Optional;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.core.particles.ColorParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.ZombieVillager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;

public class HatLayer<T extends LivingEntity, M extends EntityModel<T>>
extends RenderLayer<T, M> {
    public HatLayer(RenderLayerParent<T, M> renderer) {
        super(renderer);
    }

    public void render(PoseStack poseStack, MultiBufferSource buffer, int packedLight, T livingEntity, float limbSwing, float limbSwingAmount, float partialTicks, float age, float netHeadYaw, float headPitch) {
        if (livingEntity == Minecraft.getInstance().cameraEntity && Minecraft.getInstance().options.getCameraType() == CameraType.FIRST_PERSON && SimpleHatsConfigAbstract.forceFirstPersonNoRender()) {
            return;
        }
        Optional.ofNullable(AccessoriesCapability.get(livingEntity)).ifPresent(component -> {
            AccessoriesContainer container;
            SlotEntryReference slotCos = component.getFirstEquipped(stack -> stack.getItem() instanceof HatItem, EquipmentChecking.COSMETICALLY_OVERRIDABLE);
            SlotEntryReference slotNonCos = component.getFirstEquipped(stack -> stack.getItem() instanceof HatItem, EquipmentChecking.ACCESSORIES_ONLY);
            boolean renderingCos = false;
            if (slotCos != null && (container = slotCos.reference().slotContainer()) != null && container.shouldRender(slotCos.reference().slot())) {
                renderingCos = true;
                this.render(slotCos.stack(), poseStack, buffer, packedLight, livingEntity, limbSwing, limbSwingAmount, partialTicks, age, netHeadYaw, headPitch);
            }
            if (slotNonCos != null && !renderingCos && (container = slotNonCos.reference().slotContainer()) != null && container.shouldRender(slotNonCos.reference().slot())) {
                this.render(slotNonCos.stack(), poseStack, buffer, packedLight, livingEntity, limbSwing, limbSwingAmount, partialTicks, age, netHeadYaw, headPitch);
            }
        });
    }

    private void render(ItemStack itemStack, PoseStack poseStack, MultiBufferSource buffer, int packedLight, T livingEntity, float limbSwing, float limbSwingAmount, float partialTicks, float age, float netHeadYaw, float headPitch) {
        HatEntry.HatParticleSettings particleSettings;
        if (!livingEntity.isInvisible()) {
            boolean flag;
            poseStack.pushPose();
            poseStack.scale(1.01f, 1.01f, 1.01f);
            poseStack.translate(0.0, 0.0 - SimpleHatsConfigAbstract.hatYOffset(), 0.0);
            boolean bl = flag = livingEntity instanceof Villager || livingEntity instanceof ZombieVillager;
            if (livingEntity.isBaby() && !(livingEntity instanceof Villager)) {
                poseStack.translate(0.0f, 0.03125f, 0.0f);
                poseStack.scale(0.7f, 0.7f, 0.7f);
                poseStack.translate(0.0f, 1.0f, 0.0f);
            }
            ((HeadedModel)this.getParentModel()).getHead().translateAndRotate(poseStack);
            HatLayer.translateToHead(poseStack, flag);
            Minecraft.getInstance().getEntityRenderDispatcher().getItemInHandRenderer().renderItem(livingEntity, itemStack, ItemDisplayContext.HEAD, false, poseStack, buffer, packedLight);
            poseStack.popPose();
        }
        if (livingEntity instanceof Player && (particleSettings = ((HatItem)itemStack.getItem()).getHatEntry().getHatParticleSettings()).getUseParticles() && !Minecraft.getInstance().isPaused()) {
            float f = livingEntity.getRandom().nextFloat();
            float f2 = livingEntity.isInvisible() ? particleSettings.getParticleFrequency() / 2.0f : particleSettings.getParticleFrequency();
            if (f < f2) {
                double d0 = livingEntity.getRandom().nextGaussian() * 0.02;
                double d1 = livingEntity.getRandom().nextGaussian() * 0.02;
                double d2 = livingEntity.getRandom().nextGaussian() * 0.02;
                double y = switch (particleSettings.getParticleMovement()) {
                    default -> throw new MatchException(null, null);
                    case HatEntry.HatParticleSettings.HatParticleMovement.TRAILING_HEAD -> livingEntity.getY() + 1.75;
                    case HatEntry.HatParticleSettings.HatParticleMovement.TRAILING_FEET -> livingEntity.getY() + 0.25;
                    case HatEntry.HatParticleSettings.HatParticleMovement.TRAILING_FULL -> livingEntity.getRandomY();
                };
                ParticleType<?> particleType = particleSettings.getParticleType();
                if (particleType instanceof SimpleParticleType) {
                    SimpleParticleType particleEffect = (SimpleParticleType)particleType;
                    livingEntity.level().addParticle((ParticleOptions)particleEffect, livingEntity.getX() + (double)livingEntity.getRandom().nextFloat() - 0.5, y, livingEntity.getZ() + (double)livingEntity.getRandom().nextFloat() - 0.5, d0, d1, d2);
                } else if (particleType == ParticleTypes.ENTITY_EFFECT) {
                    livingEntity.level().addParticle((ParticleOptions)ColorParticleOption.create((ParticleType)ParticleTypes.ENTITY_EFFECT, (float)livingEntity.getRandom().nextFloat(), (float)livingEntity.getRandom().nextFloat(), (float)livingEntity.getRandom().nextFloat()), livingEntity.getX() + (double)livingEntity.getRandom().nextFloat() - 0.5, y, livingEntity.getZ() + (double)livingEntity.getRandom().nextFloat() - 0.5, d0, d1, d2);
                }
            }
        }
    }

    private static void translateToHead(PoseStack pPoseStack, boolean pIsVillager) {
        pPoseStack.translate(0.0f, -0.25f, 0.0f);
        pPoseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
        pPoseStack.scale(0.625f, -0.625f, -0.625f);
        if (pIsVillager) {
            pPoseStack.translate(0.0f, 0.1875f, 0.0f);
        }
    }
}

