/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.api.animation.property;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import yesman.epicfight.api.animation.AnimationPlayer;
import yesman.epicfight.api.animation.AnimationVariables;
import yesman.epicfight.api.animation.Animator;
import yesman.epicfight.api.animation.JointTransform;
import yesman.epicfight.api.animation.Keyframe;
import yesman.epicfight.api.animation.TransformSheet;
import yesman.epicfight.api.animation.property.AnimationProperty;
import yesman.epicfight.api.animation.types.ActionAnimation;
import yesman.epicfight.api.animation.types.AttackAnimation;
import yesman.epicfight.api.animation.types.DynamicAnimation;
import yesman.epicfight.api.animation.types.EntityState;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.utils.math.MathUtils;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.api.utils.math.Vec3f;
import yesman.epicfight.api.utils.math.Vec4f;
import yesman.epicfight.registry.entries.EpicFightSynchedAnimationVariableKeys;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.MobPatch;

public class MoveCoordFunctions {
    public static final MoveCoordGetter MODEL_COORD = (animation, entitypatch, coord, prevElapsedTime, elapsedTime) -> {
        LivingEntity livingentity = (LivingEntity)entitypatch.getOriginal();
        JointTransform oJt = coord.getInterpolatedTransform(prevElapsedTime);
        JointTransform jt = coord.getInterpolatedTransform(elapsedTime);
        Vec4f prevpos = new Vec4f(oJt.translation());
        Vec4f currentpos = new Vec4f(jt.translation());
        OpenMatrix4f rotationTransform = entitypatch.getModelMatrix(1.0f).removeTranslation().removeScale();
        OpenMatrix4f localTransform = entitypatch.getArmature().searchJointByName("Root").getLocalTransform().removeTranslation();
        rotationTransform.mulBack(localTransform);
        currentpos.transform(rotationTransform);
        prevpos.transform(rotationTransform);
        boolean hasNoGravity = ((LivingEntity)entitypatch.getOriginal()).isNoGravity();
        boolean moveVertical = animation.getProperty(AnimationProperty.ActionAnimationProperty.MOVE_VERTICAL).orElse(false) != false || animation.getProperty(AnimationProperty.ActionAnimationProperty.COORD).isPresent();
        float dx = prevpos.x - currentpos.x;
        float dy = moveVertical || hasNoGravity ? currentpos.y - prevpos.y : 0.0f;
        float dz = prevpos.z - currentpos.z;
        dx = Math.abs(dx) > 1.0E-4f ? dx : 0.0f;
        dz = Math.abs(dz) > 1.0E-4f ? dz : 0.0f;
        BlockPos.MutableBlockPos blockpos = new BlockPos.MutableBlockPos(livingentity.getX(), livingentity.getBoundingBox().minY - 1.0, livingentity.getZ());
        BlockState blockState = livingentity.level().getBlockState((BlockPos)blockpos);
        AttributeInstance movementSpeed = livingentity.getAttribute(Attributes.MOVEMENT_SPEED);
        boolean soulboost = blockState.is(BlockTags.SOUL_SPEED_BLOCKS) && EnchantmentHelper.getEnchantmentLevel((Holder)livingentity.level().holderOrThrow(Enchantments.SOUL_SPEED), (LivingEntity)livingentity) > 0;
        float speedFactor = (float)(soulboost ? 1.0 : (double)livingentity.level().getBlockState((BlockPos)blockpos).getBlock().getSpeedFactor());
        float moveMultiplier = (float)(animation.getProperty(AnimationProperty.ActionAnimationProperty.AFFECT_SPEED).orElse(false) != false ? movementSpeed.getValue() / movementSpeed.getBaseValue() : 1.0);
        return new Vec3f(dx * moveMultiplier * speedFactor, dy, dz * moveMultiplier * speedFactor);
    };
    public static final MoveCoordGetter WORLD_COORD = (animation, entitypatch, coord, prevElapsedTime, elapsedTime) -> {
        JointTransform jt = coord.getInterpolatedTransform(elapsedTime);
        Vec3 entityPos = ((LivingEntity)entitypatch.getOriginal()).position();
        return jt.translation().copy().sub(Vec3f.fromDoubleVector(entityPos));
    };
    public static final MoveCoordGetter ATTACHED = (animation, entitypatch, coord, prevElapsedTime, elapsedTime) -> {
        LivingEntity target = entitypatch.getGrapplingTarget();
        if (target == null) {
            return MODEL_COORD.get(animation, entitypatch, coord, prevElapsedTime, elapsedTime);
        }
        TransformSheet rootCoord = animation.getCoord();
        LivingEntity livingentity = (LivingEntity)entitypatch.getOriginal();
        Vec3f model = rootCoord.getInterpolatedTransform(elapsedTime).translation();
        Vec3f world = OpenMatrix4f.transform3v(OpenMatrix4f.createRotatorDeg(-target.getYRot(), Vec3f.Y_AXIS), model, null);
        Vec3f dst = Vec3f.fromDoubleVector(target.position()).add(world);
        entitypatch.setYRot(Mth.wrapDegrees((float)(target.getYRot() + 180.0f)));
        return dst.sub(Vec3f.fromDoubleVector(livingentity.position()));
    };
    public static final AnimationProperty.DestLocationProvider NO_DEST = (self, entitypatch) -> null;
    public static final AnimationProperty.DestLocationProvider ATTACK_TARGET_LOCATION = (self, entitypatch) -> entitypatch.getTarget() == null ? null : entitypatch.getTarget().position();
    public static final AnimationProperty.DestLocationProvider SYNCHED_DEST_VARIABLE = (self, entitypatch) -> (Vec3)((Animator)entitypatch.getAnimator()).getVariables().getOrDefault((AnimationVariables.IndependentVariableKey)EpicFightSynchedAnimationVariableKeys.DESTINATION.get(), self.getRealAnimation());
    public static final AnimationProperty.DestLocationProvider SYNCHED_TARGET_ENTITY_LOCATION_VARIABLE = (self, entitypatch) -> {
        Entity entity;
        Optional targetEntityId = ((Animator)entitypatch.getAnimator()).getVariables().get((AnimationVariables.IndependentVariableKey)EpicFightSynchedAnimationVariableKeys.TARGET_ENTITY.get(), self.getRealAnimation());
        if (targetEntityId.isPresent() && (entity = ((LivingEntity)entitypatch.getOriginal()).level().getEntity(((Integer)targetEntityId.get()).intValue())) != null) {
            return entity.position();
        }
        return ((LivingEntity)entitypatch.getOriginal()).position();
    };
    public static final AnimationProperty.YRotProvider LOOK_DEST = (self, entitypatch) -> {
        Vec3 destLocation = self.getRealAnimation().get().getProperty(AnimationProperty.ActionAnimationProperty.DEST_LOCATION_PROVIDER).orElse(NO_DEST).get(self, entitypatch);
        if (destLocation != null) {
            Vec3 startInWorld = ((Animator)entitypatch.getAnimator()).getVariables().getOrDefault(ActionAnimation.BEGINNING_LOCATION, self.getRealAnimation());
            if (startInWorld == null) {
                startInWorld = ((LivingEntity)entitypatch.getOriginal()).position();
            }
            Vec3 toDestWorld = destLocation.subtract(startInWorld);
            float yRot = (float)Mth.wrapDegrees((double)MathUtils.getYRotOfVector(toDestWorld));
            float entityYRot = MathUtils.rotlerp(entitypatch.getYRot(), yRot, entitypatch.getYRotLimit());
            return entityYRot;
        }
        return entitypatch.getYRot();
    };
    public static final AnimationProperty.YRotProvider MOB_ATTACK_TARGET_LOOK = (self, entitypatch) -> {
        if (!entitypatch.isLogicalClient() && entitypatch instanceof MobPatch) {
            MobPatch mobpatch = (MobPatch)entitypatch;
            AnimationPlayer player = ((Animator)entitypatch.getAnimator()).getPlayerFor(self.getAccessor());
            float elapsedTime = player.getElapsedTime();
            EntityState state = self.getState(entitypatch, elapsedTime);
            if (state.getLevel() == 1 && !state.turningLocked()) {
                ((Mob)mobpatch.getOriginal()).getNavigation().stop();
                ((LivingEntity)entitypatch.getOriginal()).attackAnim = 2.0f;
                LivingEntity target = entitypatch.getTarget();
                if (target != null) {
                    float currentYRot = Mth.wrapDegrees((float)((LivingEntity)entitypatch.getOriginal()).getYRot());
                    float clampedYRot = entitypatch.getYRotDeltaTo((Entity)target);
                    return currentYRot + clampedYRot;
                }
            }
        }
        return entitypatch.getYRot();
    };
    public static final MoveCoordSetter RAW_COORD = (self, entitypatch, transformSheet) -> transformSheet.readFrom(self.getCoord().copyAll());
    public static final MoveCoordSetter RAW_COORD_WITH_X_ROT = (self, entitypatch, transformSheet) -> {
        TransformSheet sheet = self.getCoord().copyAll();
        float xRot = ((LivingEntity)entitypatch.getOriginal()).getXRot();
        for (Keyframe kf : sheet.getKeyframes()) {
            kf.transform().translation().rotate(-xRot, Vec3f.X_AXIS);
        }
        transformSheet.readFrom(sheet);
    };
    public static final MoveCoordSetter TRACE_ORIGIN_AS_DESTINATION = (self, entitypatch, transformSheet) -> {
        Vec3 startInWorld;
        if (self.isLinkAnimation()) {
            transformSheet.readFrom(TransformSheet.EMPTY_SHEET_PROVIDER.apply(((LivingEntity)entitypatch.getOriginal()).position()));
            return;
        }
        Keyframe[] coordKeyframes = self.getCoord().getKeyframes();
        int startFrame = self.getRealAnimation().get().getProperty(AnimationProperty.ActionAnimationProperty.COORD_START_KEYFRAME_INDEX).orElse(0);
        int destFrame = self.getRealAnimation().get().getProperty(AnimationProperty.ActionAnimationProperty.COORD_DEST_KEYFRAME_INDEX).orElse(coordKeyframes.length - 1);
        Vec3 destInWorld = self.getRealAnimation().get().getProperty(AnimationProperty.ActionAnimationProperty.DEST_LOCATION_PROVIDER).orElse(NO_DEST).get(self, entitypatch);
        if (destInWorld == null) {
            Vec3f beginningPosition = coordKeyframes[0].transform().translation().copy().multiply(1.0f, 1.0f, -1.0f);
            beginningPosition.rotate(-entitypatch.getYRot(), Vec3f.Y_AXIS);
            destInWorld = ((LivingEntity)entitypatch.getOriginal()).position().add((double)(-beginningPosition.x), (double)(-beginningPosition.y), (double)(-beginningPosition.z));
        }
        if ((startInWorld = ((Animator)entitypatch.getAnimator()).getVariables().getOrDefault(ActionAnimation.BEGINNING_LOCATION, self.getRealAnimation())) == null) {
            startInWorld = ((LivingEntity)entitypatch.getOriginal()).position();
        }
        Vec3 toTargetInWorld = destInWorld.subtract(startInWorld);
        float yRot = (float)Mth.wrapDegrees((double)MathUtils.getYRotOfVector(toTargetInWorld));
        Optional<AnimationProperty.YRotProvider> destYRotProvider = self.getRealAnimation().get().getProperty(AnimationProperty.ActionAnimationProperty.DEST_COORD_YROT_PROVIDER);
        float destYRot = destYRotProvider.isEmpty() ? yRot : destYRotProvider.get().get(self, entitypatch);
        TransformSheet result = self.getCoord().transformToWorldCoordOriginAsDest(entitypatch, startInWorld, destInWorld, yRot, destYRot, startFrame, destFrame);
        transformSheet.readFrom(result);
    };
    public static final MoveCoordSetter TRACE_TARGET_DISTANCE = (self, entitypatch, transformSheet) -> {
        Vec3 destLocation = self.getRealAnimation().get().getProperty(AnimationProperty.ActionAnimationProperty.DEST_LOCATION_PROVIDER).orElse(NO_DEST).get(self, entitypatch);
        if (destLocation != null) {
            TransformSheet transform = self.getCoord().copyAll();
            Keyframe[] coord = transform.getKeyframes();
            Keyframe[] realAnimationCoord = self.getRealAnimation().get().getCoord().getKeyframes();
            Vec3 startInWorld = ((Animator)entitypatch.getAnimator()).getVariables().getOrDefault(ActionAnimation.BEGINNING_LOCATION, self.getRealAnimation());
            if (startInWorld == null) {
                startInWorld = ((LivingEntity)entitypatch.getOriginal()).position();
            }
            int startFrame = self.getRealAnimation().get().getProperty(AnimationProperty.ActionAnimationProperty.COORD_START_KEYFRAME_INDEX).orElse(0);
            int realAnimationEndFrame = self.getRealAnimation().get().getProperty(AnimationProperty.ActionAnimationProperty.COORD_DEST_KEYFRAME_INDEX).orElse(self.getRealAnimation().get().getCoord().getKeyframes().length - 1);
            Vec3 toDestWorld = destLocation.subtract(startInWorld);
            Vec3f toDestAnim = realAnimationCoord[realAnimationEndFrame].transform().translation();
            LivingEntity attackTarget = entitypatch.getTarget();
            float entityRadius = 0.0f;
            if (attackTarget != null) {
                float reach = 0.0f;
                StaticAnimation patt0$temp = self.getRealAnimation().get();
                if (patt0$temp instanceof AttackAnimation) {
                    AttackAnimation attackAnimation = (AttackAnimation)patt0$temp;
                    Optional<Float> reachOpt = attackAnimation.getProperty(AnimationProperty.AttackAnimationProperty.REACH);
                    if (reachOpt.isPresent()) {
                        reach = reachOpt.get().floatValue();
                    } else {
                        AnimationPlayer player = ((Animator)entitypatch.getAnimator()).getPlayerFor(self.getAccessor());
                        if (player != null) {
                            AttackAnimation.Phase phase = attackAnimation.getPhaseByTime(player.getElapsedTime());
                            reach = entitypatch.getReach(phase.hand);
                        }
                    }
                }
                entityRadius = (attackTarget.getBbWidth() + ((LivingEntity)entitypatch.getOriginal()).getBbWidth()) * 0.7f + reach;
            }
            float worldLength = Math.max((float)toDestWorld.length() - entityRadius, 0.0f);
            float animLength = toDestAnim.length();
            float dot = ((Animator)entitypatch.getAnimator()).getVariables().getOrDefault(ActionAnimation.INITIAL_LOOK_VEC_DOT, self.getRealAnimation()).floatValue();
            float lookLength = Mth.lerp((float)dot, (float)animLength, (float)worldLength);
            float scale = Math.min(lookLength / animLength, 1.0f);
            if (self.isLinkAnimation()) {
                scale *= coord[coord.length - 1].transform().translation().length() / animLength;
            }
            int endFrame = self.getRealAnimation().get().getProperty(AnimationProperty.ActionAnimationProperty.COORD_DEST_KEYFRAME_INDEX).orElse(coord.length - 1);
            for (int i = startFrame; i <= endFrame; ++i) {
                Vec3f translation = coord[i].transform().translation();
                translation.x *= scale;
                if (!(translation.z < 0.0f)) continue;
                translation.z *= scale;
            }
            transformSheet.readFrom(transform);
        } else {
            transformSheet.readFrom(self.getCoord().copyAll());
        }
    };
    public static final MoveCoordSetter TRACE_TARGET_LOCATION_ROTATION = (self, entitypatch, transformSheet) -> {
        Vec3 destLocation = self.getRealAnimation().get().getProperty(AnimationProperty.ActionAnimationProperty.DEST_LOCATION_PROVIDER).orElse(NO_DEST).get(self, entitypatch);
        if (destLocation != null) {
            TransformSheet transform = self.getCoord().copyAll();
            Keyframe[] coord = transform.getKeyframes();
            Keyframe[] realAnimationCoord = self.getRealAnimation().get().getCoord().getKeyframes();
            Vec3 startInWorld = ((Animator)entitypatch.getAnimator()).getVariables().getOrDefault(ActionAnimation.BEGINNING_LOCATION, self.getRealAnimation());
            if (startInWorld == null) {
                startInWorld = ((LivingEntity)entitypatch.getOriginal()).position();
            }
            int startFrame = self.getRealAnimation().get().getProperty(AnimationProperty.ActionAnimationProperty.COORD_START_KEYFRAME_INDEX).orElse(0);
            int endFrame = self.isLinkAnimation() ? coord.length - 1 : self.getRealAnimation().get().getProperty(AnimationProperty.ActionAnimationProperty.COORD_DEST_KEYFRAME_INDEX).orElse(coord.length - 1);
            Vec3 toDestWorld = destLocation.subtract(startInWorld);
            Vec3f toDestAnim = realAnimationCoord[endFrame].transform().translation();
            LivingEntity attackTarget = entitypatch.getTarget();
            float entityRadius = 0.0f;
            if (attackTarget != null) {
                float reach = 0.0f;
                StaticAnimation patt0$temp = self.getRealAnimation().get();
                if (patt0$temp instanceof AttackAnimation) {
                    AttackAnimation attackAnimation = (AttackAnimation)patt0$temp;
                    Optional<Float> reachOpt = attackAnimation.getProperty(AnimationProperty.AttackAnimationProperty.REACH);
                    if (reachOpt.isPresent()) {
                        reach = reachOpt.get().floatValue();
                    } else {
                        AnimationPlayer player = ((Animator)entitypatch.getAnimator()).getPlayerFor(self.getAccessor());
                        if (player != null) {
                            AttackAnimation.Phase phase = attackAnimation.getPhaseByTime(player.getElapsedTime());
                            reach = entitypatch.getReach(phase.hand);
                        }
                    }
                }
                entityRadius = (attackTarget.getBbWidth() + ((LivingEntity)entitypatch.getOriginal()).getBbWidth()) * 0.7f + reach;
            }
            float worldLength = Math.max((float)toDestWorld.length() - entityRadius, 0.0f);
            float animLength = toDestAnim.length();
            float scale = Math.min(worldLength / animLength, 1.0f);
            if (self.isLinkAnimation()) {
                scale *= coord[endFrame].transform().translation().length() / animLength;
            }
            for (int i = startFrame; i <= endFrame; ++i) {
                Vec3f translation = coord[i].transform().translation();
                translation.x *= scale;
                if (!(translation.z < 0.0f)) continue;
                translation.z *= scale;
            }
            transformSheet.readFrom(transform);
        } else {
            transformSheet.readFrom(self.getCoord().copyAll());
        }
    };
    public static final MoveCoordSetter VEX_TRACE = (self, entitypatch, transformSheet) -> {
        if (!self.isLinkAnimation()) {
            TransformSheet transform = self.getCoord().copyAll();
            if (entitypatch.getTarget() != null) {
                Keyframe[] keyframes = transform.getKeyframes();
                Vec3 pos = ((LivingEntity)entitypatch.getOriginal()).position();
                Vec3 targetpos = entitypatch.getTarget().getEyePosition();
                double flyDistance = Math.max(5.0, targetpos.subtract(pos).length() * 2.0);
                transform.forEach((index, keyframe) -> keyframe.transform().translation().scale((float)(flyDistance / (double)Math.abs(keyframes[keyframes.length - 1].transform().translation().z))));
                Vec3 toTarget = targetpos.subtract(pos);
                float xRot = (float)(-MathUtils.getXRotOfVector(toTarget));
                float yRot = (float)MathUtils.getYRotOfVector(toTarget);
                entitypatch.setYRot(yRot);
                transform.forEach((index, keyframe) -> {
                    keyframe.transform().translation().rotateDegree(Vec3f.X_AXIS, xRot);
                    keyframe.transform().translation().rotateDegree(Vec3f.Y_AXIS, 180.0f - yRot);
                    keyframe.transform().translation().add(((LivingEntity)entitypatch.getOriginal()).position());
                });
                transformSheet.readFrom(transform);
            } else {
                transform.forEach((index, keyframe) -> {
                    keyframe.transform().translation().rotateDegree(Vec3f.Y_AXIS, 180.0f - entitypatch.getYRot());
                    keyframe.transform().translation().add(((LivingEntity)entitypatch.getOriginal()).position());
                });
            }
        }
    };

    @FunctionalInterface
    public static interface MoveCoordGetter {
        public Vec3f get(DynamicAnimation var1, LivingEntityPatch<?> var2, TransformSheet var3, float var4, float var5);
    }

    @FunctionalInterface
    public static interface MoveCoordSetter {
        public void set(DynamicAnimation var1, LivingEntityPatch<?> var2, TransformSheet var3);
    }
}

