/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.api.animation.types;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import yesman.epicfight.api.animation.types.EntityState;
import yesman.epicfight.api.utils.datastructure.ParameterizedHashMap;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;

public class StateSpectrum {
    private final Set<StatesInTime> timePairs = Sets.newHashSet();

    void readFrom(Blueprint blueprint) {
        this.timePairs.clear();
        this.timePairs.addAll(blueprint.timePairs);
    }

    public <T> T getSingleState(EntityState.StateFactor<T> stateFactor, LivingEntityPatch<?> entitypatch, float time) {
        for (StatesInTime state : this.timePairs) {
            if (!state.isIn(entitypatch, time)) continue;
            for (Map.Entry<EntityState.StateFactor<?>, Object> timeEntry : state.getStates(entitypatch)) {
                if (timeEntry.getKey() != stateFactor) continue;
                return (T)timeEntry.getValue();
            }
        }
        return stateFactor.defaultValue();
    }

    public ParameterizedHashMap<EntityState.StateFactor<?>> getStateMap(LivingEntityPatch<?> entitypatch, float time) {
        ParameterizedHashMap stateMap = new ParameterizedHashMap();
        for (StatesInTime state : this.timePairs) {
            if (!state.isIn(entitypatch, time)) continue;
            for (Map.Entry<EntityState.StateFactor<?>, Object> timeEntry : state.getStates(entitypatch)) {
                stateMap.put(timeEntry.getKey(), timeEntry.getValue());
            }
        }
        return stateMap;
    }

    public static class Blueprint {
        StatesInTime currentState;
        Set<StatesInTime> timePairs = Sets.newHashSet();

        public Blueprint newTimePair(float start, float end) {
            this.currentState = new SimpleStatesInTime(start, end);
            this.timePairs.add(this.currentState);
            return this;
        }

        public Blueprint newConditionalTimePair(Function<LivingEntityPatch<?>, Integer> condition, float start, float end) {
            this.currentState = new ConditionalStatesInTime(condition, start, end);
            this.timePairs.add(this.currentState);
            return this;
        }

        public Blueprint newVariableTimePair(Function<LivingEntityPatch<?>, Float> variableStart, Function<LivingEntityPatch<?>, Float> variableEnd) {
            this.currentState = new VariableStatesInTime(variableStart, variableEnd);
            this.timePairs.add(this.currentState);
            return this;
        }

        public <T> Blueprint addState(EntityState.StateFactor<T> factor, T val) {
            StatesInTime statesInTime = this.currentState;
            if (statesInTime instanceof SimpleStatesInTime) {
                SimpleStatesInTime simpleState = (SimpleStatesInTime)statesInTime;
                simpleState.addState(factor, val);
            }
            if ((statesInTime = this.currentState) instanceof VariableStatesInTime) {
                VariableStatesInTime variableState = (VariableStatesInTime)statesInTime;
                variableState.addState(factor, val);
            }
            return this;
        }

        public <T> Blueprint addConditionalState(int metadata, EntityState.StateFactor<T> factor, T val) {
            StatesInTime statesInTime = this.currentState;
            if (statesInTime instanceof ConditionalStatesInTime) {
                ConditionalStatesInTime conditionalState = (ConditionalStatesInTime)statesInTime;
                conditionalState.addConditionalState(metadata, factor, val);
            }
            return this;
        }

        public <T> Blueprint removeState(EntityState.StateFactor<T> factor) {
            for (StatesInTime timePair : this.timePairs) {
                timePair.removeState(factor);
            }
            return this;
        }

        public <T> Blueprint addStateRemoveOld(EntityState.StateFactor<T> factor, T val) {
            this.removeState(factor);
            return this.addState(factor, val);
        }

        public <T> Blueprint addStateIfNotExist(EntityState.StateFactor<T> factor, T val) {
            for (StatesInTime timePair : this.timePairs) {
                if (!timePair.hasState(factor)) continue;
                return this;
            }
            return this.addState(factor, val);
        }

        public Blueprint clear() {
            this.currentState = null;
            this.timePairs.clear();
            return this;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            for (StatesInTime state : this.timePairs) {
                sb.append(String.valueOf(state) + "\n");
            }
            return sb.toString();
        }
    }

    static abstract class StatesInTime {
        StatesInTime() {
        }

        public abstract Set<Map.Entry<EntityState.StateFactor<?>, Object>> getStates(LivingEntityPatch<?> var1);

        public abstract void removeState(EntityState.StateFactor<?> var1);

        public abstract boolean hasState(EntityState.StateFactor<?> var1);

        public abstract boolean isIn(LivingEntityPatch<?> var1, float var2);
    }

    static class VariableStatesInTime
    extends StatesInTime {
        Function<LivingEntityPatch<?>, Float> variableStart;
        Function<LivingEntityPatch<?>, Float> variableEnd;
        Map<EntityState.StateFactor<?>, Object> states = Maps.newHashMap();

        public VariableStatesInTime(Function<LivingEntityPatch<?>, Float> variableStart, Function<LivingEntityPatch<?>, Float> variableEnd) {
            this.variableStart = variableStart;
            this.variableEnd = variableEnd;
        }

        @Override
        public boolean isIn(LivingEntityPatch<?> entitypatch, float time) {
            return this.variableStart.apply(entitypatch).floatValue() <= time && this.variableEnd.apply(entitypatch).floatValue() > time;
        }

        public <T> StatesInTime addState(EntityState.StateFactor<T> factor, T val) {
            this.states.put(factor, val);
            return this;
        }

        @Override
        public Set<Map.Entry<EntityState.StateFactor<?>, Object>> getStates(LivingEntityPatch<?> entitypatch) {
            return this.states.entrySet();
        }

        @Override
        public boolean hasState(EntityState.StateFactor<?> state) {
            return this.states.containsKey(state);
        }

        @Override
        public void removeState(EntityState.StateFactor<?> state) {
            this.states.remove(state);
        }

        public String toString() {
            return String.format("States: %s", this.states);
        }
    }

    static class ConditionalStatesInTime
    extends StatesInTime {
        float start;
        float end;
        Int2ObjectMap<Map<EntityState.StateFactor<?>, Object>> conditionalStates = new Int2ObjectOpenHashMap();
        Function<LivingEntityPatch<?>, Integer> condition;

        public ConditionalStatesInTime(Function<LivingEntityPatch<?>, Integer> condition, float start, float end) {
            this.start = start;
            this.end = end;
            this.condition = condition;
        }

        public <T> StatesInTime addConditionalState(int metadata, EntityState.StateFactor<T> factor, T val) {
            Map states = (Map)this.conditionalStates.computeIfAbsent(metadata, key -> Maps.newHashMap());
            states.put(factor, val);
            return this;
        }

        @Override
        public Set<Map.Entry<EntityState.StateFactor<?>, Object>> getStates(LivingEntityPatch<?> entitypatch) {
            return ((Map)this.conditionalStates.get((Object)this.condition.apply(entitypatch))).entrySet();
        }

        @Override
        public boolean isIn(LivingEntityPatch<?> entitypatch, float time) {
            return this.start <= time && this.end > time;
        }

        @Override
        public boolean hasState(EntityState.StateFactor<?> state) {
            boolean hasState = false;
            for (Map states : this.conditionalStates.values()) {
                hasState |= states.containsKey(state);
            }
            return hasState;
        }

        @Override
        public void removeState(EntityState.StateFactor<?> state) {
            for (Map states : this.conditionalStates.values()) {
                states.remove(state);
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(String.format("Time: %.2f ~ %.2f, ", Float.valueOf(this.start), Float.valueOf(this.end)));
            int entryCnt = 0;
            for (Map.Entry entry : this.conditionalStates.entrySet()) {
                sb.append(String.format("States %d: %s", entry.getKey(), entry.getValue()));
                if (++entryCnt >= this.conditionalStates.size()) continue;
                sb.append(", ");
            }
            return sb.toString();
        }
    }

    static class SimpleStatesInTime
    extends StatesInTime {
        float start;
        float end;
        Map<EntityState.StateFactor<?>, Object> states = Maps.newHashMap();

        public SimpleStatesInTime(float start, float end) {
            this.start = start;
            this.end = end;
        }

        @Override
        public boolean isIn(LivingEntityPatch<?> entitypatch, float time) {
            return this.start <= time && this.end > time;
        }

        public <T> StatesInTime addState(EntityState.StateFactor<T> factor, T val) {
            this.states.put(factor, val);
            return this;
        }

        @Override
        public Set<Map.Entry<EntityState.StateFactor<?>, Object>> getStates(LivingEntityPatch<?> entitypatch) {
            return this.states.entrySet();
        }

        @Override
        public boolean hasState(EntityState.StateFactor<?> state) {
            return this.states.containsKey(state);
        }

        @Override
        public void removeState(EntityState.StateFactor<?> state) {
            this.states.remove(state);
        }

        public String toString() {
            return String.format("Time: %.2f ~ %.2f, States: %s", Float.valueOf(this.start), Float.valueOf(this.end), this.states);
        }
    }
}

