/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.api.client.input.action;

import java.util.Optional;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import org.jetbrains.annotations.NotNull;
import yesman.epicfight.api.client.input.action.InputAction;
import yesman.epicfight.api.client.input.controller.ControllerBinding;
import yesman.epicfight.api.client.input.controller.EpicFightControllerModProvider;
import yesman.epicfight.compat.controlify.EpicFightControlifyControllerMod;

public enum MinecraftInputAction implements InputAction
{
    JUMP,
    ATTACK_DESTROY,
    USE,
    SWAP_OFF_HAND,
    DROP,
    TOGGLE_PERSPECTIVE,
    MOVE_FORWARD,
    MOVE_BACKWARD,
    MOVE_LEFT,
    MOVE_RIGHT,
    SPRINT,
    SNEAK;

    private final int id = InputAction.ENUM_MANAGER.assign(this);

    @Override
    @NotNull
    public KeyMapping keyMapping() {
        Options options = Minecraft.getInstance().options;
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 2 -> options.keyUse;
            case 1 -> options.keyAttack;
            case 3 -> options.keySwapOffhand;
            case 4 -> options.keyDrop;
            case 5 -> options.keyTogglePerspective;
            case 0 -> options.keyJump;
            case 6 -> options.keyUp;
            case 7 -> options.keyDown;
            case 8 -> options.keyLeft;
            case 9 -> options.keyRight;
            case 10 -> options.keySprint;
            case 11 -> options.keyShift;
        };
    }

    @Override
    @NotNull
    public @NotNull Optional<@NotNull ControllerBinding> controllerBinding() {
        if (EpicFightControllerModProvider.get() == null) {
            throw new IllegalStateException("controllerBinding() must not be called when the controller mod is not installed");
        }
        return Optional.of(EpicFightControlifyControllerMod.getBinding(this));
    }

    @Override
    public boolean isVanilla() {
        return true;
    }

    @Override
    public int universalOrdinal() {
        return this.id;
    }
}

