/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.api.client.model;

import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.floats.FloatArrayList;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import yesman.epicfight.api.client.model.MeshPartDefinition;
import yesman.epicfight.api.client.model.SkinnedMesh;
import yesman.epicfight.api.client.model.VertexBuilder;
import yesman.epicfight.api.utils.math.Vec2f;
import yesman.epicfight.api.utils.math.Vec3f;

public class SingleGroupVertexBuilder {
    private Vec3f position;
    private Vec3f normal;
    private Vec2f textureCoordinate;
    private Vec3f effectiveJointIDs;
    private Vec3f effectiveJointWeights;
    private int effectiveJointNumber;

    public SingleGroupVertexBuilder() {
        this.position = null;
        this.normal = null;
        this.textureCoordinate = null;
    }

    public SingleGroupVertexBuilder(SingleGroupVertexBuilder vertex) {
        this.position = vertex.position;
        this.effectiveJointIDs = vertex.effectiveJointIDs;
        this.effectiveJointWeights = vertex.effectiveJointWeights;
        this.effectiveJointNumber = vertex.effectiveJointNumber;
    }

    public SingleGroupVertexBuilder setPosition(Vec3f position) {
        this.position = position;
        return this;
    }

    public SingleGroupVertexBuilder setNormal(Vec3f vector) {
        this.normal = vector;
        return this;
    }

    public SingleGroupVertexBuilder setTextureCoordinate(Vec2f vector) {
        this.textureCoordinate = vector;
        return this;
    }

    public SingleGroupVertexBuilder setEffectiveJointIDs(Vec3f effectiveJointIDs) {
        this.effectiveJointIDs = effectiveJointIDs;
        return this;
    }

    public SingleGroupVertexBuilder setEffectiveJointWeights(Vec3f effectiveJointWeights) {
        this.effectiveJointWeights = effectiveJointWeights;
        return this;
    }

    public SingleGroupVertexBuilder setEffectiveJointNumber(int count) {
        this.effectiveJointNumber = count;
        return this;
    }

    public State compareTextureCoordinateAndNormal(Vec3f normal, Vec2f textureCoord) {
        if (this.textureCoordinate == null) {
            return State.EMPTY;
        }
        if (this.textureCoordinate.equals(textureCoord) && this.normal.equals(normal)) {
            return State.EQUAL;
        }
        return State.DIFFERENT;
    }

    public static SkinnedMesh loadVertexInformation(List<SingleGroupVertexBuilder> vertices, Map<MeshPartDefinition, IntList> indices) {
        FloatArrayList positions = new FloatArrayList();
        FloatArrayList normals = new FloatArrayList();
        FloatArrayList texCoords = new FloatArrayList();
        IntArrayList animationIndices = new IntArrayList();
        FloatArrayList jointWeights = new FloatArrayList();
        IntArrayList affectCountList = new IntArrayList();
        for (int i = 0; i < vertices.size(); ++i) {
            SingleGroupVertexBuilder vertex = vertices.get(i);
            Vec3f position = vertex.position;
            Vec3f normal = vertex.normal;
            Vec2f texCoord = vertex.textureCoordinate;
            positions.add(position.x);
            positions.add(position.y);
            positions.add(position.z);
            normals.add(normal.x);
            normals.add(normal.y);
            normals.add(normal.z);
            texCoords.add(texCoord.x);
            texCoords.add(texCoord.y);
            Vec3f effectIDs = vertex.effectiveJointIDs;
            Vec3f weights = vertex.effectiveJointWeights;
            int count = Math.min(vertex.effectiveJointNumber, 3);
            affectCountList.add(count);
            block6: for (int j = 0; j < count; ++j) {
                switch (j) {
                    case 0: {
                        animationIndices.add((int)effectIDs.x);
                        jointWeights.add(weights.x);
                        animationIndices.add(jointWeights.size() - 1);
                        continue block6;
                    }
                    case 1: {
                        animationIndices.add((int)effectIDs.y);
                        jointWeights.add(weights.y);
                        animationIndices.add(jointWeights.size() - 1);
                        continue block6;
                    }
                    case 2: {
                        animationIndices.add((int)effectIDs.z);
                        jointWeights.add(weights.z);
                        animationIndices.add(jointWeights.size() - 1);
                        continue block6;
                    }
                }
            }
        }
        Float[] positionList = (Float[])positions.toArray((Object[])new Float[0]);
        Float[] normalList = (Float[])normals.toArray((Object[])new Float[0]);
        Float[] texCoordList = (Float[])texCoords.toArray((Object[])new Float[0]);
        Integer[] affectingJointIndices = (Integer[])animationIndices.toArray((Object[])new Integer[0]);
        Float[] jointWeightList = (Float[])jointWeights.toArray((Object[])new Float[0]);
        Integer[] affectJointCounts = (Integer[])affectCountList.toArray((Object[])new Integer[0]);
        HashMap arrayMap = Maps.newHashMap();
        HashMap meshDefinitions = Maps.newHashMap();
        arrayMap.put("positions", positionList);
        arrayMap.put("normals", normalList);
        arrayMap.put("uvs", texCoordList);
        arrayMap.put("weights", jointWeightList);
        arrayMap.put("vcounts", affectJointCounts);
        arrayMap.put("vindices", affectingJointIndices);
        for (Map.Entry<MeshPartDefinition, IntList> e : indices.entrySet()) {
            meshDefinitions.put(e.getKey(), VertexBuilder.create(e.getValue().toIntArray()));
        }
        return new SkinnedMesh((Map<String, Number[]>)arrayMap, (Map<MeshPartDefinition, List<VertexBuilder>>)meshDefinitions, null, null);
    }

    public static enum State {
        EMPTY,
        EQUAL,
        DIFFERENT;

    }
}

