/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.api.collider;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Matrix4f;
import yesman.epicfight.api.animation.Joint;
import yesman.epicfight.api.animation.Pose;
import yesman.epicfight.api.collider.Collider;
import yesman.epicfight.api.model.Armature;
import yesman.epicfight.api.utils.math.MathUtils;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.client.renderer.EpicFightRenderTypes;

public class LineCollider
extends Collider {
    protected Vec3 modelVec;
    protected Vec3 worldVec;

    public LineCollider(double posX, double posY, double posZ, double vecX, double vecY, double vecZ) {
        this(LineCollider.getInitialAABB(posX, posY, posZ, vecX, vecY, vecZ), posX, posY, posZ, vecX, vecY, vecZ);
    }

    protected LineCollider(AABB outerAABB, double posX, double posY, double posZ, double vecX, double vecY, double vecZ) {
        super(new Vec3(posX, posY, posZ), outerAABB);
        this.modelVec = new Vec3(vecX, vecY, vecZ);
        this.worldVec = new Vec3(0.0, 0.0, 0.0);
    }

    static AABB getInitialAABB(double posX, double posY, double posZ, double vecX, double vecY, double vecZ) {
        Vec3 start = new Vec3(posX, posY, posZ);
        Vec3 end = new Vec3(vecX + posX, vecY + posY, vecZ + posZ);
        double length = Math.max(start.length(), end.length());
        return new AABB(length, length, length, -length, -length, -length);
    }

    @Override
    public void transform(OpenMatrix4f mat) {
        this.worldVec = OpenMatrix4f.transform(mat.removeTranslation(), this.modelVec);
        super.transform(mat);
    }

    @Override
    public boolean isCollide(Entity entity) {
        double endZ;
        double endY;
        double maxStart;
        double minEnd;
        double temp;
        double endX;
        AABB opponent = entity.getBoundingBox();
        if (this.worldVec.x == 0.0 && (this.worldCenter.x < opponent.minX || this.worldCenter.x > opponent.maxX)) {
            return false;
        }
        double startX = Mth.clamp((double)((opponent.minX + this.worldCenter.x) / -this.worldVec.x), (double)0.0, (double)1.0);
        if (startX > (endX = Mth.clamp((double)((opponent.maxX + this.worldCenter.x) / -this.worldVec.x), (double)0.0, (double)1.0))) {
            temp = startX;
            startX = endX;
            endX = temp;
        }
        if ((minEnd = endX) == (maxStart = startX)) {
            return false;
        }
        if (this.worldVec.y == 0.0 && (this.worldCenter.y < opponent.minY || this.worldCenter.y > opponent.maxY)) {
            return false;
        }
        double startY = Mth.clamp((double)((double)((float)(opponent.minY - this.worldCenter.y)) / this.worldVec.y), (double)0.0, (double)1.0);
        if (startY > (endY = Mth.clamp((double)((double)((float)(opponent.maxY - this.worldCenter.y)) / this.worldVec.y), (double)0.0, (double)1.0))) {
            temp = startY;
            startY = endY;
            endY = temp;
        }
        maxStart = maxStart < startY ? startY : maxStart;
        double d = minEnd = minEnd > endY ? endY : minEnd;
        if (maxStart >= minEnd) {
            return false;
        }
        if (this.worldVec.z == 0.0 && (this.worldCenter.z < opponent.minZ || this.worldCenter.z > opponent.maxZ)) {
            return false;
        }
        double startZ = Mth.clamp((double)((double)((float)(opponent.minZ + this.worldCenter.z)) / -this.worldVec.z), (double)0.0, (double)1.0);
        if (startZ > (endZ = Mth.clamp((double)((double)((float)(opponent.maxZ + this.worldCenter.z)) / -this.worldVec.z), (double)0.0, (double)1.0))) {
            temp = startZ;
            startZ = endZ;
            endZ = temp;
        }
        maxStart = maxStart < startZ ? startZ : maxStart;
        minEnd = minEnd > endZ ? endZ : minEnd;
        return !(maxStart >= minEnd);
    }

    @Override
    public LineCollider deepCopy() {
        return new LineCollider(this.modelCenter.x, this.modelCenter.y, this.modelCenter.z, this.modelVec.x, this.modelVec.y, this.modelVec.z);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public RenderType getRenderType() {
        return EpicFightRenderTypes.debugCollider();
    }

    @Override
    public void drawInternal(PoseStack poseStack, VertexConsumer vertexConsumer, Armature armature, Joint joint, Pose pose1, Pose pose2, float partialTicks, int color) {
        Pose interpolatedPose = Pose.interpolatePose(pose1, pose2, partialTicks);
        OpenMatrix4f poseMatrix = armature.rootJoint.equals(joint) ? interpolatedPose.orElseEmpty("Root").getAnimationBoundMatrix(armature.rootJoint, new OpenMatrix4f()).removeTranslation() : armature.getBoundTransformFor(interpolatedPose, joint);
        MathUtils.mulStack(poseStack, poseMatrix);
        Matrix4f matrix = poseStack.last().pose();
        float startX = (float)this.modelCenter.x;
        float startY = (float)this.modelCenter.y;
        float startZ = (float)this.modelCenter.z;
        float endX = (float)(this.modelCenter.x + this.modelVec.x);
        float endY = (float)(this.modelCenter.y + this.modelVec.y);
        float endZ = (float)(this.modelCenter.z + this.modelVec.z);
        vertexConsumer.addVertex(matrix, startX, startY, startZ).setColor(color);
        vertexConsumer.addVertex(matrix, endX, endY, endZ).setColor(color);
    }
}

