/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.api.collider;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Vector3f;
import yesman.epicfight.api.animation.Joint;
import yesman.epicfight.api.animation.JointTransform;
import yesman.epicfight.api.animation.Pose;
import yesman.epicfight.api.animation.TransformSheet;
import yesman.epicfight.api.animation.types.AttackAnimation;
import yesman.epicfight.api.animation.types.EntityState;
import yesman.epicfight.api.collider.LineCollider;
import yesman.epicfight.api.collider.MultiCollider;
import yesman.epicfight.api.model.Armature;
import yesman.epicfight.api.utils.math.Vec3f;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;

public class MultiLineCollider
extends MultiCollider<LineCollider> {
    public MultiLineCollider(int arrayLength, double posX, double posY, double posZ, double vecX, double vecY, double vecZ) {
        super(arrayLength, posX, posY, posZ, LineCollider.getInitialAABB(posX, posY, posZ, vecX, vecY, vecZ));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void draw(PoseStack poseStack, MultiBufferSource buffer, LivingEntityPatch<?> entitypatch, AttackAnimation animation, Joint joint, float prevElapsedTime, float elapsedTime, float partialTicks, float attackSpeed) {
        float partialScale;
        int numberOf = Math.max(Math.round((float)this.numberOfColliders * attackSpeed), 1);
        float interpolation = partialScale = 1.0f / (float)numberOf;
        Armature armature = entitypatch.getArmature();
        EntityState state = animation.getState(entitypatch, elapsedTime);
        EntityState prevState = animation.getState(entitypatch, prevElapsedTime);
        boolean attacking = prevState.attacking() || state.attacking() || prevState.getLevel() < 2 && state.getLevel() > 2;
        ArrayList colliders = Lists.newArrayList();
        for (int i = 0; i < numberOf; ++i) {
            colliders.add(((LineCollider)this.colliders.get(i)).deepCopy());
        }
        for (LineCollider lineCollider : colliders) {
            Pose pose;
            float pt1 = prevElapsedTime + (elapsedTime - prevElapsedTime) * partialTicks;
            float pt2 = prevElapsedTime + (elapsedTime - prevElapsedTime) * interpolation;
            TransformSheet coordTransform = animation.getCoord();
            Vec3f p1 = coordTransform.getInterpolatedTranslation(pt1);
            Vec3f p2 = coordTransform.getInterpolatedTranslation(pt2);
            Vector3f gap = new Vector3f(p2.x - p1.x, p2.y - p1.y, p2.z - p1.z);
            poseStack.pushPose();
            poseStack.translate(gap.x(), gap.y(), gap.z());
            if (armature.rootJoint.getName().equals(joint.getName())) {
                pose = new Pose();
                pose.putJointData("Root", JointTransform.empty());
                animation.modifyPose(animation, pose, entitypatch, elapsedTime, 1.0f);
            } else {
                pose = animation.getPoseByTime(entitypatch, pt2, 1.0f);
            }
            lineCollider.drawInternal(poseStack, buffer.getBuffer(this.getRenderType()), armature, joint, pose, pose, 1.0f, attacking ? -65536 : -1);
            poseStack.popPose();
            interpolation += partialScale;
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public RenderType getRenderType() {
        return null;
    }
}

