/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.api.utils;

import net.minecraft.util.Mth;
import org.joml.Vector4f;
import org.joml.Vector4i;

public abstract class ColorUtil {
    private static final Vector4i COLOR_HOLDER_I = new Vector4i();
    private static final Vector4f COLOR_HOLDER_F = new Vector4f();

    public static int packToARGB(int r, int g, int b, int a) {
        int ia = a << 24;
        int ir = r << 16;
        int ig = g << 8;
        int ib = b;
        return ir | ig | ib | ia;
    }

    public static Vector4i unpackToARGBI(int packedColor) {
        int a = (packedColor & 0xFF000000) >>> 24;
        int r = (packedColor & 0xFF0000) >>> 16;
        int g = (packedColor & 0xFF00) >>> 8;
        int b = packedColor & 0xFF;
        ColorUtil.COLOR_HOLDER_I.x = r;
        ColorUtil.COLOR_HOLDER_I.y = g;
        ColorUtil.COLOR_HOLDER_I.z = b;
        ColorUtil.COLOR_HOLDER_I.w = a;
        return COLOR_HOLDER_I;
    }

    public static Vector4f unpackToARGBF(int packedColor) {
        int a = (packedColor & 0xFF000000) >>> 24;
        int r = (packedColor & 0xFF0000) >>> 16;
        int g = (packedColor & 0xFF00) >>> 8;
        int b = packedColor & 0xFF;
        ColorUtil.COLOR_HOLDER_F.x = (float)r / 255.0f;
        ColorUtil.COLOR_HOLDER_F.y = (float)g / 255.0f;
        ColorUtil.COLOR_HOLDER_F.z = (float)b / 255.0f;
        ColorUtil.COLOR_HOLDER_F.w = (float)a / 255.0f;
        return COLOR_HOLDER_F;
    }

    public static int mixPackedARGB(double delta, int c1, int c2) {
        ColorUtil.unpackToARGBI(c1);
        int startR = ColorUtil.COLOR_HOLDER_I.x;
        int startG = ColorUtil.COLOR_HOLDER_I.y;
        int startB = ColorUtil.COLOR_HOLDER_I.z;
        int startA = ColorUtil.COLOR_HOLDER_I.w;
        ColorUtil.unpackToARGBI(c2);
        int endR = ColorUtil.COLOR_HOLDER_I.x;
        int endG = ColorUtil.COLOR_HOLDER_I.y;
        int endB = ColorUtil.COLOR_HOLDER_I.z;
        int endA = ColorUtil.COLOR_HOLDER_I.w;
        int mixR = (int)Mth.lerp((double)delta, (double)startR, (double)endR);
        int mixG = (int)Mth.lerp((double)delta, (double)startG, (double)endG);
        int mixB = (int)Mth.lerp((double)delta, (double)startB, (double)endB);
        int mixA = (int)Mth.lerp((double)delta, (double)startA, (double)endA);
        return ColorUtil.packToARGB(mixR, mixG, mixB, mixA);
    }
}

