/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.client.gui.datapack.widgets;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.network.chat.Component;

public interface ResizableComponent
extends GuiEventListener,
NarratableEntry {
    default public void resize(ScreenRectangle screenRectangle) {
        if (this.getHorizontalSizingOption() != null) {
            this.getHorizontalSizingOption().resizeFunction.resize(this, screenRectangle, this.getX1(), this.getX2());
        }
        if (this.getVerticalSizingOption() != null) {
            this.getVerticalSizingOption().resizeFunction.resize(this, screenRectangle, this.getY1(), this.getY2());
        }
    }

    default public ResizableComponent relocateX(ScreenRectangle screenrect, int screenX) {
        this._setX(screenX);
        if (this.getHorizontalSizingOption() == HorizontalSizing.WIDTH_RIGHT) {
            this.setX2(screenrect.right() - (screenX + this._getWidth()));
        } else {
            this.setX1(screenX);
        }
        return this;
    }

    default public ResizableComponent relocateY(ScreenRectangle screenrect, int screenY) {
        this._setY(screenY);
        if (this.getVerticalSizingOption() == VerticalSizing.HEIGHT_BOTTOM) {
            this.setY2(screenrect.bottom() - (screenY + this._getHeight()));
        } else {
            this.setY1(screenY);
        }
        return this;
    }

    public int getX1();

    public int getX2();

    public int getY1();

    public int getY2();

    public void setX1(int var1);

    public void setX2(int var1);

    public void setY1(int var1);

    public void setY2(int var1);

    public HorizontalSizing getHorizontalSizingOption();

    public VerticalSizing getVerticalSizingOption();

    default public AbstractWidget asWidget() {
        return (AbstractWidget)this;
    }

    public void _setActive(boolean var1);

    public void _renderWidget(GuiGraphics var1, int var2, int var3, float var4);

    public int _getX();

    public int _getY();

    public int _getWidth();

    public int _getHeight();

    public void _setX(int var1);

    public void _setY(int var1);

    public void _setWidth(int var1);

    public void _setHeight(int var1);

    public Component _getMessage();

    public static enum HorizontalSizing {
        LEFT_WIDTH((component, screenRectangle, v1, v2) -> {
            component._setX(screenRectangle.left() + v1);
            component._setWidth(v2);
        }),
        LEFT_RIGHT((component, screenRectangle, v1, v2) -> {
            int end = screenRectangle.right() - v2;
            int width = Math.max(end - (screenRectangle.left() + v1), 0);
            component._setX(screenRectangle.left() + v1);
            component._setWidth(width);
        }),
        WIDTH_RIGHT((component, screenRectangle, v1, v2) -> {
            int end = screenRectangle.right() - v2;
            int start = Math.max(end - v1, 0);
            component._setX(start);
            component._setWidth(v1);
        });

        ResizeFunction resizeFunction;

        private HorizontalSizing(ResizeFunction resizeFunction) {
            this.resizeFunction = resizeFunction;
        }
    }

    @FunctionalInterface
    public static interface ResizeFunction {
        public void resize(ResizableComponent var1, ScreenRectangle var2, int var3, int var4);
    }

    public static enum VerticalSizing {
        TOP_HEIGHT((component, screenRectangle, v1, v2) -> {
            component._setY(v1);
            component._setHeight(v2);
        }),
        TOP_BOTTOM((component, screenRectangle, v1, v2) -> {
            int end = screenRectangle.bottom() - v2;
            int height = Math.max(end - v1, 0);
            component._setY(v1);
            component._setHeight(height);
        }),
        HEIGHT_BOTTOM((component, screenRectangle, v1, v2) -> {
            int end = screenRectangle.bottom() - v2;
            int start = Math.max(end - v1, 0);
            component._setY(start);
            component._setHeight(v1);
        });

        ResizeFunction resizeFunction;

        private VerticalSizing(ResizeFunction resizeFunction) {
            this.resizeFunction = resizeFunction;
        }
    }
}

