/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.client.input;

import com.mojang.blaze3d.platform.InputConstants;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.InteractionHand;
import net.neoforged.neoforge.client.ClientHooks;
import net.neoforged.neoforge.client.event.InputEvent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import yesman.epicfight.api.client.input.action.InputAction;

@ApiStatus.Internal
public final class InputUtils {
    private InputUtils() {
    }

    public static void runKeyboardMouseEvent(@NotNull InputAction action, @NotNull Runnable handler) {
        KeyMapping keyMapping = action.keyMapping();
        InputConstants.Key key = keyMapping.getKey();
        boolean isMouse = InputConstants.Type.MOUSE == key.getType();
        int mouseButton = isMouse ? key.getValue() : -1;
        InputEvent.InteractionKeyMappingTriggered inputEvent = ClientHooks.onClickInput((int)mouseButton, (KeyMapping)keyMapping, (InteractionHand)InteractionHand.MAIN_HAND);
        if (!inputEvent.isCanceled()) {
            handler.run();
        }
    }

    public static void sneakingTick(boolean isSneaking, float sneakingSpeedMultiplier) {
        LocalPlayer localPlayer = Minecraft.getInstance().player;
        if (localPlayer != null) {
            InputUtils.sneakingTick(localPlayer, isSneaking, sneakingSpeedMultiplier);
        }
    }

    public static void sneakingTick(@NotNull LocalPlayer player, boolean isSneaking, float sneakingSpeedMultiplier) {
        player.input.tick(isSneaking, sneakingSpeedMultiplier);
    }
}

