/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.client.particle;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.function.Consumer;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import yesman.epicfight.api.client.model.Mesh;
import yesman.epicfight.api.client.model.SkinnedMesh;
import yesman.epicfight.api.utils.EntitySnapshot;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.api.utils.math.QuaternionUtils;
import yesman.epicfight.client.particle.CustomModelParticle;
import yesman.epicfight.client.particle.EpicFightParticleRenderTypes;
import yesman.epicfight.client.renderer.EpicFightRenderTypes;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;

public class EntityAfterimageParticle
extends CustomModelParticle<SkinnedMesh> {
    protected final EntitySnapshot<?> entitySnapshot;
    protected final Consumer<EntityAfterimageParticle> ticktask;
    protected float alphaO;

    public EntityAfterimageParticle(ClientLevel level, double x, double y, double z, double xd, double yd, double zd, EntitySnapshot<?> entitySnapshot, Consumer<EntityAfterimageParticle> ticktask) {
        super(level, x, y, z, xd, yd, zd, null);
        this.entitySnapshot = entitySnapshot;
        this.ticktask = ticktask;
        this.rCol = 1.0f;
        this.gCol = 1.0f;
        this.bCol = 1.0f;
        this.alphaO = 1.0f;
        this.alpha = 1.0f;
        this.yawO = entitySnapshot.getYRot();
        this.yaw = entitySnapshot.getYRot();
    }

    @Override
    public void tick() {
        super.tick();
        this.alphaO = this.alpha;
        this.ticktask.accept(this);
    }

    @Override
    public void render(VertexConsumer vertexConsumer, Camera camera, float partialTicks) {
        float alpha = Mth.lerp((float)partialTicks, (float)this.alphaO, (float)this.alpha);
        int lightColor = this.getLightColor(partialTicks);
        PoseStack poseStack = new PoseStack();
        this.setupPoseStack(poseStack, camera, partialTicks);
        MultiBufferSource.BufferSource buffers = Minecraft.getInstance().renderBuffers().bufferSource();
        this.entitySnapshot.renderTextured(poseStack, (MultiBufferSource)buffers, EpicFightRenderTypes::entityAfterimageStencil, Mesh.DrawingFunction.POSITION_TEX, 0, 0.0f, 0.0f, 0.0f, 1.0f);
        this.entitySnapshot.renderItems(poseStack, (MultiBufferSource)buffers, EpicFightRenderTypes.itemAfterimageStencil(), Mesh.DrawingFunction.POSITION_TEX, lightColor, 1.0f);
        buffers.endLastBatch();
        this.entitySnapshot.renderTextured(poseStack, (MultiBufferSource)buffers, EpicFightRenderTypes::entityAfterimageTranslucent, Mesh.DrawingFunction.NEW_ENTITY, lightColor, this.rCol, this.gCol, this.bCol, alpha);
        this.entitySnapshot.renderItems(poseStack, (MultiBufferSource)buffers, EpicFightRenderTypes.itemAfterimageTranslucent(), Mesh.DrawingFunction.NEW_ENTITY, lightColor, alpha);
        buffers.endLastBatch();
        this.revert(poseStack);
    }

    public ParticleRenderType getRenderType() {
        return EpicFightParticleRenderTypes.ENTITY_PARTICLE;
    }

    @Override
    protected void setupPoseStack(PoseStack poseStack, Camera camera, float partialTick) {
        poseStack.pushPose();
        Vec3 cameraPosition = camera.getPosition();
        float x = (float)(Mth.lerp((double)partialTick, (double)this.xo, (double)this.x) - cameraPosition.x());
        float y = (float)(Mth.lerp((double)partialTick, (double)this.yo, (double)this.y) - cameraPosition.y());
        float z = (float)(Mth.lerp((double)partialTick, (double)this.zo, (double)this.z) - cameraPosition.z());
        poseStack.translate(x, y, z);
        Quaternionf rotation = new Quaternionf(0.0f, 0.0f, 0.0f, 1.0f);
        rotation.mul((Quaternionfc)QuaternionUtils.YP.rotationDegrees(180.0f));
        poseStack.mulPose(rotation);
        poseStack.mulPose(OpenMatrix4f.exportToMojangMatrix(this.entitySnapshot.getModelMatrix()));
        float scale = Mth.lerp((float)partialTick, (float)this.scaleO, (float)this.scale);
        poseStack.translate(0.0f, this.entitySnapshot.getHeightHalf(), 0.0f);
        poseStack.scale(scale, scale, scale);
        poseStack.translate(0.0f, -this.entitySnapshot.getHeightHalf(), 0.0f);
    }

    @Override
    protected void revert(PoseStack poseStack) {
        poseStack.popPose();
    }

    public static class WhiteAfterimageProvider
    implements ParticleProvider<SimpleParticleType> {
        public Particle createParticle(SimpleParticleType typeIn, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            EntitySnapshot<?> entitySnapshot;
            Entity entity = level.getEntity((int)Double.doubleToLongBits(xSpeed));
            LivingEntityPatch entitypatch = EpicFightCapabilities.getEntityPatch(entity, LivingEntityPatch.class);
            if (entitypatch != null && (entitySnapshot = entitypatch.captureEntitySnapshot()) != null) {
                WhiteAfterimageParticle afterimage = new WhiteAfterimageParticle(level, x, y, z, xSpeed, ySpeed, zSpeed, entitySnapshot, particle -> {
                    particle.alpha = (float)(((EntityAfterimageParticle)particle).lifetime - ((EntityAfterimageParticle)particle).age) / (float)((EntityAfterimageParticle)particle).lifetime;
                });
                afterimage.setLifetime(20);
                return afterimage;
            }
            return null;
        }
    }

    public static class AdrenalineParticleProvider
    implements ParticleProvider<SimpleParticleType> {
        public Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            EntitySnapshot<?> entitySnapshot;
            Entity entity = level.getEntity((int)Double.doubleToLongBits(xSpeed));
            LivingEntityPatch entitypatch = EpicFightCapabilities.getEntityPatch(entity, LivingEntityPatch.class);
            if (entitypatch != null && (entitySnapshot = entitypatch.captureEntitySnapshot()) != null) {
                EntityAfterimageParticle adrenalineparticle = new EntityAfterimageParticle(level, x, y, z, xSpeed, ySpeed, zSpeed, entitySnapshot, particle -> {
                    particle.alpha -= 0.025f;
                    particle.scale += (-0.0025f * (float)((EntityAfterimageParticle)particle).age * (float)((EntityAfterimageParticle)particle).age + 1.0f) * 0.1f;
                });
                adrenalineparticle.setLifetime(20);
                adrenalineparticle.setAlpha(0.6f);
                return adrenalineparticle;
            }
            return null;
        }
    }

    public static class WhiteAfterimageParticle
    extends EntityAfterimageParticle {
        public WhiteAfterimageParticle(ClientLevel level, double x, double y, double z, double xd, double yd, double zd, EntitySnapshot<?> entitySnapshot, Consumer<EntityAfterimageParticle> ticktask) {
            super(level, x, y, z, xd, yd, zd, entitySnapshot, ticktask);
        }

        @Override
        public void render(VertexConsumer vertexConsumer, Camera camera, float partialTicks) {
            float alpha = Mth.lerp((float)partialTicks, (float)this.alphaO, (float)this.alpha);
            int lightColor = this.getLightColor(partialTicks);
            PoseStack poseStack = new PoseStack();
            this.setupPoseStack(poseStack, camera, partialTicks);
            MultiBufferSource.BufferSource buffers = Minecraft.getInstance().renderBuffers().bufferSource();
            this.entitySnapshot.renderTextured(poseStack, (MultiBufferSource)buffers, EpicFightRenderTypes::entityAfterimageStencil, Mesh.DrawingFunction.POSITION_TEX, 0, 0.0f, 0.0f, 0.0f, 1.0f);
            this.entitySnapshot.renderItems(poseStack, (MultiBufferSource)buffers, EpicFightRenderTypes.itemAfterimageStencil(), Mesh.DrawingFunction.POSITION_TEX, lightColor, 1.0f);
            buffers.endLastBatch();
            this.entitySnapshot.render(poseStack, (MultiBufferSource)buffers, EpicFightRenderTypes.entityAfterimageWhite(), Mesh.DrawingFunction.POSITION_TEX_COLOR_LIGHTMAP, lightColor, this.rCol, this.gCol, this.bCol, alpha);
            this.entitySnapshot.renderItems(poseStack, (MultiBufferSource)buffers, EpicFightRenderTypes.itemAfterimageWhite(), Mesh.DrawingFunction.POSITION_TEX_COLOR_LIGHTMAP, lightColor, alpha);
            buffers.endLastBatch();
            this.revert(poseStack);
        }
    }
}

