/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.client.renderer.patched.entity;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.PlayerSkin;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import org.joml.Vector4f;
import yesman.epicfight.api.client.model.SkinnedMesh;
import yesman.epicfight.api.client.model.StaticMesh;
import yesman.epicfight.api.client.neoevent.PrepareModelEvent;
import yesman.epicfight.api.model.Armature;
import yesman.epicfight.api.utils.math.MathUtils;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.api.utils.math.Vec2i;
import yesman.epicfight.api.utils.math.Vec3f;
import yesman.epicfight.client.renderer.LayerRenderer;
import yesman.epicfight.client.renderer.patched.entity.PatchedEntityRenderer;
import yesman.epicfight.client.renderer.patched.layer.LayerUtil;
import yesman.epicfight.client.renderer.patched.layer.PatchedLayer;
import yesman.epicfight.client.renderer.patched.layer.RenderOriginalModelLayer;
import yesman.epicfight.main.EpicFightMod;
import yesman.epicfight.mixin.client.MixinLivingEntityRenderer;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;

public abstract class PatchedLivingEntityRenderer<E extends LivingEntity, T extends LivingEntityPatch<E>, M extends EntityModel<E>, R extends LivingEntityRenderer<E, M>, AM extends SkinnedMesh>
extends PatchedEntityRenderer<E, T, R, AM>
implements LayerRenderer<E, T, M> {
    protected final Map<Class<?>, PatchedLayer<E, T, M, ? extends RenderLayer<E, M>>> patchedLayers = Maps.newHashMap();
    protected final List<PatchedLayer<E, T, M, ? extends RenderLayer<E, M>>> customLayers = Lists.newArrayList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PatchedLivingEntityRenderer(EntityRendererProvider.Context context, EntityType<?> entityType) {
        ResourceLocation type = EntityType.getKey(entityType);
        FileToIdConverter filetoidconverter = FileToIdConverter.json((String)("animated_layers/" + type.getPath()));
        ArrayList layers = Lists.newArrayList();
        for (Map.Entry entry : filetoidconverter.listMatchingResources(context.getResourceManager()).entrySet()) {
            BufferedReader reader = null;
            try {
                reader = ((Resource)entry.getValue()).openAsReader();
                JsonElement jsonelement = (JsonElement)GsonHelper.fromJson((Gson)new GsonBuilder().create(), (Reader)reader, JsonElement.class);
                layers.add(Pair.of((Object)((ResourceLocation)entry.getKey()), (Object)jsonelement));
            }
            catch (JsonParseException | IOException | IllegalArgumentException jsonparseexception) {
                EpicFightMod.LOGGER.error("Failed to parse layer file {} for {}", entry.getKey(), (Object)type);
                jsonparseexception.printStackTrace();
            }
            finally {
                try {
                    if (reader == null) continue;
                    ((Reader)reader).close();
                }
                catch (IOException iOException) {}
            }
        }
        LayerUtil.addLayer(this, entityType, layers);
    }

    public PatchedLivingEntityRenderer<E, T, M, R, AM> initLayerLast(EntityRendererProvider.Context context, EntityType<?> entityType) {
        List vanillaLayers = null;
        if (entityType == EntityType.PLAYER) {
            var5_4 = context.getEntityRenderDispatcher().playerRenderers.get(PlayerSkin.Model.WIDE);
            if (var5_4 instanceof LivingEntityRenderer) {
                livingentityrenderer = (LivingEntityRenderer)var5_4;
                vanillaLayers = livingentityrenderer.layers;
            }
        } else {
            var5_4 = context.getEntityRenderDispatcher().renderers.get(entityType);
            if (var5_4 instanceof LivingEntityRenderer) {
                livingentityrenderer = (LivingEntityRenderer)var5_4;
                vanillaLayers = livingentityrenderer.layers;
            }
        }
        if (vanillaLayers != null) {
            for (RenderLayer layer : vanillaLayers) {
                Class<?> layerClass = layer.getClass();
                if (layerClass.isAnonymousClass()) {
                    layerClass = layer.getClass().getSuperclass();
                }
                if (this.patchedLayers.containsKey(layerClass)) continue;
                this.addPatchedLayer(layerClass, new RenderOriginalModelLayer("Root", new Vec3f(0.0f, this.getDefaultLayerHeightCorrection(), 0.0f), new Vec3f(0.0f, 0.0f, 0.0f)));
            }
        }
        return this;
    }

    @Override
    public void render(E entity, T entitypatch, R renderer, MultiBufferSource buffer, PoseStack poseStack, int packedLight, float partialTicks) {
        super.render(entity, entitypatch, renderer, buffer, poseStack, packedLight, partialTicks);
        MixinLivingEntityRenderer livingEntityRendererAccessor = (MixinLivingEntityRenderer)renderer;
        boolean isVisible = livingEntityRendererAccessor.invokeIsBodyVisible((LivingEntity)entity);
        boolean isVisibleToPlayer = !isVisible && !entity.isInvisibleTo((Player)Minecraft.getInstance().player);
        boolean isGlowing = Minecraft.getInstance().shouldEntityAppearGlowing(entity);
        RenderType renderType = livingEntityRendererAccessor.invokeGetRenderType((LivingEntity)entity, isVisible, isVisibleToPlayer, isGlowing);
        Armature armature = ((LivingEntityPatch)entitypatch).getArmature();
        poseStack.pushPose();
        this.mulPoseStack(poseStack, armature, entity, entitypatch, partialTicks);
        this.prepareVanillaModel(entity, (M)renderer.getModel(), (LivingEntityRenderer<E, M>)renderer, partialTicks);
        this.setArmaturePose(entitypatch, armature, partialTicks);
        if (renderType != null) {
            SkinnedMesh mesh = (SkinnedMesh)this.getMeshProvider(entitypatch).get();
            this.prepareModel(mesh, entity, entitypatch, renderer);
            PrepareModelEvent prepareModelEvent = new PrepareModelEvent(this, mesh, (LivingEntityPatch<?>)entitypatch, buffer, poseStack, packedLight, partialTicks);
            if (!((PrepareModelEvent)NeoForge.EVENT_BUS.post((Event)prepareModelEvent)).isCanceled()) {
                Vector4f color = new Vector4f(1.0f, 1.0f, 1.0f, isVisibleToPlayer ? 0.15f : 1.0f);
                ((LivingEntityPatch)entitypatch).getEntityDecorations().modifyColor(color, partialTicks);
                int blockLight = (packedLight & 0xF0) >> 4;
                int skyLight = (packedLight & 0xF00000) >> 20;
                Vec2i lightUv = new Vec2i(blockLight, skyLight);
                ((LivingEntityPatch)entitypatch).getEntityDecorations().modifyLight(lightUv, partialTicks);
                int modifiedLight = LightTexture.pack((int)lightUv.x, (int)lightUv.y);
                mesh.draw(poseStack, buffer, renderType, modifiedLight, color.x(), color.y(), color.z(), color.w(), this.getOverlayCoord(entity, entitypatch, partialTicks), armature, armature.getPoseMatrices());
                ((LivingEntityPatch)entitypatch).getEntityDecorations().listDecorationOverlays().forEach(decorationOverlay -> {
                    if (!decorationOverlay.shouldRemove() && decorationOverlay.shouldRender()) {
                        Vector4f overlayColor = decorationOverlay.color(partialTicks);
                        mesh.draw(poseStack, buffer, decorationOverlay.getRenderType(), modifiedLight, overlayColor.x(), overlayColor.y(), overlayColor.z(), overlayColor.w(), OverlayTexture.NO_OVERLAY, armature, armature.getPoseMatrices());
                    }
                });
            }
        }
        if (!entity.isSpectator()) {
            this.renderLayer((LivingEntityRenderer<E, M>)renderer, entitypatch, entity, armature.getPoseMatrices(), buffer, poseStack, packedLight, partialTicks);
        }
        if (renderType != null && Minecraft.getInstance().getEntityRenderDispatcher().shouldRenderHitBoxes()) {
            ((LivingEntityPatch)entitypatch).getClientAnimator().renderDebuggingInfoForAllLayers(poseStack, buffer, partialTicks);
        }
        poseStack.popPose();
    }

    protected void prepareVanillaModel(E entity, M model, LivingEntityRenderer<E, M> renderer, float partialTicks) {
        Entity entity2;
        boolean shouldSit;
        ((EntityModel)model).riding = shouldSit = entity.isPassenger() && entity.getVehicle() != null && entity.getVehicle().shouldRiderSit();
        ((EntityModel)model).young = entity.isBaby();
        float f = Mth.rotLerp((float)partialTicks, (float)((LivingEntity)entity).yBodyRotO, (float)((LivingEntity)entity).yBodyRot);
        float f1 = Mth.rotLerp((float)partialTicks, (float)((LivingEntity)entity).yHeadRotO, (float)((LivingEntity)entity).yHeadRot);
        float f2 = f1 - f;
        if (shouldSit && (entity2 = entity.getVehicle()) instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)entity2;
            f = Mth.rotLerp((float)partialTicks, (float)livingentity.yBodyRotO, (float)livingentity.yBodyRot);
            f2 = f1 - f;
            float f3 = Mth.wrapDegrees((float)f2);
            if (f3 < -85.0f) {
                f3 = -85.0f;
            }
            if (f3 >= 85.0f) {
                f3 = 85.0f;
            }
            f = f1 - f3;
            if (f3 * f3 > 2500.0f) {
                f += f3 * 0.2f;
            }
            f2 = f1 - f;
        }
        float f6 = Mth.lerp((float)partialTicks, (float)((LivingEntity)entity).xRotO, (float)entity.getXRot());
        if (LivingEntityRenderer.isEntityUpsideDown(entity)) {
            f6 *= -1.0f;
            f2 *= -1.0f;
        }
        float f7 = ((MixinLivingEntityRenderer)renderer).invokeGetBob((LivingEntity)entity, partialTicks);
        float f8 = 0.0f;
        float f5 = 0.0f;
        if (!shouldSit && entity.isAlive()) {
            f8 = ((LivingEntity)entity).walkAnimation.speed(partialTicks);
            f5 = ((LivingEntity)entity).walkAnimation.position() - ((LivingEntity)entity).walkAnimation.speed() * (1.0f - partialTicks);
            if (entity.isBaby()) {
                f5 *= 3.0f;
            }
            if (f8 > 1.0f) {
                f8 = 1.0f;
            }
        }
        model.prepareMobModel(entity, f5, f8, partialTicks);
        model.setupAnim(entity, f5, f8, f7, f2, f6);
    }

    protected void prepareModel(AM mesh, E entity, T entitypatch, R renderer) {
        ((StaticMesh)mesh).initialize();
    }

    protected void renderLayer(LivingEntityRenderer<E, M> renderer, T entitypatch, E entity, OpenMatrix4f[] poses, MultiBufferSource buffer, PoseStack poseStack, int packedLight, float partialTicks) {
        float f = MathUtils.lerpBetween(((LivingEntity)entity).yBodyRotO, ((LivingEntity)entity).yBodyRot, partialTicks);
        float f1 = MathUtils.lerpBetween(((LivingEntity)entity).yHeadRotO, ((LivingEntity)entity).yHeadRot, partialTicks);
        float f2 = f1 - f;
        float f7 = entity.getViewXRot(partialTicks);
        float bob = ((MixinLivingEntityRenderer)renderer).invokeGetBob((LivingEntity)entity, partialTicks);
        for (RenderLayer renderLayer : renderer.layers) {
            Class<?> layerClass = renderLayer.getClass();
            if (layerClass.isAnonymousClass()) {
                layerClass = layerClass.getSuperclass();
            }
            if (!this.patchedLayers.containsKey(layerClass)) continue;
            this.patchedLayers.get(layerClass).renderLayer(entity, entitypatch, (RenderLayer<T, M>)renderLayer, poseStack, buffer, packedLight, poses, bob, f2, f7, partialTicks);
        }
        for (PatchedLayer patchedLayer : this.customLayers) {
            patchedLayer.renderLayer(entity, entitypatch, null, poseStack, buffer, packedLight, poses, bob, f2, f7, partialTicks);
        }
    }

    protected int getOverlayCoord(E entity, T entitypatch, float partialTicks) {
        int initU = 0;
        int initV = OverlayTexture.v((((LivingEntity)entity).hurtTime > 0 || ((LivingEntity)entity).deathTime > 0 ? 1 : 0) != 0);
        Vec2i coord = new Vec2i(initU, initV);
        ((LivingEntityPatch)entitypatch).getEntityDecorations().modifyOverlay(coord, partialTicks);
        return OverlayTexture.pack((int)coord.x, (int)coord.y);
    }

    @Override
    public void mulPoseStack(PoseStack poseStack, Armature armature, E entity, T entitypatch, float partialTicks) {
        super.mulPoseStack(poseStack, armature, entity, entitypatch, partialTicks);
        if (entity.isCrouching()) {
            poseStack.translate(0.0, 0.15, 0.0);
        }
    }

    @Override
    public void addPatchedLayer(Class<?> originalLayerClass, PatchedLayer<E, T, M, ? extends RenderLayer<E, M>> patchedLayer) {
        this.patchedLayers.putIfAbsent(originalLayerClass, patchedLayer);
    }

    public void addPatchedLayerAlways(Class<?> originalLayerClass, PatchedLayer<E, T, M, ? extends RenderLayer<E, M>> patchedLayer) {
        this.patchedLayers.put(originalLayerClass, patchedLayer);
    }

    @Override
    public void addCustomLayer(PatchedLayer<E, T, M, ? extends RenderLayer<E, M>> patchedLayer) {
        this.customLayers.add(patchedLayer);
    }

    protected float getDefaultLayerHeightCorrection() {
        return 1.15f;
    }
}

