/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.client.renderer.patched.item;

import com.google.gson.JsonElement;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import org.joml.Matrix4f;
import yesman.epicfight.api.utils.math.MathUtils;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.client.renderer.patched.item.RenderItemBase;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;

public class RenderFilledMap
extends RenderItemBase {
    private static final RenderType MAP_BACKGROUND = RenderType.text((ResourceLocation)ResourceLocation.parse((String)"textures/map/map_background.png"));

    public RenderFilledMap(JsonElement jsonElement) {
        super(jsonElement);
    }

    @Override
    public void renderItemInHand(ItemStack stack, LivingEntityPatch<?> entitypatch, InteractionHand hand, OpenMatrix4f[] poses, MultiBufferSource buffer, PoseStack poseStack, int packedLight, float partialTicks) {
        OpenMatrix4f modelMatrix = this.getCorrectionMatrix(entitypatch, hand, poses);
        poseStack.pushPose();
        MathUtils.mulStack(poseStack, modelMatrix);
        if (hand == InteractionHand.MAIN_HAND && ((LivingEntity)entitypatch.getOriginal()).getOffhandItem().isEmpty()) {
            poseStack.scale(2.0f, 2.0f, 2.0f);
        }
        itemInHandRenderer.renderMap(poseStack, buffer, packedLight, stack);
        VertexConsumer vertexconsumer = buffer.getBuffer(MAP_BACKGROUND);
        Matrix4f matrix4f = poseStack.last().pose();
        vertexconsumer.addVertex(matrix4f, -7.0f, -7.0f, 0.0f).setColor(255, 255, 255, 255).setUv(0.0f, 0.0f).setLight(packedLight);
        vertexconsumer.addVertex(matrix4f, 135.0f, -7.0f, 0.0f).setColor(255, 255, 255, 255).setUv(1.0f, 0.0f).setLight(packedLight);
        vertexconsumer.addVertex(matrix4f, 135.0f, 135.0f, 0.0f).setColor(255, 255, 255, 255).setUv(1.0f, 1.0f).setLight(packedLight);
        vertexconsumer.addVertex(matrix4f, -7.0f, 135.0f, 0.0f).setColor(255, 255, 255, 255).setUv(0.0f, 1.0f).setLight(packedLight);
        poseStack.popPose();
    }
}

