/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.client.renderer.patched.item;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemInHandRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import yesman.epicfight.api.animation.Joint;
import yesman.epicfight.api.client.animation.property.TrailInfo;
import yesman.epicfight.api.model.Armature;
import yesman.epicfight.api.utils.math.MathUtils;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.api.utils.math.Vec3f;
import yesman.epicfight.model.armature.types.ToolHolderArmature;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;

public class RenderItemBase {
    protected static final Map<String, OpenMatrix4f> GLOBAL_MAINHAND_ITEM_TRANSFORMS = ImmutableMap.builder().put((Object)"Tool_L", (Object)new OpenMatrix4f().translate(0.0f, 0.0f, -0.13f).rotateDeg(-90.0f, Vec3f.X_AXIS).unmodifiable()).put((Object)"Tool_R", (Object)new OpenMatrix4f().translate(0.0f, 0.0f, -0.13f).rotateDeg(-90.0f, Vec3f.X_AXIS).unmodifiable()).put((Object)"Chest", (Object)new OpenMatrix4f(3.3484866E-8f, -2.809714E-8f, -0.99999994f, 0.0f, -0.6427876f, -0.7660444f, 0.0f, 0.0f, -0.76604444f, 0.64278764f, -4.3711385E-8f, 0.0f, 0.25711504f, 0.30641776f, 0.14999999f, 1.0f).unmodifiable()).put((Object)"Root", (Object)new OpenMatrix4f().unmodifiable()).build();
    protected static final Map<String, OpenMatrix4f> GLOBAL_OFFHAND_ITEM_TRANSFORMS = ImmutableMap.builder().put((Object)"Tool_L", (Object)new OpenMatrix4f().translate(0.0f, 0.0f, -0.13f).rotateDeg(-90.0f, Vec3f.X_AXIS).unmodifiable()).put((Object)"Tool_R", (Object)new OpenMatrix4f().translate(0.0f, 0.0f, -0.13f).rotateDeg(-90.0f, Vec3f.X_AXIS).unmodifiable()).put((Object)"Chest", (Object)new OpenMatrix4f(3.3484866E-8f, 2.809714E-8f, 0.99999994f, 0.0f, 0.6427876f, -0.7660444f, 0.0f, 0.0f, 0.76604444f, 0.64278764f, -4.3711385E-8f, 0.0f, -0.25711504f, 0.30641776f, 0.15099998f, 1.0f).unmodifiable()).put((Object)"Root", (Object)new OpenMatrix4f().unmodifiable()).build();
    protected static ItemRenderer itemRenderer;
    protected static ItemInHandRenderer itemInHandRenderer;
    protected final Map<String, OpenMatrix4f> mainhandCorrectionTransforms;
    protected final Map<String, OpenMatrix4f> offhandCorrectionTransforms;
    private final TrailInfo trailInfo;
    private final boolean alwaysInHand;
    private final boolean forceVanillaFirstPerson;
    private final boolean appearedInAfterimage;
    public final OpenMatrix4f transformHolder = new OpenMatrix4f();

    public static void initItemRenderers(Minecraft minecraft) {
        if (itemRenderer != null || itemInHandRenderer != null) {
            throw new IllegalStateException("Already initialized item renderers");
        }
        itemRenderer = minecraft.getItemRenderer();
        itemInHandRenderer = minecraft.gameRenderer.itemInHandRenderer;
    }

    public RenderItemBase(JsonElement jsonElement) {
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        this.trailInfo = jsonObj.has("trail") ? TrailInfo.deserialize(jsonObj.get("trail")) : null;
        this.forceVanillaFirstPerson = jsonObj.has("force_vanilla_first_person") && GsonHelper.getAsBoolean((JsonObject)jsonObj, (String)"force_vanilla_first_person");
        this.alwaysInHand = jsonObj.has("alwaysInHand") && GsonHelper.getAsBoolean((JsonObject)jsonObj, (String)"alwaysInHand");
        boolean bl = this.appearedInAfterimage = jsonObj.has("appeared_in_afterimage") ? GsonHelper.getAsBoolean((JsonObject)jsonObj, (String)"appeared_in_afterimage") : true;
        if (!jsonObj.has("transforms")) {
            this.mainhandCorrectionTransforms = GLOBAL_MAINHAND_ITEM_TRANSFORMS;
            this.offhandCorrectionTransforms = GLOBAL_OFFHAND_ITEM_TRANSFORMS;
        } else {
            JsonArray values;
            OpenMatrix4f matrix;
            JsonObject transformEntry;
            JsonObject handEntry = jsonObj.get("transforms").getAsJsonObject();
            if (handEntry.has("mainhand")) {
                ImmutableMap.Builder mainhandBuilder = ImmutableMap.builder();
                for (Map.Entry entry : handEntry.get("mainhand").getAsJsonObject().entrySet()) {
                    transformEntry = ((JsonElement)entry.getValue()).getAsJsonObject();
                    matrix = new OpenMatrix4f();
                    if (transformEntry.has("translation")) {
                        values = transformEntry.get("translation").getAsJsonArray();
                        matrix.translate(values.get(0).getAsFloat(), values.get(1).getAsFloat(), values.get(2).getAsFloat());
                    }
                    if (transformEntry.has("rotation")) {
                        values = transformEntry.get("rotation").getAsJsonArray();
                        matrix.rotateDeg(values.get(2).getAsFloat(), Vec3f.Z_AXIS);
                        matrix.rotateDeg(values.get(1).getAsFloat(), Vec3f.Y_AXIS);
                        matrix.rotateDeg(values.get(0).getAsFloat(), Vec3f.X_AXIS);
                    }
                    if (transformEntry.has("scale")) {
                        values = transformEntry.get("scale").getAsJsonArray();
                        matrix.scale(values.get(0).getAsFloat(), values.get(1).getAsFloat(), values.get(2).getAsFloat());
                    }
                    mainhandBuilder.put((Object)((String)entry.getKey()), (Object)matrix.unmodifiable());
                }
                this.mainhandCorrectionTransforms = mainhandBuilder.build();
            } else {
                this.mainhandCorrectionTransforms = GLOBAL_MAINHAND_ITEM_TRANSFORMS;
            }
            if (handEntry.has("offhand")) {
                ImmutableMap.Builder offhandBuilder = ImmutableMap.builder();
                for (Map.Entry entry : handEntry.get("offhand").getAsJsonObject().entrySet()) {
                    transformEntry = ((JsonElement)entry.getValue()).getAsJsonObject();
                    matrix = new OpenMatrix4f();
                    if (transformEntry.has("translation")) {
                        values = transformEntry.get("translation").getAsJsonArray();
                        matrix.translate(values.get(0).getAsFloat(), values.get(1).getAsFloat(), values.get(2).getAsFloat());
                    }
                    if (transformEntry.has("rotation")) {
                        values = transformEntry.get("rotation").getAsJsonArray();
                        matrix.rotateDeg(values.get(2).getAsFloat(), Vec3f.Z_AXIS);
                        matrix.rotateDeg(values.get(1).getAsFloat(), Vec3f.Y_AXIS);
                        matrix.rotateDeg(values.get(0).getAsFloat(), Vec3f.X_AXIS);
                    }
                    if (transformEntry.has("scale")) {
                        values = transformEntry.get("scale").getAsJsonArray();
                        matrix.scale(values.get(0).getAsFloat(), values.get(1).getAsFloat(), values.get(2).getAsFloat());
                    }
                    offhandBuilder.put((Object)((String)entry.getKey()), (Object)matrix.unmodifiable());
                }
                this.offhandCorrectionTransforms = offhandBuilder.build();
            } else {
                this.offhandCorrectionTransforms = GLOBAL_OFFHAND_ITEM_TRANSFORMS;
            }
        }
    }

    public void renderItemInHand(ItemStack stack, LivingEntityPatch<?> entitypatch, InteractionHand hand, OpenMatrix4f[] poses, MultiBufferSource buffer, PoseStack poseStack, int packedLight, float partialTicks) {
        OpenMatrix4f modelMatrix = this.getCorrectionMatrix(entitypatch, hand, poses);
        poseStack.pushPose();
        MathUtils.mulStack(poseStack, modelMatrix);
        ItemDisplayContext transformType = hand == InteractionHand.MAIN_HAND ? ItemDisplayContext.THIRD_PERSON_RIGHT_HAND : ItemDisplayContext.THIRD_PERSON_LEFT_HAND;
        itemInHandRenderer.renderItem((LivingEntity)entitypatch.getOriginal(), stack, transformType, hand == InteractionHand.OFF_HAND, poseStack, buffer, packedLight);
        poseStack.popPose();
    }

    public OpenMatrix4f getCorrectionMatrix(LivingEntityPatch<?> entitypatch, InteractionHand hand, OpenMatrix4f[] poses) {
        Joint parentJoint = null;
        if (this.alwaysInHand) {
            Armature armature = entitypatch.getArmature();
            if (armature instanceof ToolHolderArmature) {
                ToolHolderArmature toolArmature = (ToolHolderArmature)((Object)armature);
                Joint joint = parentJoint = hand == InteractionHand.MAIN_HAND ? toolArmature.rightToolJoint() : toolArmature.leftToolJoint();
            }
            if (parentJoint == null) {
                parentJoint = entitypatch.getArmature().rootJoint;
            }
        } else {
            parentJoint = entitypatch.getParentJointOfHand(hand);
        }
        switch (hand) {
            case MAIN_HAND: {
                this.transformHolder.load(this.mainhandCorrectionTransforms.getOrDefault(parentJoint.getName(), GLOBAL_MAINHAND_ITEM_TRANSFORMS.get(parentJoint.getName())));
                break;
            }
            case OFF_HAND: {
                this.transformHolder.load(this.offhandCorrectionTransforms.getOrDefault(parentJoint.getName(), GLOBAL_OFFHAND_ITEM_TRANSFORMS.get(parentJoint.getName())));
            }
        }
        this.transformHolder.mulFront(poses[parentJoint.getId()]);
        return this.transformHolder;
    }

    public TrailInfo trailInfo() {
        return this.trailInfo;
    }

    public boolean forceVanillaFirstPerson() {
        return this.forceVanillaFirstPerson;
    }

    public boolean appearedInAfterimage() {
        return this.appearedInAfterimage;
    }
}

