/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.client.world.capabilites.entitypatch.player;

import java.util.List;
import java.util.Optional;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.client.event.ClientPlayerNetworkEvent;
import net.neoforged.neoforge.entity.PartEntity;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;
import yesman.epicfight.api.animation.Animator;
import yesman.epicfight.api.animation.JointTransform;
import yesman.epicfight.api.animation.Keyframe;
import yesman.epicfight.api.animation.Pose;
import yesman.epicfight.api.animation.TransformSheet;
import yesman.epicfight.api.animation.property.AnimationProperty;
import yesman.epicfight.api.animation.types.ActionAnimation;
import yesman.epicfight.api.animation.types.AttackAnimation;
import yesman.epicfight.api.animation.types.DirectStaticAnimation;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.api.client.animation.AnimationSubFileReader;
import yesman.epicfight.api.client.animation.Layer;
import yesman.epicfight.api.client.animation.property.ClientAnimationProperties;
import yesman.epicfight.api.client.camera.EpicFightCameraAPI;
import yesman.epicfight.api.client.input.InputManager;
import yesman.epicfight.api.client.input.action.MinecraftInputAction;
import yesman.epicfight.api.utils.math.MathUtils;
import yesman.epicfight.client.events.engine.ControlEngine;
import yesman.epicfight.client.events.engine.RenderEngine;
import yesman.epicfight.client.gui.screen.SkillBookScreen;
import yesman.epicfight.client.world.capabilites.entitypatch.player.AbstractClientPlayerPatch;
import yesman.epicfight.config.ClientConfig;
import yesman.epicfight.gameasset.Animations;
import yesman.epicfight.network.EpicFightNetworkManager;
import yesman.epicfight.network.client.CPAnimatorControl;
import yesman.epicfight.network.client.CPChangePlayerMode;
import yesman.epicfight.network.client.CPModifyEntityModelYRot;
import yesman.epicfight.network.client.CPSetStamina;
import yesman.epicfight.network.common.AbstractAnimatorControl;
import yesman.epicfight.registry.entries.EpicFightDataComponentTypes;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;

public class LocalPlayerPatch
extends AbstractClientPlayerPatch<LocalPlayer> {
    private final Minecraft minecraft;
    private final FirstPersonLayer firstPersonLayer = new FirstPersonLayer();
    private int chargingTicksO;
    private AnimationSubFileReader.PovSettings povSettings;

    public LocalPlayerPatch(LocalPlayer entity) {
        super(entity);
        this.minecraft = Minecraft.getInstance();
    }

    public void onRespawnLocalPlayer(ClientPlayerNetworkEvent.Clone event) {
        this.onJoinWorld(event.getNewPlayer(), new EntityJoinLevelEvent((Entity)event.getNewPlayer(), event.getNewPlayer().level()));
    }

    @Override
    public void preTick(EntityTickEvent.Pre event) {
        this.chargingTicksO = this.isHoldingAny() ? this.getChargingTicks() : 0;
        super.preTick(event);
    }

    @Override
    public void postTickClient(EntityTickEvent.Post event) {
        AssetAccessor<? extends StaticAnimation> currentPlaying = this.firstPersonLayer.animationPlayer.getRealAnimation();
        boolean noPovAnimation = this.getClientAnimator().iterVisibleLayersUntilFalse(layer -> {
            if (layer.isOff()) {
                return true;
            }
            Optional<DirectStaticAnimation> optPovAnimation = layer.animationPlayer.getRealAnimation().get().getProperty(ClientAnimationProperties.POV_ANIMATION);
            Optional<AnimationSubFileReader.PovSettings> optPovSettings = layer.animationPlayer.getRealAnimation().get().getProperty(ClientAnimationProperties.POV_SETTINGS);
            optPovAnimation.ifPresent(povAnimation -> {
                if (!povAnimation.equals(currentPlaying.get())) {
                    this.firstPersonLayer.playAnimation((AssetAccessor<? extends StaticAnimation>)povAnimation, layer.animationPlayer.getRealAnimation(), this, 0.0f);
                    this.povSettings = (AnimationSubFileReader.PovSettings)optPovSettings.get();
                }
            });
            return !optPovAnimation.isPresent();
        });
        if (noPovAnimation && !currentPlaying.equals(Animations.EMPTY_ANIMATION)) {
            this.firstPersonLayer.off();
        }
        this.firstPersonLayer.update(this);
        if (this.firstPersonLayer.animationPlayer.getAnimation().equals(Animations.EMPTY_ANIMATION)) {
            this.povSettings = null;
        }
    }

    @Override
    public boolean overrideRender() {
        if (((LocalPlayer)this.original).is((Entity)this.minecraft.player) && this.minecraft.options.getCameraType().isFirstPerson() && !ClientConfig.enableAnimatedFirstPersonModel) {
            return false;
        }
        return super.overrideRender();
    }

    @Override
    public LivingEntity getTarget() {
        return EpicFightCameraAPI.getInstance().getFocusingEntity();
    }

    @Override
    public void toVanillaMode(boolean synchronize) {
        RenderEngine.getInstance().battleModeHUD.slideDown();
        if (this.playerMode != PlayerPatch.PlayerMode.VANILLA) {
            if (ClientConfig.autoSwitchCamera) {
                this.minecraft.options.setCameraType(CameraType.FIRST_PERSON);
            }
            if (synchronize) {
                EpicFightNetworkManager.sendToServer(new CPChangePlayerMode(PlayerPatch.PlayerMode.VANILLA), new CustomPacketPayload[0]);
            }
        }
        super.toVanillaMode(synchronize);
    }

    @Override
    public void toEpicFightMode(boolean synchronize) {
        RenderEngine.getInstance().battleModeHUD.slideUp();
        if (this.playerMode != PlayerPatch.PlayerMode.EPICFIGHT) {
            if (ClientConfig.autoSwitchCamera) {
                this.minecraft.options.setCameraType(CameraType.THIRD_PERSON_BACK);
            }
            if (synchronize) {
                EpicFightNetworkManager.sendToServer(new CPChangePlayerMode(PlayerPatch.PlayerMode.EPICFIGHT), new CustomPacketPayload[0]);
            }
        }
        super.toEpicFightMode(synchronize);
    }

    @Override
    public boolean isFirstPerson() {
        return this.minecraft.options.getCameraType() == CameraType.FIRST_PERSON;
    }

    @Override
    public boolean shouldBlockMoving() {
        return InputManager.isActionActive(MinecraftInputAction.MOVE_BACKWARD) || InputManager.isActionActive(MinecraftInputAction.SNEAK);
    }

    @Override
    public boolean shouldMoveOnCurrentSide(ActionAnimation actionAnimation) {
        if (!this.isLogicalClient()) {
            return false;
        }
        return actionAnimation.shouldPlayerMove(this);
    }

    public int getChargingTicksO() {
        return this.chargingTicksO;
    }

    public FirstPersonLayer getFirstPersonLayer() {
        return this.firstPersonLayer;
    }

    public AnimationSubFileReader.PovSettings getPovSettings() {
        return this.povSettings;
    }

    public boolean hasCameraAnimation() {
        return this.povSettings != null && this.povSettings.cameraTransform() != null;
    }

    @Override
    public void setStamina(float value) {
        EpicFightNetworkManager.sendToServer(new CPSetStamina(value, true), new CustomPacketPayload[0]);
    }

    @Override
    public void setModelYRot(float amount, boolean sendPacket) {
        super.setModelYRot(amount, sendPacket);
        if (sendPacket) {
            EpicFightNetworkManager.sendToServer(new CPModifyEntityModelYRot(amount), new CustomPacketPayload[0]);
        }
    }

    public float getModelYRot() {
        return this.modelYRot;
    }

    public void setModelYRotInGui(float rotDeg) {
        this.useModelYRot = true;
        this.modelYRot = rotDeg;
    }

    public void disableModelYRotInGui(float originalDeg) {
        this.useModelYRot = false;
        this.modelYRot = originalDeg;
    }

    @Override
    public void disableModelYRot(boolean sendPacket) {
        super.disableModelYRot(sendPacket);
        if (sendPacket) {
            EpicFightNetworkManager.sendToServer(new CPModifyEntityModelYRot(0.0f, true), new CustomPacketPayload[0]);
        }
    }

    @Override
    public double checkXTurn(double xRot) {
        float xRotDest;
        AnimationSubFileReader.PovSettings.ViewLimit viewLimit;
        if (xRot == 0.0) {
            return xRot;
        }
        if (ClientConfig.enablePovAction && this.minecraft.options.getCameraType().isFirstPerson() && this.isEpicFightMode() && !this.getFirstPersonLayer().isOff() && (viewLimit = this.getPovSettings().viewLimit()) != null && ((xRotDest = ((LocalPlayer)this.original).getXRot() + (float)xRot * 0.15f) <= viewLimit.xRotMin() || xRotDest >= viewLimit.xRotMax())) {
            return 0.0;
        }
        return xRot;
    }

    @Override
    public double checkYTurn(double yRot) {
        float yBody;
        float yRotClamped;
        float yCamera;
        float yRotDest;
        AnimationSubFileReader.PovSettings.ViewLimit viewLimit;
        if (yRot == 0.0) {
            return yRot;
        }
        if (ClientConfig.enablePovAction && this.minecraft.options.getCameraType().isFirstPerson() && this.isEpicFightMode() && !this.getFirstPersonLayer().isOff() && (viewLimit = this.getPovSettings().viewLimit()) != null && (yRotDest = (yCamera = Mth.wrapDegrees((float)((LocalPlayer)this.original).getYRot())) + (float)yRot * 0.15f) != (yRotClamped = Mth.clamp((float)yRotDest, (float)((yBody = MathUtils.findNearestRotation(yCamera, this.getYRot())) + viewLimit.yRotMin()), (float)(yBody + viewLimit.yRotMax())))) {
            return 0.0;
        }
        return yRot;
    }

    @Override
    public void beginAction(ActionAnimation animation) {
        EpicFightCameraAPI cameraApi = EpicFightCameraAPI.getInstance();
        if (cameraApi.isTPSMode()) {
            if (cameraApi.getFocusingEntity() != null && animation instanceof AttackAnimation) {
                cameraApi.alignPlayerLookToCrosshair(false, true, true);
            } else {
                cameraApi.alignPlayerLookToCameraRotation(false, true, true);
            }
        }
        if (!this.useModelYRot || animation.getProperty(AnimationProperty.ActionAnimationProperty.SYNC_CAMERA).orElse(false).booleanValue()) {
            this.modelYRot = ((LocalPlayer)this.original).getYRot();
        }
        if (cameraApi.getFocusingEntity() != null && cameraApi.isLockingOnTarget() && !cameraApi.getFocusingEntity().isRemoved()) {
            Vec3 playerPosition = ((LocalPlayer)this.original).position();
            Vec3 targetPosition = cameraApi.getFocusingEntity().position();
            Vec3 toTarget = targetPosition.subtract(playerPosition);
            ((LocalPlayer)this.original).setYRot((float)MathUtils.getYRotOfVector(toTarget));
        }
    }

    @Override
    public void reserveAnimation(AssetAccessor<? extends StaticAnimation> animation) {
        this.animator.reserveAnimation(animation);
        this.handleAnimationPayloadSend(new CPAnimatorControl(AbstractAnimatorControl.Action.RESERVE, animation, 0.0f, false, false, false));
    }

    @Override
    public void playAnimationInstantly(AssetAccessor<? extends StaticAnimation> animation) {
        this.animator.playAnimationInstantly(animation);
        this.handleAnimationPayloadSend(new CPAnimatorControl(AbstractAnimatorControl.Action.PLAY_INSTANTLY, animation, 0.0f, false, false, false));
    }

    @Override
    public void playShootingAnimation() {
        this.animator.playShootingAnimation();
        this.handleAnimationPayloadSend(new CPAnimatorControl(AbstractAnimatorControl.Action.SHOT, Animations.EMPTY_ANIMATION, 0.0f, false, true, false));
    }

    @Override
    public void stopPlaying(AssetAccessor<? extends StaticAnimation> animation) {
        this.animator.stopPlaying(animation);
        this.handleAnimationPayloadSend(new CPAnimatorControl(AbstractAnimatorControl.Action.STOP, animation, -1.0f, false, false, false));
    }

    @Override
    public void playAnimationSynchronized(AssetAccessor<? extends StaticAnimation> animation, float transitionTimeModifier) {
        this.handleAnimationPayloadSend(new CPAnimatorControl(AbstractAnimatorControl.Action.PLAY, animation, transitionTimeModifier, false, false, true));
    }

    @Override
    public void playAnimationInClientSide(AssetAccessor<? extends StaticAnimation> animation, float transitionTimeModifier) {
        this.animator.playAnimation(animation, transitionTimeModifier);
        this.handleAnimationPayloadSend(new CPAnimatorControl(AbstractAnimatorControl.Action.PLAY, animation, transitionTimeModifier, false, true, false));
    }

    @Override
    public void pauseAnimator(AbstractAnimatorControl.Action action, boolean pause) {
        super.pauseAnimator(action, pause);
        this.handleAnimationPayloadSend(new CPAnimatorControl(action, Animations.EMPTY_ANIMATION, 0.0f, pause, false, false));
    }

    private void handleAnimationPayloadSend(CPAnimatorControl payload) {
        if (payload.action().syncVariables()) {
            payload.animationVariables().addAll(((Animator)this.getAnimator()).getVariables().createPendingVariablesPayloads(payload.animation()));
        }
        EpicFightNetworkManager.sendToServer(payload, new CustomPacketPayload[0]);
    }

    @Override
    public void openSkillBook(ItemStack itemstack, InteractionHand hand) {
        if (itemstack.has(EpicFightDataComponentTypes.SKILL)) {
            Minecraft.getInstance().setScreen((Screen)new SkillBookScreen((Player)this.original, itemstack, hand));
        }
    }

    @Override
    public void resetHolding() {
        if (this.holdingSkill != null) {
            ControlEngine.getInstance().releaseAllServedKeys();
        }
        super.resetHolding();
    }

    @Override
    public void updateHeldItem(CapabilityItem mainHandCap, CapabilityItem offHandCap) {
        super.updateHeldItem(mainHandCap, offHandCap);
        if (ClientConfig.preferenceWork == ClientConfig.PreferenceWork.SWITCH_MODE) {
            if (ClientConfig.combatPreferredItems.contains(((LocalPlayer)this.original).getMainHandItem().getItem())) {
                this.toEpicFightMode(true);
            } else if (ClientConfig.miningPreferredItems.contains(((LocalPlayer)this.original).getMainHandItem().getItem())) {
                this.toVanillaMode(true);
            }
        }
    }

    public boolean canPlayAttackAnimation() {
        Entity hitEntity;
        HitResult hitResult;
        if (this.isVanillaMode()) {
            return false;
        }
        EpicFightCameraAPI cameraApi = EpicFightCameraAPI.getInstance();
        HitResult hitResult2 = hitResult = EpicFightCameraAPI.getInstance().isTPSMode() && cameraApi.getCrosshairHitResult() != null && cameraApi.getCrosshairHitResult().getLocation().distanceToSqr(((LocalPlayer)this.original).getEyePosition()) < ((LocalPlayer)this.original).blockInteractionRange() * ((LocalPlayer)this.original).blockInteractionRange() ? cameraApi.getCrosshairHitResult() : this.minecraft.hitResult;
        if (hitResult == null) {
            return true;
        }
        if (RenderEngine.hitResultEquals(this.minecraft.hitResult, HitResult.Type.ENTITY) && !((hitEntity = ((EntityHitResult)hitResult).getEntity()) instanceof LivingEntity) && !(hitEntity instanceof PartEntity)) {
            return false;
        }
        if (EpicFightCameraAPI.getInstance().isLockingOnTarget()) {
            return true;
        }
        if (ClientConfig.preferenceWork.checkHitResult()) {
            if (ClientConfig.combatPreferredItems.contains(((LocalPlayer)this.original).getMainHandItem().getItem())) {
                if (RenderEngine.hitResultEquals(this.minecraft.hitResult, HitResult.Type.BLOCK) && this.minecraft.level != null) {
                    BlockPos bp = ((BlockHitResult)this.minecraft.hitResult).getBlockPos();
                    BlockState bs = this.minecraft.level.getBlockState(bp);
                    return !((LocalPlayer)this.original).getMainHandItem().getItem().canAttackBlock(bs, ((LocalPlayer)this.original).level(), bp, (Player)this.original) || !((LocalPlayer)this.original).getMainHandItem().isCorrectToolForDrops(bs);
                }
            } else {
                return RenderEngine.hitResultNotEquals(this.minecraft.hitResult, HitResult.Type.BLOCK);
            }
            return true;
        }
        return this.getPlayerMode() == PlayerPatch.PlayerMode.EPICFIGHT;
    }

    @Deprecated(forRemoval=true)
    public void setLockOn(boolean targetLockedOn) {
        EpicFightCameraAPI.getInstance().setLockOn(targetLockedOn);
    }

    @Deprecated(forRemoval=true)
    public void toggleLockOn() {
        this.setLockOn(!EpicFightCameraAPI.getInstance().isLockingOnTarget());
    }

    public class FirstPersonLayer
    extends Layer {
        private final TransformSheet linkCameraTransform;

        public FirstPersonLayer() {
            super(null);
            this.linkCameraTransform = new TransformSheet(List.of(new Keyframe(0.0f, JointTransform.empty()), new Keyframe(Float.MAX_VALUE, JointTransform.empty())));
        }

        public void playAnimation(AssetAccessor<? extends StaticAnimation> nextFirstPersonAnimation, AssetAccessor<? extends StaticAnimation> originalAnimation, LivingEntityPatch<?> entitypatch, float transitionTimeModifier) {
            boolean hasNextCameraAnimation;
            Optional<AnimationSubFileReader.PovSettings> povSettings = originalAnimation.get().getProperty(ClientAnimationProperties.POV_SETTINGS);
            boolean hasPrevCameraAnimation = LocalPlayerPatch.this.povSettings != null && LocalPlayerPatch.this.povSettings.cameraTransform() != null;
            boolean bl = hasNextCameraAnimation = povSettings.isPresent() && povSettings.get().cameraTransform() != null;
            if (hasPrevCameraAnimation || hasNextCameraAnimation) {
                if (hasPrevCameraAnimation) {
                    this.linkCameraTransform.getKeyframes()[0].transform().copyFrom(LocalPlayerPatch.this.povSettings.cameraTransform().getInterpolatedTransform(this.animationPlayer.getElapsedTime()));
                } else {
                    this.linkCameraTransform.getKeyframes()[0].transform().copyFrom(JointTransform.empty());
                }
                if (hasNextCameraAnimation) {
                    this.linkCameraTransform.getKeyframes()[1].transform().copyFrom(povSettings.get().cameraTransform().getKeyframes()[0].transform());
                } else {
                    this.linkCameraTransform.getKeyframes()[1].transform().clearTransform();
                }
                this.linkCameraTransform.getKeyframes()[1].setTime(nextFirstPersonAnimation.get().getTransitionTime());
            }
            super.playAnimation(nextFirstPersonAnimation, entitypatch, transitionTimeModifier);
        }

        public void off() {
            if (LocalPlayerPatch.this.povSettings != null && LocalPlayerPatch.this.povSettings.cameraTransform() != null) {
                this.linkCameraTransform.getKeyframes()[0].transform().copyFrom(LocalPlayerPatch.this.povSettings.cameraTransform().getInterpolatedTransform(this.animationPlayer.getElapsedTime()));
                this.linkCameraTransform.getKeyframes()[1].transform().copyFrom(JointTransform.empty());
                this.linkCameraTransform.getKeyframes()[1].setTime(0.15f);
            }
            super.off(LocalPlayerPatch.this);
        }

        @Override
        protected Pose getCurrentPose(LivingEntityPatch<?> entitypatch) {
            return this.animationPlayer.isEmpty() ? super.getCurrentPose(entitypatch) : this.animationPlayer.getCurrentPose(entitypatch, 0.0f);
        }

        public TransformSheet getLinkCameraTransform() {
            return this.linkCameraTransform;
        }
    }
}

