/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.client.world.util;

import com.mojang.authlib.GameProfile;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.ChatComponent;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.multiplayer.CommonListenerCookie;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.telemetry.WorldSessionTelemetryManager;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.server.ServerLinks;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.network.connection.ConnectionType;
import org.jetbrains.annotations.NotNull;
import yesman.epicfight.main.EpicFightMod;

public class FakeLevel
extends ClientLevel {
    private static FakeLevel instance;
    private static final Map<GameProfile, FakeClientPlayer> FAKE_PLAYERS;
    private final ClientLevel refLevel;
    private boolean appliedGetBiomeManagerWorkaround;

    public static FakeLevel getFakeLevel(ClientLevel refLevel) {
        if (instance == null || instance.registryAccess() != refLevel) {
            instance = new FakeLevel(refLevel, Minecraft.getInstance());
        }
        return instance;
    }

    public static void unloadFakeLevel() {
        instance = null;
    }

    public static FakeClientPlayer getFakePlayer(GameProfile playerprofile) {
        return FAKE_PLAYERS.computeIfAbsent(playerprofile, key -> new FakeClientPlayer(instance, (GameProfile)key));
    }

    public FakeLevel(ClientLevel refLevel, Minecraft minecraft) {
        super((ClientPacketListener)new FakeClientPacketListener(refLevel, minecraft), new ClientLevel.ClientLevelData(Difficulty.NORMAL, false, false), Level.OVERWORLD, (Holder)refLevel.registryAccess().registryOrThrow(Registries.DIMENSION_TYPE).getHolderOrThrow(BuiltinDimensionTypes.OVERWORLD), 0, 0, () -> ((Minecraft)minecraft).getProfiler(), minecraft.levelRenderer, true, 0L);
        this.refLevel = refLevel;
    }

    @Nullable
    public ChunkAccess getChunk(int pX, int pZ, ChunkStatus pRequiredStatus, boolean pNonnull) {
        return this.refLevel.getChunk(pX, pZ, pRequiredStatus, pNonnull);
    }

    public boolean hasChunk(int pChunkX, int pChunkZ) {
        return this.refLevel.hasChunk(pChunkX, pChunkZ);
    }

    public int getHeight(Heightmap.Types pHeightmapType, int pX, int pZ) {
        return this.refLevel.getHeight(pHeightmapType, pX, pZ);
    }

    public int getSkyDarken() {
        return this.refLevel.getSkyDarken();
    }

    @NotNull
    public BiomeManager getBiomeManager() {
        ClientLevel level = this.refLevel;
        if (level == null) {
            if (!this.appliedGetBiomeManagerWorkaround) {
                EpicFightMod.LOGGER.warn("FakeLevel.refLevel is null, so Epic Fight can't override getBiomeManager().\nThis issue may happens when some mods are installed, such as BadOptimizations.\nFor more technical details, refer to: https://github.com/imthosea/BadOptimizations/issues/108");
            }
            this.appliedGetBiomeManagerWorkaround = true;
            return super.getBiomeManager();
        }
        return level.getBiomeManager();
    }

    public boolean isClientSide() {
        return true;
    }

    @Nullable
    public BlockEntity getBlockEntity(BlockPos pPos) {
        return this.refLevel.getBlockEntity(pPos);
    }

    public BlockState getBlockState(BlockPos bPos) {
        return this.refLevel.getBlockState(bPos);
    }

    public FluidState getFluidState(BlockPos pPos) {
        return this.refLevel.getFluidState(pPos);
    }

    public FeatureFlagSet enabledFeatures() {
        return this.refLevel.enabledFeatures();
    }

    public List<Entity> getEntities(@Nullable Entity pEntity, AABB pArea, Predicate<? super Entity> pPredicate) {
        return this.refLevel.getEntities(pEntity, pArea, pPredicate);
    }

    public <T extends Entity> List<T> getEntities(EntityTypeTest<Entity, T> pEntityTypeTest, AABB pBounds, Predicate<? super T> pPredicate) {
        return this.refLevel.getEntities(pEntityTypeTest, pBounds, pPredicate);
    }

    public List<AbstractClientPlayer> players() {
        return this.refLevel.players();
    }

    public boolean setBlock(BlockPos pPos, BlockState pState, int pFlags, int pRecursionLeft) {
        return false;
    }

    public boolean removeBlock(BlockPos pPos, boolean pIsMoving) {
        return false;
    }

    public boolean destroyBlock(BlockPos pPos, boolean pDropBlock, @Nullable Entity pEntity, int pRecursionLeft) {
        return false;
    }

    static {
        FAKE_PLAYERS = new HashMap<GameProfile, FakeClientPlayer>();
    }

    public static class FakeClientPlayer
    extends AbstractClientPlayer {
        public FakeClientPlayer(FakeLevel fakeLevel, GameProfile gameProfile) {
            super((ClientLevel)fakeLevel, gameProfile);
        }
    }

    private static class FakeClientPacketListener
    extends ClientPacketListener {
        private static final Connection DUMMY_CONNECTION = new Connection(PacketFlow.CLIENTBOUND);

        public FakeClientPacketListener(ClientLevel refLevel, Minecraft minecraft) {
            super(minecraft, DUMMY_CONNECTION, new CommonListenerCookie((GameProfile)null, (WorldSessionTelemetryManager)null, (RegistryAccess.Frozen)refLevel.registryAccess(), refLevel.enabledFeatures(), (String)null, (ServerData)null, (Screen)null, Map.of(), (ChatComponent.State)null, false, Map.of(), (ServerLinks)null, (ConnectionType)null));
        }

        public void close() {
        }
    }
}

