/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.compat;

import net.neoforged.fml.ModList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import yesman.epicfight.compat.ICompatModule;
import yesman.epicfight.compat.azurelib.AzureLibArmorCompat;
import yesman.epicfight.compat.azurelib.AzureLibCompat;
import yesman.epicfight.compat.betterthirdperson.BetterThirdPersonCompat;
import yesman.epicfight.compat.curiosapi.CuriosCompat;
import yesman.epicfight.compat.firstperson.FirstPersonCompat;
import yesman.epicfight.compat.geckolib.GeckolibCompat;
import yesman.epicfight.compat.iris.IRISCompat;
import yesman.epicfight.compat.playeranimator.PlayerAnimatorCompat;
import yesman.epicfight.compat.skinlayer3d.SkinLayer3DCompat;
import yesman.epicfight.compat.vampirism.VampirismCompat;
import yesman.epicfight.compat.werewolves.WerewolvesCompat;
import yesman.epicfight.main.EpicFightMod;

public enum MinecraftMod {
    VAMPIRISM("vampirism", false, VampirismCompat.class),
    WEREWOLVES("werewolves", false, WerewolvesCompat.class),
    CURIOS_API("curios", false, CuriosCompat.class),
    GECKO_LIB("geckolib", true, GeckolibCompat.class),
    AZURE_LIB("azurelib", true, AzureLibCompat.class),
    AZURE_LIB_ARMOR("azurelibarmor", true, AzureLibArmorCompat.class),
    FIRST_PERSON("firstperson", true, FirstPersonCompat.class),
    SKIN_LAYERS_3D("skinlayers3d", true, SkinLayer3DCompat.class),
    IRIS("iris", true, IRISCompat.class),
    PLAYER_ANIMATOR("playeranimator", true, PlayerAnimatorCompat.class),
    BETTER_THIRD_PERSON("betterthirdperson", true, BetterThirdPersonCompat.class);

    @NotNull
    private final String modId;
    private final boolean isClientOnly;
    @NotNull
    private final Class<? extends ICompatModule> compatibilityModule;

    private MinecraftMod(@NotNull String modId, boolean isClientOnly, Class<? extends ICompatModule> compatibilityModule) {
        this.modId = modId;
        this.isClientOnly = isClientOnly;
        this.compatibilityModule = compatibilityModule;
    }

    @NotNull
    public String getModId() {
        return this.modId;
    }

    public boolean isClientOnly() {
        return this.isClientOnly;
    }

    public String versionString() {
        return ModList.get().getModFileById(this.modId).versionString();
    }

    @Nullable
    public Integer getVersionComponent(@NotNull VersionComponent component) {
        String version = this.versionString();
        try {
            String[] parts = version.split("\\.");
            return Integer.parseInt(parts[component.index]);
        }
        catch (Exception e) {
            EpicFightMod.LOGGER.error("Failed to parse the '{}' mod version '{}': {}", (Object)this.name(), (Object)version, (Object)e.toString());
            return null;
        }
    }

    @NotNull
    public Class<? extends ICompatModule> getCompatibilityModule() {
        return this.compatibilityModule;
    }

    public static enum VersionComponent {
        MAJOR(0),
        MINOR(1),
        PATCH(2);

        final int index;

        private VersionComponent(int index) {
            this.index = index;
        }
    }
}

