/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.config;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.Item;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.commons.compress.utils.Lists;
import org.jetbrains.annotations.NotNull;
import yesman.epicfight.api.client.camera.EpicFightCameraAPI;
import yesman.epicfight.api.utils.CirculatableEnum;
import yesman.epicfight.api.utils.ParseUtil;
import yesman.epicfight.api.utils.math.Vec2i;
import yesman.epicfight.client.ClientEngine;
import yesman.epicfight.client.gui.ScreenCalculations;
import yesman.epicfight.client.gui.widgets.ColorSlider;
import yesman.epicfight.client.online.EpicFightServerConnectionHelper;
import yesman.epicfight.main.AuthenticationHelper;
import yesman.epicfight.main.EpicFightMod;

@EventBusSubscriber(modid="epicfight", value={Dist.CLIENT})
@OnlyIn(value=Dist.CLIENT)
public class ClientConfig {
    private static final ModConfigSpec.Builder BUILDER = new ModConfigSpec.Builder();
    public static final ModConfigSpec.BooleanValue SHOW_TARGET_INDICATOR = BUILDER.define("ingame.show_target_indicator", () -> true);
    public static final ModConfigSpec.EnumValue<HealthBarVisibility> HEALTH_BAR_VISIBILITY = BUILDER.defineEnum("ingame.health_bar_show_option", (Enum)HealthBarVisibility.HURT);
    public static final ModConfigSpec.BooleanValue SHOW_EPICFIGHT_ATTRIBUTES_IN_TOOLTIP = BUILDER.define("ingame.show_epicfight_attributes", () -> true);
    public static final ModConfigSpec.DoubleValue TARGET_OUTLINE_COLOR = BUILDER.defineInRange("ingame.target_outline_color", 0.0, 0.0, 1.0);
    public static final ModConfigSpec.EnumValue<BlockGuideOptions> MINE_BLOCK_GUIDE_OPTION = BUILDER.defineEnum("ingame.mine_block_guide_option", (Enum)BlockGuideOptions.CROSSHAIR);
    public static final ModConfigSpec.BooleanValue ENABLE_TARGET_ENTITY_GUIDE = BUILDER.define("ingame.enable_target_entity_guide", () -> true);
    public static final ModConfigSpec.BooleanValue BLOOD_EFFECTS = BUILDER.define("ingame.blood_effects", () -> true);
    public static final ModConfigSpec.IntValue MAX_STUCK_PROJECTILES = BUILDER.defineInRange("ingame.max_hit_projectiles", 30, 0, 30);
    public static final ModConfigSpec.BooleanValue ENABLE_ANIMATED_FIRST_PERSON_MODEL = BUILDER.define("ingame.first_person_model", () -> true);
    public static final ModConfigSpec.BooleanValue ENABLE_PLAYER_VANILLA_MODEL = BUILDER.define("ingame.enable_player_vanilla_model", () -> true);
    public static final ModConfigSpec.BooleanValue ENABLE_COSMETICS = BUILDER.define("ingame.enable_cosmetics", () -> true);
    public static final ModConfigSpec.BooleanValue ACTIVATE_COMPUTE_SHADER = BUILDER.define("ingame.use_compute_shader", () -> false);
    public static final ModConfigSpec.BooleanValue ENABLE_POV_ACTION = BUILDER.define("ingame.enable_pov_action", () -> true);
    public static final ModConfigSpec.ConfigValue<TPSType> CAMERA_MODE = BUILDER.defineEnum("ingame.camera.camera_mode", (Enum)TPSType.WHEN_AIMING);
    public static final ModConfigSpec.IntValue CAMERA_HORIZONTAL_LOCATION = BUILDER.defineInRange("ingame.camera.horizontal_location", -5, -10, 10);
    public static final ModConfigSpec.IntValue CAMERA_VERTICAL_LOCATION = BUILDER.defineInRange("ingame.camera.vertical_location", 0, -2, 5);
    public static final ModConfigSpec.IntValue CAMERA_ZOOM = BUILDER.defineInRange("ingame.camera.zoom", 3, 6, 10);
    public static final ModConfigSpec.IntValue LOCK_ON_RANGE = BUILDER.defineInRange("ingame.camera.lock_on_range", 20, 5, 25);
    public static final ModConfigSpec.IntValue LONG_PRESS_COUNTER = BUILDER.defineInRange("ingame.long_press_count", 2, 1, 10);
    public static final ModConfigSpec.BooleanValue AUTO_SWITCH_CAMERA = BUILDER.define("ingame.camera_auto_switch", () -> false);
    public static final ModConfigSpec.BooleanValue LOCK_ON_QUICK_SHIFT = BUILDER.define("ingame.camera.lock_on_quick_shift", () -> true);
    public static final ModConfigSpec.EnumValue<KeyConflictResolveScope> KEY_CONFLICT_RESOLVE_SCOPE = BUILDER.defineEnum("ingame.key_conflict_resolve_scope", (Enum)KeyConflictResolveScope.INTERACTION);
    public static final ModConfigSpec.EnumValue<PreferenceWork> PREFERENCE_WORK = BUILDER.defineEnum("ingame.preference_work", (Enum)PreferenceWork.ADAPTIVE);
    public static final ModConfigSpec.EnumValue<CameraPerspectiveToggleMode> CAMERA_PERSPECTIVE_TOGGLE_MODE = BUILDER.comment("Defines how the camera toggles perspectives.\n\n    1. Vanilla (Default)\n       Uses Minecraft\u2019s default behavior.\n       Cycles through all available perspectives.\n\n    2. Skip Third-Person Front Perspective\n       Skips only the front view when toggling.\n       Other perspectives remain available.\n").defineEnum("ingame.camera_perspective_toggle_mode", (Enum)CameraPerspectiveToggleMode.VANILLA);
    public static final ModConfigSpec.ConfigValue<List<? extends String>> COMBAT_PREFERRED_ITEMS = BUILDER.defineList("ingame.combat_preferred_items", (List)Lists.newArrayList(), null, element -> {
        if (element instanceof String) {
            String str = (String)element;
            return str.contains(":");
        }
        return false;
    });
    public static final ModConfigSpec.ConfigValue<List<? extends String>> MINING_PREFERRED_ITEMS = BUILDER.defineListAllowEmpty("ingame.mining_preferred_items", (List)Lists.newArrayList(), null, element -> {
        if (element instanceof String) {
            String str = (String)element;
            return str.contains(":");
        }
        return false;
    });
    public static final ModConfigSpec.ConfigValue<Integer> STAMINA_BAR_X = BUILDER.define("ingame.ui.stamina_bar_x", (Object)120);
    public static final ModConfigSpec.ConfigValue<Integer> STAMINA_BAR_Y = BUILDER.define("ingame.ui.stamina_bar_y", (Object)10);
    public static final ModConfigSpec.EnumValue<ScreenCalculations.HorizontalBasis> STAMINA_BAR_BASE_X = BUILDER.defineEnum("ingame.ui.stamina_bar_x_base", (Enum)ScreenCalculations.HorizontalBasis.RIGHT);
    public static final ModConfigSpec.EnumValue<ScreenCalculations.VerticalBasis> STAMINA_BAR_BASE_Y = BUILDER.defineEnum("ingame.ui.stamina_bar_y_base", (Enum)ScreenCalculations.VerticalBasis.BOTTOM);
    public static final ModConfigSpec.ConfigValue<Integer> WEAPON_INNATE_X = BUILDER.define("ingame.ui.weapon_innate_x", (Object)42);
    public static final ModConfigSpec.ConfigValue<Integer> WEAPON_INNATE_Y = BUILDER.define("ingame.ui.weapon_innate_y", (Object)48);
    public static final ModConfigSpec.EnumValue<ScreenCalculations.HorizontalBasis> WEAPON_INNATE_BASE_X = BUILDER.defineEnum("ingame.ui.weapon_innate_x_base", (Enum)ScreenCalculations.HorizontalBasis.RIGHT);
    public static final ModConfigSpec.EnumValue<ScreenCalculations.VerticalBasis> WEAPON_INNATE_BASE_Y = BUILDER.defineEnum("ingame.ui.weapon_innate_y_base", (Enum)ScreenCalculations.VerticalBasis.BOTTOM);
    public static final ModConfigSpec.ConfigValue<Integer> PASSIVE_X = BUILDER.define("ingame.ui.passives_x", (Object)70);
    public static final ModConfigSpec.ConfigValue<Integer> PASSIVE_Y = BUILDER.define("ingame.ui.passives_y", (Object)36);
    public static final ModConfigSpec.EnumValue<ScreenCalculations.HorizontalBasis> PASSIVE_BASE_X = BUILDER.defineEnum("ingame.ui.passives_x_base", (Enum)ScreenCalculations.HorizontalBasis.RIGHT);
    public static final ModConfigSpec.EnumValue<ScreenCalculations.VerticalBasis> PASSIVE_BASE_Y = BUILDER.defineEnum("ingame.ui.passives_y_base", (Enum)ScreenCalculations.VerticalBasis.BOTTOM);
    public static final ModConfigSpec.EnumValue<ScreenCalculations.AlignDirection> PASSIVE_ALIGN_DIRECTION = BUILDER.defineEnum("ingame.ui.passives_align_direction", (Enum)ScreenCalculations.AlignDirection.HORIZONTAL);
    public static final ModConfigSpec.ConfigValue<Integer> CHARGING_BAR_X = BUILDER.define("ingame.ui.charging_bar_x", (Object)-119);
    public static final ModConfigSpec.ConfigValue<Integer> CHARGING_BAR_Y = BUILDER.define("ingame.ui.charging_bar_y", (Object)60);
    public static final ModConfigSpec.EnumValue<ScreenCalculations.HorizontalBasis> CHARGING_BAR_BASE_X = BUILDER.defineEnum("ingame.ui.charging_bar_x_base", (Enum)ScreenCalculations.HorizontalBasis.CENTER);
    public static final ModConfigSpec.EnumValue<ScreenCalculations.VerticalBasis> CHARGING_BAR_BASE_Y = BUILDER.defineEnum("ingame.ui.charging_bar_y_base", (Enum)ScreenCalculations.VerticalBasis.CENTER);
    public static final ModConfigSpec.ConfigValue<String> ACCESS_TOKEN = BUILDER.comment("Login information for epic fight patron server. Do not change these values manually").define("access_token", (Object)"");
    public static final ModConfigSpec.ConfigValue<String> REFRESH_TOKNE = BUILDER.define("refresh_token", (Object)"");
    public static final ModConfigSpec.EnumValue<AuthenticationHelper.AuthenticationProvider> PROVIDER = BUILDER.defineEnum("provider", (Enum)AuthenticationHelper.AuthenticationProvider.NULL);
    public static final ModConfigSpec SPEC = BUILDER.build();
    public static int maxStuckProjectiles;
    public static double targetOutlineColor;
    public static int packedTargetOutlineColor;
    public static boolean bloodEffects;
    public static boolean showEpicFightAttributesInTooltip;
    public static boolean activateComputeShader;
    public static boolean enableAnimatedFirstPersonModel;
    public static BlockGuideOptions mineBlockGuideOption;
    public static boolean enableTargetEntityGuide;
    public static boolean enablePovAction;
    public static boolean enableCosmetics;
    public static boolean enableOriginalModel;
    public static int longPressCounter;
    public static boolean autoSwitchCamera;
    public static boolean lockOnQuickShift;
    public static KeyConflictResolveScope keyConflictResolveScope;
    public static PreferenceWork preferenceWork;
    public static CameraPerspectiveToggleMode cameraPerspectiveToggleMode;
    public static Set<Item> combatPreferredItems;
    public static Set<Item> miningPreferredItems;
    public static TPSType cameraMode;
    public static int cameraHorizontalLocation;
    public static int cameraVerticalLocation;
    public static int cameraZoom;
    public static int lockOnRange;
    public static boolean showTargetIndicator;
    public static HealthBarVisibility healthBarVisibility;
    public static int staminaBarX;
    public static int staminaBarY;
    public static ScreenCalculations.HorizontalBasis staminaBarBaseX;
    public static ScreenCalculations.VerticalBasis staminaBarBaseY;
    public static int weaponInnateX;
    public static int weaponInnateY;
    public static ScreenCalculations.HorizontalBasis weaponInnateBaseX;
    public static ScreenCalculations.VerticalBasis weaponInnateBaseY;
    public static int passiveX;
    public static int passiveY;
    public static ScreenCalculations.HorizontalBasis passiveBaseX;
    public static ScreenCalculations.VerticalBasis passiveBaseY;
    public static ScreenCalculations.AlignDirection passiveAlignDirection;
    public static int chargingBarX;
    public static int chargingBarY;
    public static ScreenCalculations.HorizontalBasis chargingBarBaseX;
    public static ScreenCalculations.VerticalBasis chargingBarBaseY;

    @SubscribeEvent
    static void epicfight$modConfigLoading(ModConfigEvent.Loading event) {
        if (event.getConfig().getType() != ModConfig.Type.CLIENT) {
            return;
        }
        maxStuckProjectiles = (Integer)MAX_STUCK_PROJECTILES.get();
        targetOutlineColor = (Double)TARGET_OUTLINE_COLOR.get();
        packedTargetOutlineColor = ColorSlider.rgbColor(targetOutlineColor);
        bloodEffects = (Boolean)BLOOD_EFFECTS.get();
        showEpicFightAttributesInTooltip = (Boolean)SHOW_EPICFIGHT_ATTRIBUTES_IN_TOOLTIP.get();
        activateComputeShader = (Boolean)ACTIVATE_COMPUTE_SHADER.get();
        enableAnimatedFirstPersonModel = (Boolean)ENABLE_ANIMATED_FIRST_PERSON_MODEL.get();
        mineBlockGuideOption = (BlockGuideOptions)MINE_BLOCK_GUIDE_OPTION.get();
        enableTargetEntityGuide = (Boolean)ENABLE_TARGET_ENTITY_GUIDE.get();
        enablePovAction = (Boolean)ENABLE_POV_ACTION.get();
        enableCosmetics = (Boolean)ENABLE_COSMETICS.get();
        enableOriginalModel = (Boolean)ENABLE_PLAYER_VANILLA_MODEL.get();
        cameraMode = (TPSType)CAMERA_MODE.get();
        cameraHorizontalLocation = (Integer)CAMERA_HORIZONTAL_LOCATION.get();
        cameraVerticalLocation = (Integer)CAMERA_VERTICAL_LOCATION.get();
        cameraZoom = (Integer)CAMERA_ZOOM.get();
        lockOnRange = (Integer)LOCK_ON_RANGE.get();
        longPressCounter = (Integer)LONG_PRESS_COUNTER.get();
        autoSwitchCamera = (Boolean)AUTO_SWITCH_CAMERA.get();
        lockOnQuickShift = (Boolean)LOCK_ON_QUICK_SHIFT.get();
        keyConflictResolveScope = (KeyConflictResolveScope)KEY_CONFLICT_RESOLVE_SCOPE.get();
        preferenceWork = (PreferenceWork)PREFERENCE_WORK.get();
        cameraPerspectiveToggleMode = (CameraPerspectiveToggleMode)CAMERA_PERSPECTIVE_TOGGLE_MODE.get();
        combatPreferredItems = ((List)COMBAT_PREFERRED_ITEMS.get()).stream().map(itemName -> (Item)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)itemName))).collect(Collectors.toSet());
        miningPreferredItems = ((List)MINING_PREFERRED_ITEMS.get()).stream().map(itemName -> (Item)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)itemName))).collect(Collectors.toSet());
        showTargetIndicator = (Boolean)SHOW_TARGET_INDICATOR.get();
        healthBarVisibility = (HealthBarVisibility)HEALTH_BAR_VISIBILITY.get();
        staminaBarX = (Integer)STAMINA_BAR_X.get();
        staminaBarY = (Integer)STAMINA_BAR_Y.get();
        staminaBarBaseX = (ScreenCalculations.HorizontalBasis)((Object)STAMINA_BAR_BASE_X.get());
        staminaBarBaseY = (ScreenCalculations.VerticalBasis)((Object)STAMINA_BAR_BASE_Y.get());
        weaponInnateX = (Integer)WEAPON_INNATE_X.get();
        weaponInnateY = (Integer)WEAPON_INNATE_Y.get();
        weaponInnateBaseX = (ScreenCalculations.HorizontalBasis)((Object)WEAPON_INNATE_BASE_X.get());
        weaponInnateBaseY = (ScreenCalculations.VerticalBasis)((Object)WEAPON_INNATE_BASE_Y.get());
        passiveX = (Integer)PASSIVE_X.get();
        passiveY = (Integer)PASSIVE_Y.get();
        passiveBaseX = (ScreenCalculations.HorizontalBasis)((Object)PASSIVE_BASE_X.get());
        passiveBaseY = (ScreenCalculations.VerticalBasis)((Object)PASSIVE_BASE_Y.get());
        passiveAlignDirection = (ScreenCalculations.AlignDirection)((Object)PASSIVE_ALIGN_DIRECTION.get());
        chargingBarX = (Integer)CHARGING_BAR_X.get();
        chargingBarY = (Integer)CHARGING_BAR_Y.get();
        chargingBarBaseX = (ScreenCalculations.HorizontalBasis)((Object)CHARGING_BAR_BASE_X.get());
        chargingBarBaseY = (ScreenCalculations.VerticalBasis)((Object)CHARGING_BAR_BASE_Y.get());
        if (EpicFightServerConnectionHelper.init(event.getConfig().getFullPath().getParent().toString())) {
            EpicFightMod.LOGGER.info("Epic Fight web server connection helper: supported");
            try {
                Class<?> cls = Class.forName("yesman.epicfight.epicskins.user.AuthenticationHelperImpl");
                Constructor<?> authImpl = cls.getDeclaredConstructor(new Class[0]);
                authImpl.setAccessible(true);
                Object obj = authImpl.newInstance(new Object[0]);
            }
            catch (Exception e) {
                EpicFightMod.LOGGER.info("Epic Fight web server status: Failed at initializing Authentication provider: " + String.valueOf(e));
            }
        } else {
            EpicFightMod.LOGGER.info("Epic Fight web server connection helper: unsupported");
        }
        if (EpicFightServerConnectionHelper.supported() && ClientEngine.getInstance().getAuthHelper().valid()) {
            ClientEngine.getInstance().getAuthHelper().initialize(ACCESS_TOKEN, REFRESH_TOKNE, PROVIDER);
        }
    }

    public static List<Runnable> getUnsaved() {
        ArrayList<Runnable> saveWorks = new ArrayList<Runnable>();
        if (maxStuckProjectiles != (Integer)MAX_STUCK_PROJECTILES.get()) {
            saveWorks.add(() -> MAX_STUCK_PROJECTILES.set((Object)maxStuckProjectiles));
        }
        if (targetOutlineColor != (Double)TARGET_OUTLINE_COLOR.get()) {
            saveWorks.add(() -> {
                TARGET_OUTLINE_COLOR.set((Object)targetOutlineColor);
                packedTargetOutlineColor = ColorSlider.rgbColor(targetOutlineColor);
            });
        }
        if (bloodEffects != (Boolean)BLOOD_EFFECTS.get()) {
            saveWorks.add(() -> BLOOD_EFFECTS.set((Object)bloodEffects));
        }
        if (showEpicFightAttributesInTooltip != (Boolean)SHOW_EPICFIGHT_ATTRIBUTES_IN_TOOLTIP.get()) {
            saveWorks.add(() -> SHOW_EPICFIGHT_ATTRIBUTES_IN_TOOLTIP.set((Object)showEpicFightAttributesInTooltip));
        }
        if (activateComputeShader != (Boolean)ACTIVATE_COMPUTE_SHADER.get()) {
            saveWorks.add(() -> ACTIVATE_COMPUTE_SHADER.set((Object)activateComputeShader));
        }
        if (enableAnimatedFirstPersonModel != (Boolean)ENABLE_ANIMATED_FIRST_PERSON_MODEL.get()) {
            saveWorks.add(() -> ENABLE_ANIMATED_FIRST_PERSON_MODEL.set((Object)enableAnimatedFirstPersonModel));
        }
        if (mineBlockGuideOption != MINE_BLOCK_GUIDE_OPTION.get()) {
            saveWorks.add(() -> MINE_BLOCK_GUIDE_OPTION.set((Object)mineBlockGuideOption));
        }
        if (enableTargetEntityGuide != (Boolean)ENABLE_TARGET_ENTITY_GUIDE.get()) {
            saveWorks.add(() -> ENABLE_TARGET_ENTITY_GUIDE.set((Object)enableTargetEntityGuide));
        }
        if (enablePovAction != (Boolean)ENABLE_POV_ACTION.get()) {
            saveWorks.add(() -> ENABLE_POV_ACTION.set((Object)enablePovAction));
        }
        if (enableCosmetics != (Boolean)ENABLE_COSMETICS.get()) {
            saveWorks.add(() -> ENABLE_COSMETICS.set((Object)enableCosmetics));
        }
        if (enableOriginalModel != (Boolean)ENABLE_PLAYER_VANILLA_MODEL.get()) {
            saveWorks.add(() -> ENABLE_PLAYER_VANILLA_MODEL.set((Object)enableOriginalModel));
        }
        if (cameraMode != CAMERA_MODE.get()) {
            saveWorks.add(() -> CAMERA_MODE.set((Object)cameraMode));
        }
        if (cameraHorizontalLocation != (Integer)CAMERA_HORIZONTAL_LOCATION.get()) {
            saveWorks.add(() -> CAMERA_HORIZONTAL_LOCATION.set((Object)cameraHorizontalLocation));
        }
        if (cameraVerticalLocation != (Integer)CAMERA_VERTICAL_LOCATION.get()) {
            saveWorks.add(() -> CAMERA_VERTICAL_LOCATION.set((Object)cameraVerticalLocation));
        }
        if (cameraZoom != (Integer)CAMERA_ZOOM.get()) {
            saveWorks.add(() -> CAMERA_ZOOM.set((Object)cameraZoom));
        }
        if (lockOnRange != (Integer)LOCK_ON_RANGE.get()) {
            saveWorks.add(() -> LOCK_ON_RANGE.set((Object)lockOnRange));
        }
        if (longPressCounter != (Integer)LONG_PRESS_COUNTER.get()) {
            saveWorks.add(() -> LONG_PRESS_COUNTER.set((Object)longPressCounter));
        }
        if (autoSwitchCamera != (Boolean)AUTO_SWITCH_CAMERA.get()) {
            saveWorks.add(() -> AUTO_SWITCH_CAMERA.set((Object)autoSwitchCamera));
        }
        if (lockOnQuickShift != (Boolean)LOCK_ON_QUICK_SHIFT.get()) {
            saveWorks.add(() -> LOCK_ON_QUICK_SHIFT.set((Object)lockOnQuickShift));
        }
        if (keyConflictResolveScope != KEY_CONFLICT_RESOLVE_SCOPE.get()) {
            saveWorks.add(() -> KEY_CONFLICT_RESOLVE_SCOPE.set((Object)keyConflictResolveScope));
        }
        if (preferenceWork != PREFERENCE_WORK.get()) {
            saveWorks.add(() -> PREFERENCE_WORK.set((Object)preferenceWork));
        }
        if (!combatPreferredItems.equals(((List)COMBAT_PREFERRED_ITEMS.get()).stream().map(itemName -> (Item)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)itemName))).collect(Collectors.toSet()))) {
            saveWorks.add(() -> COMBAT_PREFERRED_ITEMS.set(combatPreferredItems.stream().map(item -> BuiltInRegistries.ITEM.getKey(item).toString()).collect(Collectors.toList())));
        }
        if (!miningPreferredItems.equals(((List)MINING_PREFERRED_ITEMS.get()).stream().map(itemName -> (Item)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)itemName))).collect(Collectors.toSet()))) {
            saveWorks.add(() -> MINING_PREFERRED_ITEMS.set(miningPreferredItems.stream().map(item -> BuiltInRegistries.ITEM.getKey(item).toString()).collect(Collectors.toList())));
        }
        if (showTargetIndicator != (Boolean)SHOW_TARGET_INDICATOR.get()) {
            saveWorks.add(() -> SHOW_TARGET_INDICATOR.set((Object)showTargetIndicator));
        }
        if (healthBarVisibility != HEALTH_BAR_VISIBILITY.get()) {
            saveWorks.add(() -> HEALTH_BAR_VISIBILITY.set((Object)healthBarVisibility));
        }
        if (staminaBarX != (Integer)STAMINA_BAR_X.get()) {
            saveWorks.add(() -> STAMINA_BAR_X.set((Object)staminaBarX));
        }
        if (staminaBarY != (Integer)STAMINA_BAR_Y.get()) {
            saveWorks.add(() -> STAMINA_BAR_Y.set((Object)staminaBarY));
        }
        if (staminaBarBaseX != STAMINA_BAR_BASE_X.get()) {
            saveWorks.add(() -> STAMINA_BAR_BASE_X.set((Object)staminaBarBaseX));
        }
        if (staminaBarBaseY != STAMINA_BAR_BASE_Y.get()) {
            saveWorks.add(() -> STAMINA_BAR_BASE_Y.set((Object)staminaBarBaseY));
        }
        if (weaponInnateX != (Integer)WEAPON_INNATE_X.get()) {
            saveWorks.add(() -> WEAPON_INNATE_X.set((Object)weaponInnateX));
        }
        if (weaponInnateX != (Integer)WEAPON_INNATE_Y.get()) {
            saveWorks.add(() -> WEAPON_INNATE_Y.set((Object)weaponInnateY));
        }
        if (weaponInnateBaseX != WEAPON_INNATE_BASE_X.get()) {
            saveWorks.add(() -> WEAPON_INNATE_BASE_X.set((Object)weaponInnateBaseX));
        }
        if (weaponInnateBaseY != WEAPON_INNATE_BASE_Y.get()) {
            saveWorks.add(() -> WEAPON_INNATE_BASE_Y.set((Object)weaponInnateBaseY));
        }
        if (passiveX != (Integer)PASSIVE_X.get()) {
            saveWorks.add(() -> PASSIVE_X.set((Object)passiveX));
        }
        if (passiveY != (Integer)PASSIVE_Y.get()) {
            saveWorks.add(() -> PASSIVE_Y.set((Object)passiveY));
        }
        if (passiveBaseX != PASSIVE_BASE_X.get()) {
            saveWorks.add(() -> PASSIVE_BASE_X.set((Object)passiveBaseX));
        }
        if (passiveBaseY != PASSIVE_BASE_Y.get()) {
            saveWorks.add(() -> PASSIVE_BASE_Y.set((Object)passiveBaseY));
        }
        if (passiveAlignDirection != PASSIVE_ALIGN_DIRECTION.get()) {
            saveWorks.add(() -> PASSIVE_ALIGN_DIRECTION.set((Object)passiveAlignDirection));
        }
        if (chargingBarX != (Integer)CHARGING_BAR_X.get()) {
            saveWorks.add(() -> CHARGING_BAR_X.set((Object)chargingBarX));
        }
        if (chargingBarY != (Integer)CHARGING_BAR_Y.get()) {
            saveWorks.add(() -> CHARGING_BAR_Y.set((Object)chargingBarY));
        }
        if (chargingBarBaseX != CHARGING_BAR_BASE_X.get()) {
            saveWorks.add(() -> CHARGING_BAR_BASE_X.set((Object)chargingBarBaseX));
        }
        if (chargingBarBaseY != CHARGING_BAR_BASE_Y.get()) {
            saveWorks.add(() -> CHARGING_BAR_BASE_Y.set((Object)chargingBarBaseY));
        }
        return saveWorks;
    }

    public static void saveChanges() {
        if (maxStuckProjectiles != (Integer)MAX_STUCK_PROJECTILES.get()) {
            MAX_STUCK_PROJECTILES.set((Object)maxStuckProjectiles);
        }
        if (targetOutlineColor != (Double)TARGET_OUTLINE_COLOR.get()) {
            TARGET_OUTLINE_COLOR.set((Object)targetOutlineColor);
            packedTargetOutlineColor = ColorSlider.rgbColor(targetOutlineColor);
        }
        if (bloodEffects != (Boolean)BLOOD_EFFECTS.get()) {
            BLOOD_EFFECTS.set((Object)bloodEffects);
        }
        if (showEpicFightAttributesInTooltip != (Boolean)SHOW_EPICFIGHT_ATTRIBUTES_IN_TOOLTIP.get()) {
            SHOW_EPICFIGHT_ATTRIBUTES_IN_TOOLTIP.set((Object)showEpicFightAttributesInTooltip);
        }
        if (activateComputeShader != (Boolean)ACTIVATE_COMPUTE_SHADER.get()) {
            ACTIVATE_COMPUTE_SHADER.set((Object)activateComputeShader);
        }
        if (enableAnimatedFirstPersonModel != (Boolean)ENABLE_ANIMATED_FIRST_PERSON_MODEL.get()) {
            ENABLE_ANIMATED_FIRST_PERSON_MODEL.set((Object)enableAnimatedFirstPersonModel);
        }
        if (mineBlockGuideOption != MINE_BLOCK_GUIDE_OPTION.get()) {
            MINE_BLOCK_GUIDE_OPTION.set((Object)mineBlockGuideOption);
        }
        if (enableTargetEntityGuide != (Boolean)ENABLE_TARGET_ENTITY_GUIDE.get()) {
            ENABLE_TARGET_ENTITY_GUIDE.set((Object)enableTargetEntityGuide);
        }
        if (enablePovAction != (Boolean)ENABLE_POV_ACTION.get()) {
            ENABLE_POV_ACTION.set((Object)enablePovAction);
        }
        if (enableCosmetics != (Boolean)ENABLE_COSMETICS.get()) {
            ENABLE_COSMETICS.set((Object)enableCosmetics);
        }
        if (enableOriginalModel != (Boolean)ENABLE_PLAYER_VANILLA_MODEL.get()) {
            ENABLE_PLAYER_VANILLA_MODEL.set((Object)enableOriginalModel);
        }
        if (cameraMode != CAMERA_MODE.get()) {
            CAMERA_MODE.set((Object)cameraMode);
        }
        if (cameraHorizontalLocation != (Integer)CAMERA_HORIZONTAL_LOCATION.get()) {
            CAMERA_HORIZONTAL_LOCATION.set((Object)cameraHorizontalLocation);
        }
        if (cameraVerticalLocation != (Integer)CAMERA_VERTICAL_LOCATION.get()) {
            CAMERA_VERTICAL_LOCATION.set((Object)cameraVerticalLocation);
        }
        if (cameraZoom != (Integer)CAMERA_ZOOM.get()) {
            CAMERA_ZOOM.set((Object)cameraZoom);
        }
        if (lockOnRange != (Integer)LOCK_ON_RANGE.get()) {
            LOCK_ON_RANGE.set((Object)lockOnRange);
        }
        if (longPressCounter != (Integer)LONG_PRESS_COUNTER.get()) {
            LONG_PRESS_COUNTER.set((Object)longPressCounter);
        }
        if (autoSwitchCamera != (Boolean)AUTO_SWITCH_CAMERA.get()) {
            AUTO_SWITCH_CAMERA.set((Object)autoSwitchCamera);
        }
        if (lockOnQuickShift != (Boolean)LOCK_ON_QUICK_SHIFT.get()) {
            LOCK_ON_QUICK_SHIFT.set((Object)lockOnQuickShift);
        }
        if (keyConflictResolveScope != KEY_CONFLICT_RESOLVE_SCOPE.get()) {
            KEY_CONFLICT_RESOLVE_SCOPE.set((Object)keyConflictResolveScope);
        }
        if (preferenceWork != PREFERENCE_WORK.get()) {
            PREFERENCE_WORK.set((Object)preferenceWork);
        }
        if (cameraPerspectiveToggleMode != CAMERA_PERSPECTIVE_TOGGLE_MODE.get()) {
            CAMERA_PERSPECTIVE_TOGGLE_MODE.set((Object)cameraPerspectiveToggleMode);
            CAMERA_PERSPECTIVE_TOGGLE_MODE.save();
        }
        if (!combatPreferredItems.equals(((List)COMBAT_PREFERRED_ITEMS.get()).stream().map(itemName -> (Item)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)itemName))).collect(Collectors.toSet()))) {
            COMBAT_PREFERRED_ITEMS.set(combatPreferredItems.stream().map(item -> BuiltInRegistries.ITEM.getKey(item).toString()).collect(Collectors.toList()));
            COMBAT_PREFERRED_ITEMS.save();
        }
        if (!miningPreferredItems.equals(((List)MINING_PREFERRED_ITEMS.get()).stream().map(itemName -> (Item)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)itemName))).collect(Collectors.toSet()))) {
            MINING_PREFERRED_ITEMS.set(miningPreferredItems.stream().map(item -> BuiltInRegistries.ITEM.getKey(item).toString()).collect(Collectors.toList()));
            MINING_PREFERRED_ITEMS.save();
        }
        if (showTargetIndicator != (Boolean)SHOW_TARGET_INDICATOR.get()) {
            SHOW_TARGET_INDICATOR.set((Object)showTargetIndicator);
            SHOW_TARGET_INDICATOR.save();
        }
        if (healthBarVisibility != HEALTH_BAR_VISIBILITY.get()) {
            HEALTH_BAR_VISIBILITY.set((Object)healthBarVisibility);
            HEALTH_BAR_VISIBILITY.save();
        }
        if (staminaBarX != (Integer)STAMINA_BAR_X.get()) {
            STAMINA_BAR_X.set((Object)staminaBarX);
            STAMINA_BAR_X.save();
        }
        if (staminaBarY != (Integer)STAMINA_BAR_Y.get()) {
            STAMINA_BAR_Y.set((Object)staminaBarY);
            STAMINA_BAR_Y.save();
        }
        if (staminaBarBaseX != STAMINA_BAR_BASE_X.get()) {
            STAMINA_BAR_BASE_X.set((Object)staminaBarBaseX);
            STAMINA_BAR_BASE_X.save();
        }
        if (staminaBarBaseY != STAMINA_BAR_BASE_Y.get()) {
            STAMINA_BAR_BASE_Y.set((Object)staminaBarBaseY);
            STAMINA_BAR_BASE_Y.save();
        }
        if (weaponInnateX != (Integer)WEAPON_INNATE_X.get()) {
            WEAPON_INNATE_X.set((Object)weaponInnateX);
            WEAPON_INNATE_X.save();
        }
        if (weaponInnateX != (Integer)WEAPON_INNATE_Y.get()) {
            WEAPON_INNATE_Y.set((Object)weaponInnateY);
            WEAPON_INNATE_Y.save();
        }
        if (weaponInnateBaseX != WEAPON_INNATE_BASE_X.get()) {
            WEAPON_INNATE_BASE_X.set((Object)weaponInnateBaseX);
            WEAPON_INNATE_BASE_X.save();
        }
        if (weaponInnateBaseY != WEAPON_INNATE_BASE_Y.get()) {
            WEAPON_INNATE_BASE_Y.set((Object)weaponInnateBaseY);
            WEAPON_INNATE_BASE_Y.save();
        }
        if (passiveX != (Integer)PASSIVE_X.get()) {
            PASSIVE_X.set((Object)passiveX);
            PASSIVE_X.save();
        }
        if (passiveY != (Integer)PASSIVE_Y.get()) {
            PASSIVE_Y.set((Object)passiveY);
            PASSIVE_Y.save();
        }
        if (passiveBaseX != PASSIVE_BASE_X.get()) {
            PASSIVE_BASE_X.set((Object)passiveBaseX);
            PASSIVE_BASE_X.save();
        }
        if (passiveBaseY != PASSIVE_BASE_Y.get()) {
            PASSIVE_BASE_Y.set((Object)passiveBaseY);
            PASSIVE_BASE_Y.save();
        }
        if (passiveAlignDirection != PASSIVE_ALIGN_DIRECTION.get()) {
            PASSIVE_ALIGN_DIRECTION.set((Object)passiveAlignDirection);
            PASSIVE_ALIGN_DIRECTION.save();
        }
        if (chargingBarX != (Integer)CHARGING_BAR_X.get()) {
            CHARGING_BAR_X.set((Object)chargingBarX);
            CHARGING_BAR_X.save();
        }
        if (chargingBarY != (Integer)CHARGING_BAR_Y.get()) {
            CHARGING_BAR_Y.set((Object)chargingBarY);
            CHARGING_BAR_Y.save();
        }
        if (chargingBarBaseX != CHARGING_BAR_BASE_X.get()) {
            CHARGING_BAR_BASE_X.set((Object)chargingBarBaseX);
            CHARGING_BAR_BASE_X.save();
        }
        if (chargingBarBaseY != CHARGING_BAR_BASE_Y.get()) {
            CHARGING_BAR_BASE_Y.set((Object)chargingBarBaseY);
            CHARGING_BAR_BASE_Y.save();
        }
    }

    public static Vec2i getStaminaPosition() {
        int posX = ClientConfig.staminaBarBaseX.positionGetter.apply(Minecraft.getInstance().getWindow().getGuiScaledWidth(), staminaBarX);
        int posY = ClientConfig.staminaBarBaseY.positionGetter.apply(Minecraft.getInstance().getWindow().getGuiScaledHeight(), staminaBarY);
        return new Vec2i(posX, posY);
    }

    public static Vec2i getWeaponInnatePosition() {
        int posX = ClientConfig.weaponInnateBaseX.positionGetter.apply(Minecraft.getInstance().getWindow().getGuiScaledWidth(), weaponInnateX);
        int posY = ClientConfig.weaponInnateBaseY.positionGetter.apply(Minecraft.getInstance().getWindow().getGuiScaledHeight(), weaponInnateY);
        return new Vec2i(posX, posY);
    }

    public static Vec2i getChargingBarPosition() {
        int posX = ClientConfig.chargingBarBaseX.positionGetter.apply(Minecraft.getInstance().getWindow().getGuiScaledWidth(), chargingBarX);
        int posY = ClientConfig.chargingBarBaseY.positionGetter.apply(Minecraft.getInstance().getWindow().getGuiScaledHeight(), chargingBarY);
        return new Vec2i(posX, posY);
    }

    static {
        packedTargetOutlineColor = -1;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static enum BlockGuideOptions implements CirculatableEnum<BlockGuideOptions>,
    StringRepresentable
    {
        NONE(false, false),
        CROSSHAIR(true, false),
        HIGHLIGHT(false, true),
        CROSSHAIR_AND_HIGHLIGHT(true, true);

        final boolean showCrosshair;
        final boolean showBlockHighlight;

        private BlockGuideOptions(boolean showCrosshair, boolean showBlockHighlight) {
            this.showCrosshair = showCrosshair;
            this.showBlockHighlight = showBlockHighlight;
        }

        public boolean switchCrosshair() {
            return this.showCrosshair;
        }

        public boolean showBlockHighlight() {
            return this.showBlockHighlight;
        }

        @Override
        public BlockGuideOptions nextEnum() {
            return BlockGuideOptions.values()[(this.ordinal() + 1) % 4];
        }

        public String getSerializedName() {
            return ParseUtil.toLowerCase(this.name());
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static enum TPSType implements CirculatableEnum<TPSType>,
    StringRepresentable
    {
        ALWAYS_BACK(false, null),
        WHEN_AIMING(true, EpicFightCameraAPI::isZooming),
        ALWAYS(true, cameraApi -> true);

        final boolean hasTPSTransition;
        final Predicate<EpicFightCameraAPI> checker;

        private TPSType(boolean hasTPSTransition, Predicate<EpicFightCameraAPI> checker) {
            this.hasTPSTransition = hasTPSTransition;
            this.checker = checker;
        }

        public boolean shouldSwitch(EpicFightCameraAPI cameraApi) {
            return this.hasTPSTransition && this.checker.test(cameraApi);
        }

        public boolean hasTPSTransition() {
            return this.hasTPSTransition;
        }

        @Override
        public TPSType nextEnum() {
            return TPSType.values()[(this.ordinal() + 1) % 3];
        }

        public String getSerializedName() {
            return ParseUtil.toLowerCase(this.name());
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static enum KeyConflictResolveScope implements CirculatableEnum<KeyConflictResolveScope>,
    StringRepresentable
    {
        NONE(false, false),
        INTERACTION(true, false),
        ITEM_USE(false, true),
        INTERACTION_AND_ITEMUSE(true, true);

        final boolean cancelInteraction;
        final boolean cancelItemUse;

        private KeyConflictResolveScope(boolean cancelBlockInteraction, boolean cancelItemInteraction) {
            this.cancelInteraction = cancelBlockInteraction;
            this.cancelItemUse = cancelItemInteraction;
        }

        public boolean cancelInteraction() {
            return this.cancelInteraction;
        }

        public boolean cancelItemUse() {
            return this.cancelItemUse;
        }

        @Override
        public KeyConflictResolveScope nextEnum() {
            return KeyConflictResolveScope.values()[(this.ordinal() + 1) % 4];
        }

        public String getSerializedName() {
            return ParseUtil.toLowerCase(this.name());
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static enum PreferenceWork implements CirculatableEnum<PreferenceWork>,
    StringRepresentable
    {
        ADAPTIVE(true),
        SWITCH_MODE(false);

        final boolean checkHitResult;

        private PreferenceWork(boolean checkHitResult) {
            this.checkHitResult = checkHitResult;
        }

        public boolean checkHitResult() {
            return this.checkHitResult;
        }

        public String getSerializedName() {
            return ParseUtil.toLowerCase(this.name());
        }

        @Override
        public PreferenceWork nextEnum() {
            return PreferenceWork.values()[(this.ordinal() + 1) % 2];
        }
    }

    public static enum CameraPerspectiveToggleMode implements CirculatableEnum<CameraPerspectiveToggleMode>,
    StringRepresentable
    {
        VANILLA,
        SKIP_THIRD_PERSON_FRONT;


        @Override
        public CameraPerspectiveToggleMode nextEnum() {
            CameraPerspectiveToggleMode[] values = CameraPerspectiveToggleMode.values();
            return values[(this.ordinal() + 1) % values.length];
        }

        @NotNull
        public String getSerializedName() {
            return ParseUtil.toLowerCase(this.name());
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static enum HealthBarVisibility implements CirculatableEnum<HealthBarVisibility>,
    StringRepresentable
    {
        NONE,
        HURT,
        TARGET,
        TARGET_AND_HURT;


        @Override
        public HealthBarVisibility nextEnum() {
            return HealthBarVisibility.values()[(this.ordinal() + 1) % 4];
        }

        public String getSerializedName() {
            return ParseUtil.toLowerCase(this.name());
        }
    }
}

